/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import com.sendbird.calls.AcceptPushCommand;
import com.sendbird.calls.AcceptResponse;
import com.sendbird.calls.AnswerPushCommand;
import com.sendbird.calls.AudioStatusPushCommand;
import com.sendbird.calls.AuthenticateRequest;
import com.sendbird.calls.AuthenticateResponse;
import com.sendbird.calls.CancelPushCommand;
import com.sendbird.calls.CancelResponse;
import com.sendbird.calls.CandidatePushCommand;
import com.sendbird.calls.Command;
import com.sendbird.calls.ConnectionLostPushCommand;
import com.sendbird.calls.ConnectionLostResponse;
import com.sendbird.calls.DeclinePushCommand;
import com.sendbird.calls.DeclineResponse;
import com.sendbird.calls.DeleteCustomItemsPushCommand;
import com.sendbird.calls.DeleteCustomItemsRequest;
import com.sendbird.calls.DeleteCustomItemsResponse;
import com.sendbird.calls.DialPushCommand;
import com.sendbird.calls.DialResponse;
import com.sendbird.calls.DirectCallLogListRequest;
import com.sendbird.calls.DirectCallLogListResponse;
import com.sendbird.calls.EndPushCommand;
import com.sendbird.calls.EndResponse;
import com.sendbird.calls.ErrorResponse;
import com.sendbird.calls.LoginPushCommand;
import com.sendbird.calls.NoAnswerPushCommand;
import com.sendbird.calls.NoAnswerResponse;
import com.sendbird.calls.OfferPushCommand;
import com.sendbird.calls.OtherDeviceAcceptedPushCommand;
import com.sendbird.calls.RegisterPushTokenRequest;
import com.sendbird.calls.RegisterPushTokenResponse;
import com.sendbird.calls.RemoveCandidatesPushCommand;
import com.sendbird.calls.Request;
import com.sendbird.calls.StatsLogRequest;
import com.sendbird.calls.StatsLogResponse;
import com.sendbird.calls.TimeoutPushCommand;
import com.sendbird.calls.TimeoutResponse;
import com.sendbird.calls.UnknownEndPushCommand;
import com.sendbird.calls.UnknownEndResponse;
import com.sendbird.calls.UnregisterAllPushTokensRequest;
import com.sendbird.calls.UnregisterAllPushTokensResponse;
import com.sendbird.calls.UnregisterPushTokenRequest;
import com.sendbird.calls.UnregisterPushTokenResponse;
import com.sendbird.calls.UpdateCustomItemsPushCommand;
import com.sendbird.calls.UpdateCustomItemsRequest;
import com.sendbird.calls.UpdateCustomItemsResponse;
import com.sendbird.calls.VideoStatusPushCommand;
import com.sendbird.calls.shadow.com.google.gson.Gson;
import com.sendbird.calls.shadow.com.google.gson.JsonElement;
import com.sendbird.calls.shadow.com.google.gson.JsonObject;
import com.sendbird.calls.shadow.com.google.gson.JsonParser;

class CommandFactory {
    static final Gson sGson = new Gson();

    CommandFactory() {
    }

    private static JsonObject parseJson(String json) {
        try {
            return JsonParser.parseString(json).getAsJsonObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static Command parseApiCommand(Request request, String json) {
        boolean isError;
        JsonObject jsonObject = CommandFactory.parseJson(json);
        if (jsonObject == null) {
            return null;
        }
        boolean bl = isError = jsonObject.has("error") && jsonObject.get("error").getAsBoolean();
        if (isError) {
            return sGson.fromJson((JsonElement)jsonObject, ErrorResponse.class);
        }
        if (jsonObject.has("cmd")) {
            return CommandFactory.parseCallCommand(jsonObject);
        }
        try {
            if (request instanceof AuthenticateRequest) {
                return sGson.fromJson(json, AuthenticateResponse.class);
            }
            if (request instanceof DirectCallLogListRequest) {
                return sGson.fromJson(json, DirectCallLogListResponse.class);
            }
            if (request instanceof RegisterPushTokenRequest) {
                return sGson.fromJson(json, RegisterPushTokenResponse.class);
            }
            if (request instanceof UnregisterPushTokenRequest) {
                return sGson.fromJson(json, UnregisterPushTokenResponse.class);
            }
            if (request instanceof UnregisterAllPushTokensRequest) {
                return sGson.fromJson(json, UnregisterAllPushTokensResponse.class);
            }
            if (request instanceof UpdateCustomItemsRequest) {
                return sGson.fromJson(json, UpdateCustomItemsResponse.class);
            }
            if (request instanceof DeleteCustomItemsRequest) {
                return sGson.fromJson(json, DeleteCustomItemsResponse.class);
            }
            if (request instanceof StatsLogRequest) {
                return sGson.fromJson(json, StatsLogResponse.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    static Command parseCallCommand(String json) {
        JsonObject jsonObject = CommandFactory.parseJson(json);
        if (jsonObject == null) {
            return null;
        }
        return CommandFactory.parseCallCommand(jsonObject);
    }

    static Command parseCallCommand(JsonObject obj) {
        try {
            boolean isError;
            boolean isLogin;
            boolean bl = isLogin = obj.has("type") && "login".equals(obj.get("type").getAsString());
            if (isLogin) {
                return sGson.fromJson((JsonElement)obj, LoginPushCommand.class);
            }
            boolean bl2 = isError = obj.has("error") && obj.get("error").getAsBoolean();
            if (isError) {
                return sGson.fromJson((JsonElement)obj, ErrorResponse.class);
            }
            String requestId = obj.has("request_id") ? obj.get("request_id").getAsString() : "";
            String command = obj.has("cmd") ? obj.get("cmd").getAsString() : "";
            String type = obj.has("type") ? obj.get("type").getAsString() : "";
            String messageId = obj.has("message_id") ? obj.get("message_id").getAsString() : "";
            JsonObject data = obj.has("payload") ? obj.get("payload").getAsJsonObject() : new JsonObject();
            data.addProperty("request_id", requestId);
            data.addProperty("message_id", messageId);
            if (command.equals("CALL")) {
                switch (type) {
                    case "dial_ack": {
                        return sGson.fromJson((JsonElement)data, DialResponse.class);
                    }
                    case "dial": {
                        return sGson.fromJson((JsonElement)data, DialPushCommand.class);
                    }
                    case "cancel_ack": {
                        return sGson.fromJson((JsonElement)data, CancelResponse.class);
                    }
                    case "cancel": {
                        return sGson.fromJson((JsonElement)data, CancelPushCommand.class);
                    }
                    case "accept_ack": {
                        return sGson.fromJson((JsonElement)data, AcceptResponse.class);
                    }
                    case "accept": {
                        return sGson.fromJson((JsonElement)data, AcceptPushCommand.class);
                    }
                    case "other_device_accepted": {
                        return sGson.fromJson((JsonElement)data, OtherDeviceAcceptedPushCommand.class);
                    }
                    case "decline_ack": {
                        return sGson.fromJson((JsonElement)data, DeclineResponse.class);
                    }
                    case "decline": {
                        return sGson.fromJson((JsonElement)data, DeclinePushCommand.class);
                    }
                    case "end_ack": {
                        return sGson.fromJson((JsonElement)data, EndResponse.class);
                    }
                    case "end": {
                        return sGson.fromJson((JsonElement)data, EndPushCommand.class);
                    }
                    case "no_answer_ack": {
                        return sGson.fromJson((JsonElement)data, NoAnswerResponse.class);
                    }
                    case "no_answer": {
                        return sGson.fromJson((JsonElement)data, NoAnswerPushCommand.class);
                    }
                    case "timeout_ack": {
                        return sGson.fromJson((JsonElement)data, TimeoutResponse.class);
                    }
                    case "timeout": {
                        return sGson.fromJson((JsonElement)data, TimeoutPushCommand.class);
                    }
                    case "connection_lost_ack": {
                        return sGson.fromJson((JsonElement)data, ConnectionLostResponse.class);
                    }
                    case "connection_lost": {
                        return sGson.fromJson((JsonElement)data, ConnectionLostPushCommand.class);
                    }
                    case "unknown_end_ack": {
                        return sGson.fromJson((JsonElement)data, UnknownEndResponse.class);
                    }
                    case "unknown_end": {
                        return sGson.fromJson((JsonElement)data, UnknownEndPushCommand.class);
                    }
                }
            } else if (command.equals("SGNL")) {
                switch (type) {
                    case "offer": {
                        return sGson.fromJson((JsonElement)data, OfferPushCommand.class);
                    }
                    case "answer": {
                        return sGson.fromJson((JsonElement)data, AnswerPushCommand.class);
                    }
                    case "candidate": {
                        return sGson.fromJson((JsonElement)data, CandidatePushCommand.class);
                    }
                    case "remove_candidates": {
                        return sGson.fromJson((JsonElement)data, RemoveCandidatesPushCommand.class);
                    }
                }
            } else if (command.equals("COMM")) {
                switch (type) {
                    case "audio": {
                        return sGson.fromJson((JsonElement)data, AudioStatusPushCommand.class);
                    }
                    case "video": {
                        return sGson.fromJson((JsonElement)data, VideoStatusPushCommand.class);
                    }
                    case "custom_items_update": {
                        return sGson.fromJson((JsonElement)data, UpdateCustomItemsPushCommand.class);
                    }
                    case "custom_items_delete": {
                        return sGson.fromJson((JsonElement)data, DeleteCustomItemsPushCommand.class);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

