/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import com.sendbird.calls.DirectCallUserRole;
import com.sendbird.calls.shadow.com.google.gson.JsonObject;
import java.math.BigInteger;
import java.util.Map;
import org.webrtc.RTCStats;

class RtcStatsUtils {
    RtcStatsUtils() {
    }

    static JsonObject getCommonStats(Map<String, RTCStats> rtcStatsMap, String appId, String callId, String callerId, String calleeId, DirectCallUserRole role, boolean isVideoCall) {
        JsonObject obj = new JsonObject();
        obj.addProperty("webrtc_timestamp", (Number)RtcStatsUtils.getTimestamp(rtcStatsMap));
        obj.addProperty("device_timestamp", (Number)System.currentTimeMillis());
        obj.addProperty("network_type", RtcStatsUtils.getNetworkType(rtcStatsMap));
        obj.addProperty("app_id", appId);
        obj.addProperty("call_id", callId);
        obj.addProperty("role", role.toString());
        obj.addProperty("is_video_call", Boolean.valueOf(isVideoCall));
        obj.addProperty("caller_id", callerId);
        obj.addProperty("callee_id", calleeId);
        return obj;
    }

    static JsonObject getAudioStreamStats(Map<String, RTCStats> rtcStatsMap, long prevTotalPacketsReceived, int prevTotalPacketsLost) {
        JsonObject obj = new JsonObject();
        for (Map.Entry<String, RTCStats> entry : rtcStatsMap.entrySet()) {
            Map members;
            if (entry.getKey().startsWith("RTCInboundRTPAudioStream")) {
                if (entry.getValue() == null) continue;
                members = entry.getValue().getMembers();
                try {
                    if (members.containsKey("codecId") && members.get("codecId") instanceof String) {
                        obj.addProperty("codec", (String)rtcStatsMap.get(members.get("codecId")).getMembers().get("mimeType"));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("jitter") && members.get("jitter") instanceof Double) {
                        obj.addProperty("jitter", (Number)((int)((Double)members.get("jitter") * 1000.0)));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("packetsLost") && members.get("packetsLost") instanceof Integer) {
                        obj.addProperty("total_packets_lost", (Number)((Integer)members.get("packetsLost")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (!members.containsKey("packetsReceived") || !(members.get("packetsReceived") instanceof Long)) continue;
                    obj.addProperty("total_packets_received", (Number)((Long)members.get("packetsReceived")));
                }
                catch (Exception exception) {}
                continue;
            }
            if (entry.getKey().startsWith("RTCOutboundRTPAudioStream")) {
                if (entry.getValue() == null) continue;
                try {
                    members = entry.getValue().getMembers();
                    if (!members.containsKey("packetsSent") || !(members.get("packetsSent") instanceof Long)) continue;
                    obj.addProperty("total_packets_sent", (Number)((Long)members.get("packetsSent")));
                }
                catch (Exception members2) {}
                continue;
            }
            if (!entry.getKey().startsWith("RTCRemoteInboundRtpAudioStream")) continue;
            members = entry.getValue().getMembers();
            try {
                if (!members.containsKey("roundTripTime") || !(members.get("roundTripTime") instanceof Double)) continue;
                obj.addProperty("rtt", (Number)((int)((Double)members.get("roundTripTime") * 1000.0)));
            }
            catch (Exception exception) {}
        }
        if (obj.has("total_packets_lost") && obj.has("total_packets_received")) {
            double totalPacketsLostRate;
            if (obj.has("jitter") && obj.has("rtt")) {
                long packetsReceived;
                int packetsLost = obj.get("total_packets_lost").getAsInt() - prevTotalPacketsLost;
                double packetsLostRate = (double)packetsLost / (double)((long)packetsLost + (packetsReceived = obj.get("total_packets_received").getAsLong() - prevTotalPacketsReceived)) * 100.0;
                packetsLostRate = Double.isNaN(packetsLostRate) ? 0.0 : packetsLostRate;
                obj.addProperty("packets_lost_rate", (Number)packetsLostRate);
                double mos = RtcStatsUtils.getMos(obj.get("jitter").getAsInt(), obj.get("rtt").getAsInt() / 2, packetsLostRate);
                obj.addProperty("packets_lost", (Number)packetsLost);
                obj.addProperty("mos", (Number)mos);
            }
            totalPacketsLostRate = Double.isNaN(totalPacketsLostRate = (double)obj.get("total_packets_lost").getAsInt() / (double)((long)obj.get("total_packets_lost").getAsInt() + obj.get("total_packets_received").getAsLong()) * 100.0) ? 0.0 : totalPacketsLostRate;
            obj.addProperty("total_packets_lost_rate", (Number)totalPacketsLostRate);
        }
        return obj;
    }

    static JsonObject getVideoStreamProperties(Map<String, RTCStats> rtcStatsMap, long prevTotalPacketsReceived, int prevTotalPacketsLost) {
        JsonObject obj = new JsonObject();
        for (Map.Entry<String, RTCStats> entry : rtcStatsMap.entrySet()) {
            Map members;
            if (entry.getKey().startsWith("RTCInboundRTPVideoStream")) {
                if (entry.getValue() == null) continue;
                members = entry.getValue().getMembers();
                try {
                    if (members.containsKey("codecId") && members.get("codecId") instanceof String) {
                        obj.addProperty("codec", (String)rtcStatsMap.get(members.get("codecId")).getMembers().get("mimeType"));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("firCount") && members.get("firCount") instanceof Long) {
                        obj.addProperty("fir_count", (Number)((Long)members.get("firCount")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("pliCount") && members.get("pliCount") instanceof Long) {
                        obj.addProperty("pli_count", (Number)((Long)members.get("pliCount")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("nackCount") && members.get("nackCount") instanceof Long) {
                        obj.addProperty("nack_count", (Number)((Long)members.get("nackCount")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("qpSum") && members.get("qpSum") instanceof BigInteger) {
                        obj.addProperty("qp_sum", (Number)((BigInteger)members.get("qpSum")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("bytesReceived") && members.get("bytesReceived") instanceof BigInteger) {
                        obj.addProperty("bytes_received", (Number)((BigInteger)members.get("bytesReceived")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("packetsReceived") && members.get("packetsReceived") instanceof Long) {
                        obj.addProperty("total_packets_received", (Number)((Long)members.get("packetsReceived")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("headerBytesReceived") && members.get("headerBytesReceived") instanceof BigInteger) {
                        obj.addProperty("header_bytes_received", (Number)((BigInteger)members.get("headerBytesReceived")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("packetsLost") && members.get("packetsLost") instanceof Integer) {
                        obj.addProperty("total_packets_lost", (Number)((Integer)members.get("packetsLost")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("framesDecoded") && members.get("framesDecoded") instanceof Long) {
                        obj.addProperty("frames_decoded", (Number)((Long)members.get("framesDecoded")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("keyFramesDecoded") && members.get("keyFramesDecoded") instanceof Long) {
                        obj.addProperty("key_frames_decoded", (Number)((Long)members.get("keyFramesDecoded")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("totalInterFrameDelay") && members.get("totalInterFrameDelay") instanceof Double) {
                        obj.addProperty("total_inter_frame_delay", (Number)((Double)members.get("totalInterFrameDelay")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("totalSquaredInterFrameDelay") && members.get("totalSquaredInterFrameDelay") instanceof Double) {
                        obj.addProperty("total_squared_inter_frame_delay", (Number)((Double)members.get("totalSquaredInterFrameDelay")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (!members.containsKey("totalDecodeTime") || !(members.get("totalDecodeTime") instanceof Double)) continue;
                    obj.addProperty("total_decode_time", (Number)((Double)members.get("totalDecodeTime")));
                }
                catch (Exception exception) {}
                continue;
            }
            if (entry.getKey().startsWith("RTCMediaStreamTrack_receiver")) {
                if (entry.getValue() == null) continue;
                members = entry.getValue().getMembers();
                try {
                    if (!members.containsKey("kind") || !members.get("kind").equals("video")) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("frameWidth") && members.get("frameWidth") instanceof Long) {
                        obj.addProperty("received_frame_width", (Number)((Long)members.get("frameWidth")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("frameHeight") && members.get("frameHeight") instanceof Long) {
                        obj.addProperty("received_frame_height", (Number)((Long)members.get("frameHeight")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("framesReceived") && members.get("framesReceived") instanceof Long) {
                        obj.addProperty("frames_received", (Number)((Long)members.get("framesReceived")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("framesDropped") && members.get("framesDropped") instanceof Long) {
                        obj.addProperty("frames_dropped", (Number)((Long)members.get("framesDropped")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("freezeCount") && members.get("freezeCount") instanceof Long) {
                        obj.addProperty("freeze_count", (Number)((Long)members.get("freezeCount")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("pauseCount") && members.get("pauseCount") instanceof Long) {
                        obj.addProperty("pause_count", (Number)((Long)members.get("pauseCount")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("jitterBufferDelay") && members.get("jitterBufferDelay") instanceof Double) {
                        obj.addProperty("jitter_buffer_delay", (Number)((Double)members.get("jitterBufferDelay")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("jitterBufferEmittedCount") && members.get("jitterBufferEmittedCount") instanceof BigInteger) {
                        obj.addProperty("jitter_buffer_emitted_count", (Number)((BigInteger)members.get("jitterBufferEmittedCount")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("totalFreezesDuration") && members.get("totalFreezesDuration") instanceof Double) {
                        obj.addProperty("total_freezes_duration", (Number)((Double)members.get("totalFreezesDuration")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("totalPausesDuration") && members.get("totalPausesDuration") instanceof Double) {
                        obj.addProperty("total_pauses_duration", (Number)((Double)members.get("totalPausesDuration")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("totalFramesDuration") && members.get("totalFramesDuration") instanceof Double) {
                        obj.addProperty("total_frames_duration", (Number)((Double)members.get("totalFramesDuration")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (!members.containsKey("sumOfSquaredFramesDuration") || !(members.get("sumOfSquaredFramesDuration") instanceof Double)) continue;
                    obj.addProperty("sum_of_squared_frames_duration", (Number)((Double)members.get("sumOfSquaredFramesDuration")));
                }
                catch (Exception exception) {}
                continue;
            }
            if (entry.getKey().startsWith("RTCMediaStreamTrack_sender")) {
                if (entry.getValue() == null) continue;
                members = entry.getValue().getMembers();
                try {
                    if (!members.containsKey("kind") || !members.get("kind").equals("video")) {
                        continue;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("frameWidth") && members.get("frameWidth") instanceof Long) {
                        obj.addProperty("sent_frame_width", (Number)((Long)members.get("frameWidth")));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (!members.containsKey("frameHeight") || !(members.get("frameHeight") instanceof Long)) continue;
                    obj.addProperty("sent_frame_height", (Number)((Long)members.get("frameHeight")));
                }
                catch (Exception exception) {}
                continue;
            }
            if (!entry.getKey().startsWith("RTCVideoSource") || entry.getValue() == null) continue;
            members = entry.getValue().getMembers();
            try {
                if (members.containsKey("width") && members.get("width") instanceof Long) {
                    obj.addProperty("video_source_width", (Number)((Long)members.get("width")));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (members.containsKey("height") && members.get("height") instanceof Long) {
                    obj.addProperty("video_source_height", (Number)((Long)members.get("height")));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (!members.containsKey("framesPerSecond") || !(members.get("framesPerSecond") instanceof Long)) continue;
                obj.addProperty("video_source_frames_per_second", (Number)((Long)members.get("framesPerSecond")));
            }
            catch (Exception exception) {}
        }
        if (obj.has("total_packets_lost") && obj.has("total_packets_received")) {
            long packetsReceived;
            int packetsLost = obj.get("total_packets_lost").getAsInt() - prevTotalPacketsLost;
            double packetsLostRate = (double)packetsLost / (double)((long)packetsLost + (packetsReceived = obj.get("total_packets_received").getAsLong() - prevTotalPacketsReceived)) * 100.0;
            packetsLostRate = Double.isNaN(packetsLostRate) ? 0.0 : packetsLostRate;
            obj.addProperty("packets_lost", (Number)packetsLost);
            obj.addProperty("packets_received", (Number)packetsReceived);
            obj.addProperty("packets_lost_rate", (Number)packetsLostRate);
            double totalPacketsLostRate = (double)obj.get("total_packets_lost").getAsInt() / (double)((long)obj.get("total_packets_lost").getAsInt() + obj.get("total_packets_received").getAsLong()) * 100.0;
            totalPacketsLostRate = Double.isNaN(totalPacketsLostRate) ? 0.0 : totalPacketsLostRate;
            obj.addProperty("total_packets_lost_rate", (Number)totalPacketsLostRate);
        }
        return obj;
    }

    private static double getTimestamp(Map<String, RTCStats> rtcStatsMap) {
        for (Map.Entry<String, RTCStats> entry : rtcStatsMap.entrySet()) {
            if (entry.getKey().startsWith("RTCRemoteInbound")) continue;
            return entry.getValue().getTimestampUs();
        }
        return 0.0;
    }

    private static String getNetworkType(Map<String, RTCStats> rtcStatsMap) {
        RTCStats transportStat = rtcStatsMap.get("RTCTransport_0_1");
        if (transportStat == null) {
            return "";
        }
        try {
            String selectedCandidatePairId = (String)transportStat.getMembers().get("selectedCandidatePairId");
            RTCStats selectedCandidateStat = rtcStatsMap.get(selectedCandidatePairId);
            String localCandidateId = (String)selectedCandidateStat.getMembers().get("localCandidateId");
            RTCStats localCandidateStat = rtcStatsMap.get(localCandidateId);
            String networkType = (String)localCandidateStat.getMembers().get("networkType");
            return networkType == null ? "" : networkType;
        }
        catch (ClassCastException e) {
            return "";
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    private static double getMos(int jitter, int latency, double packetsLostRate) {
        if (jitter < 0 || latency < 0 || Double.isNaN(packetsLostRate)) {
            return 0.0;
        }
        double effectiveLatency = (double)(latency + 2 * jitter) + 10.0;
        double R = 0.0;
        R = effectiveLatency < 160.0 ? 93.2 - effectiveLatency / 40.0 : 93.2 - (effectiveLatency - 120.0) / 10.0;
        if ((R -= 2.5 * packetsLostRate) < 0.0) {
            return 1.0;
        }
        if (R >= 100.0) {
            return 4.5;
        }
        return 1.0 + 0.035 * R + 7.0E-6 * R * (R - 60.0) * (100.0 - R);
    }
}

