/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.support.annotation.NonNull;
import com.sendbird.calls.DirectCall;
import com.sendbird.calls.DirectCallAbortedState;
import com.sendbird.calls.DirectCallClosingState;
import com.sendbird.calls.DirectCallDialingState;
import com.sendbird.calls.DirectCallEndedState;
import com.sendbird.calls.DirectCallState;
import com.sendbird.calls.SendBirdException;
import com.sendbird.calls.handler.DialHandler;

class DirectCallIdleState
extends DirectCallState {
    private String mCalleeId;
    private DialHandler mDialHandler;

    DirectCallIdleState(String calleeId, DialHandler dialHandler) {
        this.mCalleeId = calleeId;
        this.mDialHandler = dialHandler;
    }

    @Override
    @NonNull
    String getStateName() {
        return DirectCallIdleState.class.getSimpleName();
    }

    @Override
    void onCreate(DirectCall call) {
        call.createPeerConnectionClient(null);
        call.sendDialRequest(this.mCalleeId);
    }

    @Override
    void onDestroy(DirectCall call) {
    }

    @Override
    void onDialAckReceived(DirectCall call, SendBirdException e) {
        super.onDialAckReceived(call, e);
        if (e != null) {
            call.changeState(new DirectCallEndedState());
        } else {
            call.changeState(new DirectCallDialingState());
        }
        if (this.mDialHandler != null) {
            this.mDialHandler.onResult(e == null ? call : null, e);
        }
    }

    @Override
    void end(DirectCall call) {
        super.end(call);
        call.abort();
        call.changeState(new DirectCallAbortedState(this.mCalleeId, this.mDialHandler));
    }

    @Override
    void unknownEnd(DirectCall call) {
        super.unknownEnd(call);
        call.sendUnknownEndRequest();
        call.changeState(new DirectCallClosingState());
    }
}

