/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.support.annotation.NonNull;
import com.sendbird.calls.DirectCall;
import com.sendbird.calls.DirectCallAnsweringState;
import com.sendbird.calls.DirectCallClosingState;
import com.sendbird.calls.DirectCallState;
import com.sendbird.calls.SendBirdException;
import com.sendbird.calls.TurnCredential;

class DirectCallAcceptingState
extends DirectCallState {
    private TurnCredential mTurnCredential;

    DirectCallAcceptingState(TurnCredential turnCredential) {
        this.mTurnCredential = turnCredential;
    }

    @Override
    @NonNull
    String getStateName() {
        return DirectCallAcceptingState.class.getSimpleName();
    }

    @Override
    void onCreate(DirectCall call) {
        call.setCallOptions();
        call.setPeerConnectionClientConfiguration(this.mTurnCredential);
        call.startAudioManager();
    }

    @Override
    void onDestroy(DirectCall call) {
    }

    @Override
    void onAcceptAckReceived(DirectCall call, SendBirdException e) {
        super.onAcceptAckReceived(call, e);
        if (e != null) {
            call.changeState(new DirectCallClosingState());
            return;
        }
        call.changeState(new DirectCallAnsweringState(null));
    }

    @Override
    void onOfferReceived(DirectCall call, String sdp) {
        super.onOfferReceived(call, sdp);
        call.changeState(new DirectCallAnsweringState(sdp));
    }

    @Override
    void end(DirectCall call) {
        super.end(call);
        call.sendEndRequest();
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void unknownEnd(DirectCall call) {
        super.unknownEnd(call);
        call.sendUnknownEndRequest();
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onCancelReceived(DirectCall call) {
        super.onCancelReceived(call);
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onTimeoutReceived(DirectCall call) {
        super.onTimeoutReceived(call);
        call.changeState(new DirectCallClosingState());
    }
}

