/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.sendbird.calls.AuthenticateParams;
import com.sendbird.calls.DialParams;
import com.sendbird.calls.DirectCall;
import com.sendbird.calls.DirectCallLogListQuery;
import com.sendbird.calls.Logger;
import com.sendbird.calls.SendBirdCallMain;
import com.sendbird.calls.SendBirdException;
import com.sendbird.calls.User;
import com.sendbird.calls.handler.AuthenticateHandler;
import com.sendbird.calls.handler.CompletionHandler;
import com.sendbird.calls.handler.CustomItemsHandler;
import com.sendbird.calls.handler.DialHandler;
import com.sendbird.calls.handler.SendBirdCallListener;
import java.util.Map;
import java.util.Set;

public class SendBirdCall {
    private static final String VERSION = "1.0.3";
    public static final int LOGGER_NONE = 0;
    public static final int LOGGER_ERROR = 1;
    private static String sAppId = "";
    private static SendBirdCallMain sInstance;
    private static final Handler sUIThreadHandler;

    static void runOnThreadOption(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        switch (Options.mThreadOption) {
            case HANDLER: {
                if (Options.mHandlerForThreadOption == null) break;
                Options.mHandlerForThreadOption.post(runnable);
                break;
            }
            default: {
                SendBirdCall.runOnUIThread(runnable);
            }
        }
    }

    static void runOnUIThread(Runnable runnable) {
        sUIThreadHandler.post(runnable);
    }

    static synchronized SendBirdCallMain getInstance() {
        if (sInstance == null) {
            Logger.e("[SendBirdCall] SendBirdCall instance hasn't been initialized. Try init().");
            throw SendBirdException.getInitRuntimeException();
        }
        return sInstance;
    }

    public static String getSdkVersion() {
        return VERSION;
    }

    public static String getApplicationId() {
        return sAppId;
    }

    public static void setLoggerLevel(int level) {
        Logger.sLevel = level;
    }

    public static synchronized boolean init(Context context, String appId) {
        Logger.d("[SendBirdCall] init(appId: " + appId + ")");
        if (context == null || appId == null || appId.length() == 0) {
            Logger.e("[SendBirdCall] init() failed.");
            return false;
        }
        if (sInstance == null) {
            sAppId = appId;
            sInstance = new SendBirdCallMain(context, appId);
        }
        if (!sAppId.equals(appId)) {
            Map<String, SendBirdCallListener> listeners = sInstance.getSendBirdCallListeners();
            sAppId = appId;
            sInstance.deauthenticate(null);
            sInstance.init(context, appId);
            for (Map.Entry<String, SendBirdCallListener> entry : listeners.entrySet()) {
                sInstance.addListener(entry.getKey(), entry.getValue());
            }
        }
        return true;
    }

    private static synchronized void init() {
        Logger.d("[SendBirdCall] init()");
        if (sInstance != null) {
            sInstance.init();
        }
    }

    public static void authenticate(AuthenticateParams params, AuthenticateHandler handler) {
        Logger.d("[SendBirdCall] authenticate(userId: " + (params != null ? params.mUserId : "") + ")");
        SendBirdCall.getInstance().authenticate(sAppId, params, handler);
    }

    public static void deauthenticate(String pushToken, CompletionHandler handler) {
        Logger.d("[SendBirdCall] deauthenticate()");
        SendBirdCall.getInstance().deauthenticate(pushToken, handler);
    }

    public static User getCurrentUser() {
        return SendBirdCall.getInstance().getCurrentUser();
    }

    public static void registerPushToken(String pushToken, boolean unique, CompletionHandler handler) {
        Logger.d("[SendBirdCall] registerPushToken(pushToken: " + pushToken + ", unique: " + unique + ")");
        SendBirdCall.getInstance().registerPushToken(pushToken, unique, handler);
    }

    public static void unregisterPushToken(String pushToken, CompletionHandler handler) {
        Logger.d("[SendBirdCall] unregisterPushToken(pushToken: " + pushToken + ")");
        SendBirdCall.getInstance().unregisterPushToken(pushToken, handler);
    }

    public static void unregisterAllPushTokens(CompletionHandler handler) {
        Logger.d("[SendBirdCall] unregisterAllPushTokens()");
        SendBirdCall.getInstance().unregisterAllPushTokens(handler);
    }

    public static void addListener(String identifier, SendBirdCallListener listener) {
        Logger.d("[SendBirdCall] addListener(" + identifier + ")");
        SendBirdCall.getInstance().addListener(identifier, listener);
    }

    public static SendBirdCallListener removeListener(String identifier) {
        Logger.d("[SendBirdCall] removeListener(" + identifier + ")");
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        return SendBirdCall.getInstance().removeListener(identifier);
    }

    public static void removeAllListeners() {
        Logger.d("[SendBirdCall] removeAllListeners()");
        SendBirdCall.getInstance().removeAllListener();
    }

    public static DirectCall dial(DialParams params, DialHandler handler) {
        Logger.d("[SendBirdCall] dial()");
        return SendBirdCall.getInstance().dial(params, handler);
    }

    public static boolean handleFirebaseMessageData(Map<String, String> data) {
        Logger.d("[SendBirdCall] handleFirebaseMessageData()");
        return SendBirdCall.getInstance().handleFirebaseMessageData(data);
    }

    public static DirectCall getCall(String callId) {
        Logger.d("[SendBirdCall] getCall(callId: " + callId + ")");
        return SendBirdCall.getInstance().getCall(callId);
    }

    public static DirectCallLogListQuery createDirectCallLogListQuery(DirectCallLogListQuery.Params params) {
        Logger.d("[SendBirdCall] createDirectCallLogListQuery()");
        return SendBirdCall.getInstance().createDirectCallLogListQuery(params);
    }

    public static void updateCustomItems(String callId, Map<String, String> customItems, CustomItemsHandler handler) {
        SendBirdCall.getInstance().updateCustomItems(callId, customItems, handler);
    }

    public static void deleteCustomItems(String callId, Set<String> customItemKeys, CustomItemsHandler handler) {
        SendBirdCall.getInstance().deleteCustomItems(callId, customItemKeys, handler);
    }

    public static void deleteAllCustomItems(String callId, CustomItemsHandler handler) {
        SendBirdCall.getInstance().deleteAllCustomItems(callId, handler);
    }

    static void setTestAppId(String appId) {
        sAppId = appId;
    }

    static {
        sUIThreadHandler = new Handler(Looper.getMainLooper());
    }

    public static class Options {
        static ThreadOption mThreadOption = ThreadOption.UI_THREAD;
        static Handler mHandlerForThreadOption;
        static int mRingingTimeoutSec;

        public static void setThreadOption(ThreadOption threadOption, Handler handler) {
            if (threadOption != null) {
                mThreadOption = threadOption;
                if (threadOption == ThreadOption.HANDLER) {
                    mHandlerForThreadOption = handler;
                }
            }
        }

        public static void setRingingTimeout(int timeout) {
            if (timeout > 0) {
                mRingingTimeoutSec = timeout;
            }
        }

        static {
            mRingingTimeoutSec = 60;
        }

        public static enum ThreadOption {
            UI_THREAD,
            HANDLER;

        }
    }
}

