/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.content.Context;
import android.support.annotation.NonNull;
import com.sendbird.calls.Command;
import com.sendbird.calls.CommandFactory;
import com.sendbird.calls.EventDeDuplicator;
import com.sendbird.calls.EventDispatcher;
import com.sendbird.calls.FcmPushCommand;
import com.sendbird.calls.Logger;
import com.sendbird.calls.WebSocketPushCommand;
import com.sendbird.calls.shadow.com.google.gson.JsonObject;

class EventReceiver {
    private EventDeDuplicator mDeDuplicator;
    private EventDispatcher mEventDispatcher;

    EventReceiver(Context context, @NonNull EventDispatcher eventDispatcher) {
        this.mDeDuplicator = new EventDeDuplicator(context);
        this.mEventDispatcher = eventDispatcher;
    }

    void onFcmPushMessageReceived(JsonObject payload) {
        Logger.d("[EventReceiver] onFcmPushMessageReceived(payload: " + payload + ")");
        Command command = CommandFactory.parseCallCommand((JsonObject)payload);
        if (command instanceof FcmPushCommand) {
            if (this.mDeDuplicator.isProcessed(((FcmPushCommand)command).getMessageId())) {
                Logger.d("[EventReceiver] onFcmPushMessageReceived() => Ignored");
            } else {
                this.mEventDispatcher.dispatch(command);
            }
        } else {
            Logger.e("[EventReceiver] Failed to parse fcm push message into FCMPushCommand.");
        }
    }

    void onWebSocketCommandReceived(WebSocketPushCommand command) {
        Logger.d("[EventReceiver] onWebSocketCommandReceived()");
        if (this.mDeDuplicator.isProcessed(command.getMessageId())) {
            Logger.d("[EventReceiver] onWebSocketCommandReceived() => Ignored");
        } else {
            this.mEventDispatcher.dispatch((Command)command);
        }
    }

    void dispatch(Command command) {
        this.mEventDispatcher.dispatch(command);
    }
}

