/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.support.annotation.NonNull;
import com.sendbird.calls.DirectCall;
import com.sendbird.calls.DirectCallClosingState;
import com.sendbird.calls.DirectCallReconnectingState;
import com.sendbird.calls.DirectCallState;

class DirectCallConnectedState
extends DirectCallState {
    private boolean mIsReconnected;

    DirectCallConnectedState(boolean isReconnected) {
        this.mIsReconnected = isReconnected;
    }

    @Override
    @NonNull
    String getStateName() {
        return DirectCallConnectedState.class.getSimpleName();
    }

    @Override
    void onCreate(DirectCall call) {
        if (this.mIsReconnected) {
            call.dispatchEvent(DirectCall.DirectCallEventType.RECONNECTED);
        } else {
            call.dispatchEvent(DirectCall.DirectCallEventType.CONNECTED);
        }
    }

    @Override
    void onDestroy(DirectCall call) {
    }

    @Override
    void onOfferReceived(DirectCall call, String sdp) {
        super.onOfferReceived(call, sdp);
        call.changeState(new DirectCallReconnectingState(sdp));
    }

    @Override
    void onIceDisconnected(DirectCall call) {
        super.onIceDisconnected(call);
        call.changeState(new DirectCallReconnectingState(null));
    }

    @Override
    void onIceFailed(DirectCall call) {
        super.onIceFailed(call);
        call.changeState(new DirectCallReconnectingState(null));
    }

    @Override
    void end(DirectCall call) {
        super.end(call);
        call.sendEndRequest();
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void unknownEnd(DirectCall call) {
        super.unknownEnd(call);
        call.sendUnknownEndRequest();
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onEndReceived(DirectCall call) {
        super.onEndReceived(call);
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onConnectionLostReceived(DirectCall call) {
        super.onConnectionLostReceived(call);
        call.changeState(new DirectCallClosingState());
    }
}

