/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.sendbird.calls.AcceptParams;
import com.sendbird.calls.AcceptPushCommand;
import com.sendbird.calls.AcceptRequest;
import com.sendbird.calls.AliveRequest;
import com.sendbird.calls.AnswerPushCommand;
import com.sendbird.calls.AnswerRequest;
import com.sendbird.calls.AudioDevice;
import com.sendbird.calls.AudioStatusPushCommand;
import com.sendbird.calls.AudioStatusRequest;
import com.sendbird.calls.BaseCall;
import com.sendbird.calls.BroadcastListener;
import com.sendbird.calls.CallOptions;
import com.sendbird.calls.CancelPushCommand;
import com.sendbird.calls.CancelRequest;
import com.sendbird.calls.CancelResponse;
import com.sendbird.calls.Candidate;
import com.sendbird.calls.CandidatePushCommand;
import com.sendbird.calls.CandidateRequest;
import com.sendbird.calls.Command;
import com.sendbird.calls.CommandSender;
import com.sendbird.calls.ConnectionLostPushCommand;
import com.sendbird.calls.ConnectionLostRequest;
import com.sendbird.calls.ConnectionLostResponse;
import com.sendbird.calls.Constraints;
import com.sendbird.calls.DeclinePushCommand;
import com.sendbird.calls.DeclineRequest;
import com.sendbird.calls.DeclineResponse;
import com.sendbird.calls.DeleteCustomItemsPushCommand;
import com.sendbird.calls.DeleteCustomItemsRequest;
import com.sendbird.calls.DeleteCustomItemsResponse;
import com.sendbird.calls.DialParams;
import com.sendbird.calls.DialPushCommand;
import com.sendbird.calls.DialRequest;
import com.sendbird.calls.DialResponse;
import com.sendbird.calls.DirectCallCanceledState;
import com.sendbird.calls.DirectCallEndListener;
import com.sendbird.calls.DirectCallEndResult;
import com.sendbird.calls.DirectCallIdleState;
import com.sendbird.calls.DirectCallLog;
import com.sendbird.calls.DirectCallRingingState;
import com.sendbird.calls.DirectCallState;
import com.sendbird.calls.DirectCallUser;
import com.sendbird.calls.DirectCallUserRole;
import com.sendbird.calls.EndPushCommand;
import com.sendbird.calls.EndRequest;
import com.sendbird.calls.EndResponse;
import com.sendbird.calls.Logger;
import com.sendbird.calls.NoAnswerPushCommand;
import com.sendbird.calls.NoAnswerRequest;
import com.sendbird.calls.NoAnswerResponse;
import com.sendbird.calls.OfferPushCommand;
import com.sendbird.calls.OfferRequest;
import com.sendbird.calls.OtherDeviceAcceptedPushCommand;
import com.sendbird.calls.PeerConnectionClient;
import com.sendbird.calls.PeerConnectionClientFactory;
import com.sendbird.calls.PeerConnectionEvents;
import com.sendbird.calls.PendingStatusRequests;
import com.sendbird.calls.RemoveCandidatesPushCommand;
import com.sendbird.calls.RemoveCandidatesRequest;
import com.sendbird.calls.RingingListener;
import com.sendbird.calls.RtcStatsUtils;
import com.sendbird.calls.SendBirdCall;
import com.sendbird.calls.SendBirdException;
import com.sendbird.calls.SendBirdVideoView;
import com.sendbird.calls.StatsLogRequest;
import com.sendbird.calls.StringUtils;
import com.sendbird.calls.TimeoutPushCommand;
import com.sendbird.calls.TimeoutRequest;
import com.sendbird.calls.TimeoutResponse;
import com.sendbird.calls.TurnCredential;
import com.sendbird.calls.UnknownEndPushCommand;
import com.sendbird.calls.UnknownEndRequest;
import com.sendbird.calls.UnknownEndResponse;
import com.sendbird.calls.UpdateCustomItemsPushCommand;
import com.sendbird.calls.UpdateCustomItemsRequest;
import com.sendbird.calls.UpdateCustomItemsResponse;
import com.sendbird.calls.VideoDevice;
import com.sendbird.calls.VideoStatusPushCommand;
import com.sendbird.calls.VideoStatusRequest;
import com.sendbird.calls.handler.CompletionHandler;
import com.sendbird.calls.handler.CustomItemsHandler;
import com.sendbird.calls.handler.DialHandler;
import com.sendbird.calls.handler.DirectCallListener;
import com.sendbird.calls.shadow.com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.webrtc.IceCandidate;
import org.webrtc.PeerConnection;
import org.webrtc.RTCStats;
import org.webrtc.SessionDescription;
import org.webrtc.StatsReport;

public class DirectCall
extends BaseCall {
    private static final boolean ENABLE_STATS_EVENTS = true;
    private static final long ALIVE_INTERVAL = 10000L;
    private Context mContext;
    private CommandSender mCommandSender;
    private RingingListener mRingingListener;
    private BroadcastListener mBroadcastListener;
    private DirectCallEndListener mEndListener;
    private CallOptions mCallOptions;
    private boolean mIsVideoCall;
    private boolean mAmICallee;
    private DirectCallUserRole mMyRole;
    private String mCallId;
    private DirectCallUser mCaller;
    private DirectCallUser mCallee;
    private Map<String, String> mCustomItems;
    private long mCustomItemsLastAffectedAt = 0L;
    private PeerConnectionClient mPeerConnectionClient;
    private List<String> mTurnUrls = new ArrayList<String>();
    private long mStartTimestamp = 0L;
    private long mEndTimestamp = 0L;
    private DirectCallEndResult mEndResult = DirectCallEndResult.NONE;
    private DirectCallUser mEndedBy;
    private long mDuration;
    private DirectCallState mCurrentState;
    private Timer mStateTimer = new Timer();
    private Timer mAliveTimer = new Timer();
    private DirectCallListener mListener;
    private boolean mIsLocalVideoEnabled = true;
    private boolean mIsRemoteVideoEnabled = true;
    private boolean mIsLocalAudioEnabled = true;
    private boolean mIsRemoteAudioEnabled = true;
    private ExecutorService mSingleThreadExecutor = Executors.newSingleThreadExecutor();
    private PendingStatusRequests mPendingStatusRequests = new PendingStatusRequests();
    private PeerConnectionEvents mPeerConnectionEvents = new PeerConnectionEvents(){
        private int mPrevTotalAudioPacketsLost = 0;
        private long mPrevTotalAudioPacketsReceived = 0L;
        private int mPrevTotalVideoPacketsLost = 0;
        private long mPrevTotalVideoPacketsReceived = 0L;

        @Override
        public void onLocalDescription(boolean isInitiator, SessionDescription sdp) {
            Logger.d(DirectCall.this.tag() + "[PCE] onLocalDescription()");
            if (sdp != null && sdp.description != null) {
                StringUtils.compress(sdp.description, result -> {
                    if (result != null && result.length() > 0) {
                        if (isInitiator) {
                            DirectCall.this.sendOfferRequest(result);
                        } else {
                            DirectCall.this.sendAnswerRequest(result);
                        }
                    }
                });
            }
        }

        @Override
        public void onIceCandidate(IceCandidate candidate) {
            Logger.d(DirectCall.this.tag() + "[PCE] onIceCandidate(" + (candidate != null ? candidate.toString() : null) + ")");
            if (candidate != null && candidate.sdp != null && candidate.sdp.contains("typ relay")) {
                DirectCall.this.sendCandidateRequest(candidate);
            }
        }

        @Override
        public void onIceCandidatesRemoved(IceCandidate[] candidates) {
            Logger.d(DirectCall.this.tag() + "[PCE] onIceCandidatesRemoved(" + (candidates != null ? candidates.length : 0) + ")");
            if (candidates != null) {
                DirectCall.this.sendRemoveCandidatesRequest(candidates);
            }
        }

        @Override
        public void onIceConnected() {
            Logger.d(DirectCall.this.tag() + "[PCE] onIceConnected()");
            DirectCall.this.runOnSingleThreadPool(() -> DirectCall.this.mCurrentState.onIceConnected(DirectCall.this));
        }

        @Override
        public void onConnected() {
            Logger.d(DirectCall.this.tag() + "[PCE] onConnected()");
            if (DirectCall.this.mPeerConnectionClient != null) {
                DirectCall.this.mPeerConnectionClient.enableStatsEvents();
            }
        }

        @Override
        public void onIceDisconnected() {
            Logger.d(DirectCall.this.tag() + "[PCE] onIceDisconnected()");
            DirectCall.this.runOnSingleThreadPool(() -> DirectCall.this.mCurrentState.onIceDisconnected(DirectCall.this));
        }

        @Override
        public void onIceFailed() {
            Logger.d(DirectCall.this.tag() + "[PCE] onIceFailed()");
            DirectCall.this.runOnSingleThreadPool(() -> DirectCall.this.mCurrentState.onIceFailed(DirectCall.this));
        }

        @Override
        public void onDisconnected() {
            Logger.d(DirectCall.this.tag() + "[PCE] onDisconnected()");
        }

        @Override
        public void onFailed() {
            Logger.d(DirectCall.this.tag() + "[PCE] onFailed()");
        }

        @Override
        public void onPeerConnectionClosed() {
            Logger.d(DirectCall.this.tag() + "[PCE] onPeerConnectionClosed()");
            DirectCall.this.runOnSingleThreadPool(() -> DirectCall.this.mCurrentState.onClosed(DirectCall.this));
        }

        @Override
        public void onPeerConnectionStatsReady(StatsReport[] reports) {
        }

        @Override
        public void onPeerConnectionError(String description) {
            Logger.e(DirectCall.this.tag() + "[PCE] onPeerConnectionError() => " + description);
            DirectCall.this.runOnSingleThreadPool(() -> DirectCall.this.mCurrentState.unknownEnd(DirectCall.this));
        }

        @Override
        public void onPeerConnectionAudioError(String description) {
            Logger.e(DirectCall.this.tag() + "[PCE] onPeerConnectionAudioError() => " + description);
        }

        @Override
        public void onRtcStatsEvent(Map<String, RTCStats> rtcStatsMap) {
            String callerId = DirectCall.this.mCaller != null ? DirectCall.this.mCaller.getUserId() : "";
            String calleeId = DirectCall.this.mCallee != null ? DirectCall.this.mCallee.getUserId() : "";
            JsonObject commonStat = RtcStatsUtils.getCommonStats(rtcStatsMap, SendBirdCall.getApplicationId(), DirectCall.this.mCallId, callerId, calleeId, DirectCall.this.mMyRole, DirectCall.this.mIsVideoCall);
            JsonObject audioStreamStat = RtcStatsUtils.getAudioStreamStats(rtcStatsMap, this.mPrevTotalAudioPacketsReceived, this.mPrevTotalAudioPacketsLost);
            JsonObject videoStreamStat = RtcStatsUtils.getVideoStreamProperties(rtcStatsMap, this.mPrevTotalVideoPacketsReceived, this.mPrevTotalVideoPacketsLost);
            if (audioStreamStat.has("total_packets_lost")) {
                this.mPrevTotalAudioPacketsLost = audioStreamStat.get("total_packets_lost").getAsInt();
            }
            if (audioStreamStat.has("total_packets_received")) {
                this.mPrevTotalAudioPacketsReceived = audioStreamStat.get("total_packets_received").getAsLong();
            }
            if (videoStreamStat.has("total_packets_lost")) {
                this.mPrevTotalVideoPacketsLost = videoStreamStat.get("total_packets_lost").getAsInt();
            }
            if (videoStreamStat.has("total_packets_received")) {
                this.mPrevTotalVideoPacketsReceived = videoStreamStat.get("total_packets_received").getAsLong();
            }
            StatsLogRequest request = new StatsLogRequest(commonStat, audioStreamStat, videoStreamStat);
            DirectCall.this.mCommandSender.send((Command)request, null);
        }
    };

    DirectCall(Context context, CommandSender sender, @NonNull DialParams params, DialHandler dialHandler, RingingListener ringingListener, BroadcastListener broadcastListener) {
        Logger.d("[DirectCall] DirectCall() as caller");
        this.mContext = context;
        this.mCommandSender = sender;
        this.mRingingListener = ringingListener;
        this.mBroadcastListener = broadcastListener;
        this.mIsVideoCall = params.mIsVideoCall;
        this.mAmICallee = false;
        this.mMyRole = DirectCallUserRole.CALLER;
        this.mCallOptions = params.mCallOptions;
        this.mCustomItems = params.mCustomItems;
        this.setLocalVideoEnabled(params.mCallOptions.mVideoEnabled);
        this.setLocalAudioEnabled(params.mCallOptions.mAudioEnabled);
        this.mCurrentState = new DirectCallIdleState(params.mCalleeId, dialHandler);
        this.mCurrentState.onCreate(this);
    }

    DirectCall(Context context, CommandSender sender, DialPushCommand command, RingingListener ringingListener, BroadcastListener broadcastListener) {
        Logger.d("[DirectCall] DirectCall(command: DialPushCommand) as callee");
        this.mContext = context;
        this.mCommandSender = sender;
        this.mRingingListener = ringingListener;
        this.mBroadcastListener = broadcastListener;
        this.mIsVideoCall = command.isVideoCall();
        this.mAmICallee = true;
        this.mMyRole = DirectCallUserRole.CALLEE;
        this.mCallId = command.getCallId();
        this.mCaller = command.getCaller();
        this.mCallee = command.getCallee();
        this.mCustomItems = command.getCustomItems();
        this.setRemoteConstraints(command.getConstraints());
        this.mCurrentState = new DirectCallRingingState(command.getTurnCredential());
        this.mCurrentState.onCreate(this);
    }

    DirectCall(Context context, CommandSender sender, CancelPushCommand command, RingingListener ringingListener, BroadcastListener broadcastListener) {
        Logger.d("[DirectCall] DirectCall(command: CancelPushCommand) as callee");
        this.mContext = context;
        this.mCommandSender = sender;
        this.mRingingListener = ringingListener;
        this.mBroadcastListener = broadcastListener;
        this.mIsVideoCall = command.getEndedCallLog().isVideoCall();
        this.mAmICallee = true;
        this.mMyRole = DirectCallUserRole.CALLEE;
        this.mCallId = command.getCallId();
        this.mCaller = command.getEndedCallLog().getCaller();
        this.mCallee = command.getEndedCallLog().getCallee();
        this.setEndedCall(DirectCallEndResult.CANCELED, command.getEndedCallLog());
        this.mCurrentState = new DirectCallCanceledState();
        this.mCurrentState.onCreate(this);
    }

    public String getCallId() {
        return this.mCallId;
    }

    public boolean isVideoCall() {
        return this.mIsVideoCall;
    }

    public DirectCallUser getCaller() {
        return this.mCaller;
    }

    public DirectCallUser getCallee() {
        return this.mCallee;
    }

    public DirectCallUser getLocalUser() {
        if (this.mAmICallee) {
            return this.mCallee;
        }
        return this.mCaller;
    }

    public DirectCallUser getRemoteUser() {
        if (this.mAmICallee) {
            return this.mCaller;
        }
        return this.mCallee;
    }

    public DirectCallUserRole getMyRole() {
        return this.mMyRole;
    }

    public DirectCallUser getEndedBy() {
        return this.mEndedBy;
    }

    public DirectCallEndResult getEndResult() {
        return this.mEndResult;
    }

    public long getDuration() {
        long duration = this.mDuration;
        if (duration == 0L && this.mStartTimestamp > 0L) {
            duration = Math.max(System.currentTimeMillis() - this.mStartTimestamp, 0L);
        }
        return duration;
    }

    public void setListener(DirectCallListener listener) {
        Logger.d(this.tag() + "setListener()");
        this.mListener = listener;
    }

    public void accept(AcceptParams params) {
        Logger.d(this.tag() + "accept()");
        if (params == null) {
            params = new AcceptParams();
        }
        if (params.mCallOptions == null) {
            params.mCallOptions = new CallOptions();
        }
        AcceptParams finalParams = params;
        this.runOnSingleThreadPool(() -> this.mCurrentState.accept(this, finalParams));
    }

    public void end() {
        Logger.d(this.tag() + "end()");
        this.runOnSingleThreadPool(() -> this.mCurrentState.end(this));
    }

    public boolean isEnded() {
        return this.mEndResult != DirectCallEndResult.NONE;
    }

    public boolean isLocalVideoEnabled() {
        return this.mIsLocalVideoEnabled;
    }

    public boolean isRemoteVideoEnabled() {
        return this.mIsRemoteVideoEnabled;
    }

    public boolean isLocalAudioEnabled() {
        return this.mIsLocalAudioEnabled;
    }

    public boolean isRemoteAudioEnabled() {
        return this.mIsRemoteAudioEnabled;
    }

    void sendPendingStatusRequests() {
        this.mPendingStatusRequests.send(this.mCommandSender, this.mCallId, this.mCallOptions.mVideoEnabled, this.mCallOptions.mAudioEnabled);
    }

    public boolean stopVideo() {
        Logger.d(this.tag() + "stopVideo()");
        if (this.mPeerConnectionClient != null && this.mIsVideoCall) {
            boolean isApplied = this.mPeerConnectionClient.setVideoEnabled(false);
            if (isApplied) {
                this.setLocalVideoEnabled(false);
                if (this.mCallId != null) {
                    this.mCommandSender.send((Command)new VideoStatusRequest(this.mCallId, false), null);
                } else {
                    this.mPendingStatusRequests.setLocalVideoEnabled(false);
                }
            }
            return isApplied;
        }
        return false;
    }

    public boolean startVideo() {
        Logger.d(this.tag() + "startVideo()");
        if (this.mPeerConnectionClient != null && this.mIsVideoCall) {
            boolean isApplied = this.mPeerConnectionClient.setVideoEnabled(true);
            if (isApplied) {
                this.setLocalVideoEnabled(true);
                if (this.mCallId != null) {
                    this.mCommandSender.send((Command)new VideoStatusRequest(this.mCallId, true), null);
                } else {
                    this.mPendingStatusRequests.setLocalVideoEnabled(true);
                }
            }
            return isApplied;
        }
        return false;
    }

    public boolean muteMicrophone() {
        Logger.d(this.tag() + "muteMicrophone()");
        if (this.mPeerConnectionClient != null) {
            boolean isApplied = this.mPeerConnectionClient.setAudioEnabled(false);
            if (isApplied) {
                this.setLocalAudioEnabled(false);
                if (this.mCallId != null) {
                    this.mCommandSender.send((Command)new AudioStatusRequest(this.mCallId, false), null);
                } else {
                    this.mPendingStatusRequests.setLocalAudioEnabled(false);
                }
            }
            return isApplied;
        }
        return false;
    }

    public boolean unmuteMicrophone() {
        Logger.d(this.tag() + "unmuteMicrophone()");
        if (this.mPeerConnectionClient != null) {
            boolean isApplied = this.mPeerConnectionClient.setAudioEnabled(true);
            if (isApplied) {
                this.setLocalAudioEnabled(true);
                if (this.mCallId != null) {
                    this.mCommandSender.send((Command)new AudioStatusRequest(this.mCallId, true), null);
                } else {
                    this.mPendingStatusRequests.setLocalAudioEnabled(true);
                }
            }
            return isApplied;
        }
        return false;
    }

    public AudioDevice getCurrentAudioDevice() {
        AudioDevice audioDevice = null;
        if (this.mPeerConnectionClient != null) {
            audioDevice = this.mPeerConnectionClient.getCurrentAudioDevice();
        }
        Logger.d(this.tag() + "getCurrentAudioDevice() => " + (Object)((Object)audioDevice));
        return audioDevice;
    }

    public Set<AudioDevice> getAvailableAudioDevices() {
        HashSet<AudioDevice> audioDevices = new HashSet();
        if (this.mPeerConnectionClient != null) {
            audioDevices = this.mPeerConnectionClient.getAvailableAudioDevices();
        }
        Logger.d(this.tag() + "getAvailableAudioDevices() => " + audioDevices);
        return audioDevices;
    }

    public void selectAudioDevice(AudioDevice audioDevice, CompletionHandler handler) {
        SendBirdCall.runOnUIThread(() -> {
            boolean result = false;
            if (this.mPeerConnectionClient != null) {
                result = this.mPeerConnectionClient.selectAudioDevice(audioDevice);
            }
            SendBirdException e = result ? null : SendBirdException.getSendBirdException(1800402);
            SendBirdCall.runOnThreadOption(() -> {
                if (handler != null) {
                    handler.onResult(e);
                }
            });
        });
    }

    public List<VideoDevice> getAvailableVideoDevices() {
        ArrayList<VideoDevice> videoDevices = new ArrayList();
        if (this.mPeerConnectionClient != null) {
            videoDevices = this.mPeerConnectionClient.getAvailableVideoDevices();
        }
        Logger.d(this.tag() + "getAvailableVideoDevices() => " + videoDevices);
        return videoDevices;
    }

    public void selectVideoDevice(VideoDevice videoDevice, CompletionHandler handler) {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.switchCamera(videoDevice, e -> SendBirdCall.runOnThreadOption(() -> {
                if (handler != null) {
                    handler.onResult(null);
                }
            }));
        } else {
            SendBirdCall.runOnThreadOption(() -> {
                if (handler != null) {
                    handler.onResult(SendBirdException.getSendBirdException(1800401));
                }
            });
        }
    }

    public void switchCamera(CompletionHandler handler) {
        Logger.d(this.tag() + "switchCamera()");
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.switchCamera(e -> SendBirdCall.runOnThreadOption(() -> {
                if (handler != null) {
                    handler.onResult(e);
                }
            }));
        } else {
            SendBirdCall.runOnThreadOption(() -> {
                if (handler != null) {
                    handler.onResult(SendBirdException.getSendBirdException(1800401));
                }
            });
        }
    }

    public void setLocalVideoView(SendBirdVideoView videoView) {
        Logger.d(this.tag() + "setLocalVideoView()");
        SendBirdCall.runOnUIThread(() -> {
            if (this.mPeerConnectionClient != null) {
                this.mPeerConnectionClient.setLocalVideoView(videoView);
            }
        });
    }

    public void setRemoteVideoView(SendBirdVideoView videoView) {
        Logger.d(this.tag() + "setRemoteVideoView()");
        SendBirdCall.runOnUIThread(() -> {
            if (this.mPeerConnectionClient != null) {
                this.mPeerConnectionClient.setRemoteVideoView(videoView);
            }
        });
    }

    public Map<String, String> getCustomItems() {
        if (this.mCustomItems == null) {
            return new HashMap<String, String>();
        }
        return new HashMap<String, String>(this.mCustomItems);
    }

    public void updateCustomItems(Map<String, String> customItems, CustomItemsHandler handler) {
        if (customItems == null) {
            SendBirdCall.runOnThreadOption(() -> {
                if (handler != null) {
                    handler.onResult(null, null, SendBirdException.getSendBirdException("customItems"));
                }
            });
            return;
        }
        UpdateCustomItemsRequest request = new UpdateCustomItemsRequest(this.mCallId, customItems);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (response instanceof UpdateCustomItemsResponse) {
                Map result = ((UpdateCustomItemsResponse)response).getCustomItems();
                List affectedKeys = ((UpdateCustomItemsResponse)response).getUpdatedKeys();
                long affectedAt = ((UpdateCustomItemsResponse)response).getAffectedAt();
                if (e == null && result != null) {
                    this.setCustomItems(result, affectedAt);
                }
                SendBirdCall.runOnThreadOption(() -> {
                    if (handler != null) {
                        handler.onResult(result, affectedKeys, e);
                    }
                });
            } else {
                SendBirdCall.runOnThreadOption(() -> {
                    if (handler != null) {
                        handler.onResult(null, null, SendBirdException.getSendBirdException(1800208));
                    }
                });
            }
        });
    }

    public void deleteCustomItems(Set<String> customItemKeys, CustomItemsHandler handler) {
        DeleteCustomItemsRequest request = new DeleteCustomItemsRequest(this.mCallId, customItemKeys);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (response instanceof DeleteCustomItemsResponse) {
                Map result = ((DeleteCustomItemsResponse)response).getCustomItems();
                List affectedKeys = ((DeleteCustomItemsResponse)response).getDeletedKeys();
                long affectedAt = ((DeleteCustomItemsResponse)response).getAffectedAt();
                if (e == null && result != null) {
                    this.setCustomItems(result, affectedAt);
                }
                SendBirdCall.runOnThreadOption(() -> {
                    if (handler != null) {
                        handler.onResult(result, affectedKeys, null);
                    }
                });
            } else {
                SendBirdCall.runOnThreadOption(() -> {
                    if (handler != null) {
                        handler.onResult(null, null, SendBirdException.getSendBirdException(1800208));
                    }
                });
            }
        });
    }

    public void deleteAllCustomItems(CustomItemsHandler handler) {
        this.deleteCustomItems(null, handler);
    }

    void changeState(@NonNull DirectCallState nextState) {
        Logger.d(this.tag() + "changeState(). " + this.mCurrentState.getStateName() + " => " + nextState.getStateName());
        if (this.mCurrentState.getStateName().equals(nextState.getStateName())) {
            return;
        }
        this.mCurrentState.onDestroy(this);
        this.mCurrentState = nextState;
        this.mCurrentState.onCreate(this);
    }

    void updateStartTimestamp() {
        Logger.d(this.tag() + "updateStartTimestamp()");
        this.mStartTimestamp = System.currentTimeMillis();
    }

    void updateEndTimestamp() {
        this.mEndTimestamp = System.currentTimeMillis();
        if (this.mStartTimestamp > 0L) {
            this.mDuration = Math.max(this.mEndTimestamp - this.mStartTimestamp, 0L);
        }
        Logger.d(this.tag() + "updateEndTimestamp() => mDuration: " + this.mDuration);
    }

    void startStateTimer(long delayMillis) {
        Logger.d(this.tag() + "[" + this.mCurrentState.getStateName() + "] => startStateTimer(" + delayMillis + ")");
        this.mStateTimer = new Timer();
        this.mStateTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                DirectCall.this.runOnSingleThreadPool(() -> DirectCall.this.mCurrentState.timeout(DirectCall.this));
            }
        }, delayMillis);
    }

    void stopStateTimer() {
        Logger.d(this.tag() + "[" + this.mCurrentState.getStateName() + "] => stopStateTimer()");
        this.mStateTimer.cancel();
    }

    void startAliveTimer() {
        Logger.d(this.tag() + "[" + this.mCurrentState.getStateName() + "] => startAliveTimer(" + 10000L + ")");
        this.mAliveTimer = new Timer();
        this.mAliveTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!TextUtils.isEmpty((CharSequence)DirectCall.this.mCallId)) {
                    AliveRequest aliveRequest = new AliveRequest(DirectCall.this.mCallId);
                    DirectCall.this.mCommandSender.send((Command)aliveRequest, null);
                }
            }
        }, 0L, 10000L);
    }

    void stopAliveTimer() {
        Logger.d(this.tag() + "[" + this.mCurrentState.getStateName() + "] => stopAliveTimer()");
        this.mAliveTimer.cancel();
    }

    void sendDialRequest(String calleeId) {
        Logger.d(this.tag() + "sendDialRequest(calleeId: " + calleeId + ")");
        DialRequest request = new DialRequest(calleeId, this.mIsVideoCall, this.mCallOptions.mAudioEnabled, this.mCallOptions.mVideoEnabled, this.mCustomItems);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (e == null && response instanceof DialResponse) {
                this.mIsVideoCall = ((DialResponse)response).isVideoCall();
                this.mCallId = ((DialResponse)response).getCallId();
                this.mCaller = ((DialResponse)response).getCaller();
                this.mCallee = ((DialResponse)response).getCallee();
                this.setLocalVideoEnabled(this.mCallOptions.mVideoEnabled);
                this.setLocalAudioEnabled(this.mCallOptions.mAudioEnabled);
            } else {
                this.setLocalEndedCall(DirectCallEndResult.DIAL_FAILED);
            }
            this.runOnSingleThreadPool(() -> this.mCurrentState.onDialAckReceived(this, e));
        });
    }

    void sendAcceptRequest(AcceptParams params) {
        Logger.d(this.tag() + "sendAcceptRequest()");
        this.mCallOptions = params.mCallOptions;
        this.setLocalVideoEnabled(params.mCallOptions.mVideoEnabled);
        this.setLocalAudioEnabled(params.mCallOptions.mAudioEnabled);
        AcceptRequest request = new AcceptRequest(this.mCallId, params.mCallOptions.mAudioEnabled, params.mCallOptions.mVideoEnabled);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (e != null) {
                this.setLocalEndedCall(DirectCallEndResult.ACCEPT_FAILED);
            }
            this.runOnSingleThreadPool(() -> this.mCurrentState.onAcceptAckReceived(this, e));
        });
    }

    void createOffer(boolean isIceRestart) {
        Logger.d(this.tag() + "createOffer(isIceRestart: " + isIceRestart + ")");
        if (!this.mAmICallee && this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.createOffer(isIceRestart);
        }
    }

    void createAnswer() {
        Logger.d(this.tag() + "createAnswer()");
        if (this.mAmICallee && this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.createAnswer();
        }
    }

    void setRemoteDescription(SessionDescription.Type type, String sdp) {
        Logger.d(this.tag() + "setRemoteDescription(type: " + type.canonicalForm() + ")");
        if (sdp != null && sdp.length() > 0 && this.mPeerConnectionClient != null) {
            SessionDescription sessionDescription = new SessionDescription(type, sdp);
            this.mPeerConnectionClient.setRemoteDescription(sessionDescription);
        }
    }

    void sendCancelRequest() {
        Logger.d(this.tag() + "sendCancelRequest()");
        this.setLocalEndedCall(DirectCallEndResult.CANCELED);
        CancelRequest request = new CancelRequest(this.mCallId);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (response instanceof CancelResponse) {
                this.setEndedCall(DirectCallEndResult.CANCELED, ((CancelResponse)response).getEndedCallLog());
            }
            this.runOnSingleThreadPool(() -> this.mCurrentState.onCancelAckReceived(this, e));
        });
    }

    void sendDeclineRequest() {
        Logger.d(this.tag() + "sendDeclineRequest()");
        this.setLocalEndedCall(DirectCallEndResult.DECLINED);
        DeclineRequest request = new DeclineRequest(this.mCallId);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (response instanceof DeclineResponse) {
                this.setEndedCall(DirectCallEndResult.DECLINED, ((DeclineResponse)response).getEndedCallLog());
            }
            this.runOnSingleThreadPool(() -> this.mCurrentState.onDeclineAckReceived(this, e));
        });
    }

    void sendNoAnswerRequest() {
        Logger.d(this.tag() + "sendNoAnswerRequest()");
        this.setLocalEndedCall(DirectCallEndResult.NO_ANSWER);
        NoAnswerRequest request = new NoAnswerRequest(this.mCallId);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (response instanceof NoAnswerResponse) {
                this.setEndedCall(DirectCallEndResult.NO_ANSWER, ((NoAnswerResponse)response).getEndedCallLog());
            }
            this.runOnSingleThreadPool(() -> this.mCurrentState.onNoAnswerAckReceived(this, e));
        });
    }

    void sendEndRequest() {
        Logger.d(this.tag() + "sendEndRequest()");
        this.setLocalEndedCall(DirectCallEndResult.COMPLETED);
        EndRequest request = new EndRequest(this.mCallId);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (response instanceof EndResponse) {
                this.setEndedCall(DirectCallEndResult.COMPLETED, ((EndResponse)response).getEndedCallLog());
            }
            this.runOnSingleThreadPool(() -> this.mCurrentState.onEndAckReceived(this, e));
        });
    }

    void sendUnknownEndRequest() {
        Logger.d(this.tag() + "sendUnknownEndRequest()");
        this.setLocalEndedCall(DirectCallEndResult.UNKNOWN);
        UnknownEndRequest request = new UnknownEndRequest(this.mCallId);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (response instanceof UnknownEndResponse) {
                this.setEndedCall(DirectCallEndResult.UNKNOWN, ((UnknownEndResponse)response).getEndedCallLog());
            }
            this.runOnSingleThreadPool(() -> this.mCurrentState.onUnknownEndAckReceived(this, e));
        });
    }

    void sendTimeoutRequest(@NonNull TimeoutRequest.Reason reason) {
        Logger.d(this.tag() + "sendTimeoutRequest()");
        this.setLocalEndedCall(DirectCallEndResult.TIMED_OUT);
        TimeoutRequest request = new TimeoutRequest(this.mCallId, reason);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (response instanceof TimeoutResponse) {
                this.setEndedCall(DirectCallEndResult.TIMED_OUT, ((TimeoutResponse)response).getEndedCallLog());
            }
            this.runOnSingleThreadPool(() -> this.mCurrentState.onTimeoutAckReceived(this, e));
        });
    }

    void sendConnectionLostRequest() {
        Logger.d(this.tag() + "sendConnectionLostRequest()");
        this.setLocalEndedCall(DirectCallEndResult.CONNECTION_LOST);
        ConnectionLostRequest request = new ConnectionLostRequest(this.mCallId);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (response instanceof ConnectionLostResponse) {
                this.setEndedCall(DirectCallEndResult.CONNECTION_LOST, ((ConnectionLostResponse)response).getEndedCallLog());
            }
        });
    }

    void abort() {
        Logger.d(this.tag() + "abort()");
        this.setLocalEndedCall(DirectCallEndResult.CANCELED);
        this.close();
    }

    void close() {
        Logger.d(this.tag() + "close()");
        this.closePeerConnectionClient();
    }

    void dispatchEvent(DirectCallEventType type) {
        this.dispatchEvent(type, null);
    }

    private void dispatchEvent(DirectCallEventType type, List<String> customItemKeys) {
        Logger.d(this.tag() + "dispatchEvent(type: " + (Object)((Object)type) + "), mListener = " + this.mListener);
        if (type == DirectCallEventType.RINGING && this.mRingingListener != null) {
            this.mRingingListener.onRinging(this);
            return;
        }
        if (type == DirectCallEventType.ENDED && this.mEndListener != null) {
            this.mEndListener.onEnded(this);
        }
        switch (type) {
            case ESTABLISHED: {
                SendBirdCall.runOnThreadOption(() -> {
                    if (this.mListener != null) {
                        this.mListener.onEstablished(this);
                    }
                });
                return;
            }
            case CONNECTED: {
                SendBirdCall.runOnThreadOption(() -> {
                    if (this.mListener != null) {
                        this.mListener.onConnected(this);
                    }
                });
                return;
            }
            case ENDED: {
                SendBirdCall.runOnThreadOption(() -> {
                    if (this.mListener != null) {
                        this.mListener.onEnded(this);
                    }
                });
                return;
            }
            case RECONNECTED: {
                SendBirdCall.runOnThreadOption(() -> {
                    if (this.mListener != null) {
                        this.mListener.onReconnected(this);
                    }
                });
                return;
            }
            case RECONNECTING: {
                SendBirdCall.runOnThreadOption(() -> {
                    if (this.mListener != null) {
                        this.mListener.onReconnecting(this);
                    }
                });
                return;
            }
            case UPDATE_CUSTOM_ITEMS: {
                SendBirdCall.runOnThreadOption(() -> {
                    if (this.mListener != null && !this.isEnded()) {
                        this.mListener.onCustomItemsUpdated(this, customItemKeys);
                    }
                });
                return;
            }
            case DELETE_CUSTOM_ITEMS: {
                SendBirdCall.runOnThreadOption(() -> {
                    if (this.mListener != null && !this.isEnded()) {
                        this.mListener.onCustomItemsDeleted(this, customItemKeys);
                    }
                });
                return;
            }
        }
    }

    void setEndListener(DirectCallEndListener listener) {
        this.mEndListener = listener;
    }

    private void sendOfferRequest(@NonNull String sdp) {
        Logger.d(this.tag() + "sendOfferRequest()");
        OfferRequest request = new OfferRequest(this.mCallId, sdp);
        this.mCommandSender.send((Command)request, null);
    }

    private void sendAnswerRequest(@NonNull String sdp) {
        Logger.d(this.tag() + "sendAnswerRequest()");
        AnswerRequest request = new AnswerRequest(this.mCallId, sdp);
        this.mCommandSender.send((Command)request, null);
    }

    private void sendCandidateRequest(@NonNull IceCandidate candidate) {
        Logger.d(this.tag() + "sendCandidateRequest()");
        CandidateRequest request = new CandidateRequest(this.mCallId, new Candidate(candidate.sdp, candidate.sdpMLineIndex, candidate.sdpMid));
        this.mCommandSender.send((Command)request, null);
    }

    private void sendRemoveCandidatesRequest(@NonNull IceCandidate[] removeCandidates) {
        Logger.d(this.tag() + "sendRemoveCandidatesRequest()");
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        for (IceCandidate candidate : removeCandidates) {
            candidates.add(new Candidate(candidate.sdp, candidate.sdpMLineIndex, candidate.sdpMid));
        }
        RemoveCandidatesRequest request = new RemoveCandidatesRequest(this.mCallId, candidates);
        this.mCommandSender.send((Command)request, null);
    }

    void setRemoteConstraints(Constraints constraints) {
        this.setRemoteAudioEnabled(constraints.getAudioConstraints());
        this.setRemoteVideoEnabled(constraints.getVideoConstraints());
    }

    void createPeerConnectionClient(@Nullable TurnCredential turnCredential) {
        SendBirdCall.runOnUIThread(() -> {
            this.mPeerConnectionClient = PeerConnectionClientFactory.create(this.mContext, this.mIsVideoCall, this.createIceServers(turnCredential), this.mPeerConnectionEvents);
            if (this.mCallOptions != null) {
                this.mPeerConnectionClient.setCallOptions(this.mCallOptions);
            }
        });
    }

    void startAudioManager() {
        SendBirdCall.runOnUIThread(() -> {
            if (this.mPeerConnectionClient != null) {
                this.mPeerConnectionClient.startAudioManager(this.mContext, this.mIsVideoCall, (currentAudioDevice, availableAudioDevices) -> {
                    if (this.mBroadcastListener != null) {
                        this.mBroadcastListener.onAudioDeviceChanged(currentAudioDevice, availableAudioDevices);
                    }
                });
            }
        });
    }

    private List<PeerConnection.IceServer> createIceServers(@Nullable TurnCredential turnCredential) {
        ArrayList<PeerConnection.IceServer> iceServers = new ArrayList<PeerConnection.IceServer>();
        if (turnCredential != null) {
            String userName = turnCredential.getUserName();
            String password = turnCredential.getPassword();
            List turnUrls = turnCredential.getTurnUrls();
            if (userName != null && password != null && turnUrls != null && turnUrls.size() > 0) {
                this.mTurnUrls = new ArrayList<String>(turnUrls);
                for (String turnUrl : turnUrls) {
                    PeerConnection.IceServer turnServer = PeerConnection.IceServer.builder((String)turnUrl).setUsername(userName).setPassword(password).createIceServer();
                    iceServers.add(turnServer);
                }
            }
        }
        return iceServers;
    }

    void setPeerConnectionClientConfiguration(@Nullable TurnCredential turnCredential) {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.setConfiguration(this.createIceServers(turnCredential));
        }
    }

    private void setLocalEndedCall(@NonNull DirectCallEndResult endResult) {
        Logger.d(this.tag() + "setLocalEndedCall(endResult: " + endResult + ")");
        this.mEndResult = endResult;
        this.mEndedBy = this.getLocalUser();
    }

    private void setEndedCall(@NonNull DirectCallEndResult endResult, @NonNull DirectCallLog endedCallLog) {
        Logger.d(this.tag() + "setEndedCall(endResult: " + endResult + ", duration: " + endedCallLog.getDuration() + ")");
        this.mEndResult = endResult;
        this.mEndedBy = endedCallLog.getEndedBy();
        this.mDuration = endedCallLog.getDuration();
        this.mCaller = endedCallLog.getCaller();
        this.mCallee = endedCallLog.getCallee();
    }

    private void closePeerConnectionClient() {
        if (this.mPeerConnectionClient != null) {
            Logger.d(this.tag() + "closePeerConnectionClient()");
            SendBirdCall.runOnUIThread(() -> this.mPeerConnectionClient.close());
        } else {
            this.runOnSingleThreadPool(() -> this.mCurrentState.onClosed(this));
        }
    }

    private void setLocalVideoEnabled(boolean isEnabled) {
        Logger.d(this.tag() + "setLocalVideoEnabled(isEnabled: " + isEnabled + ")");
        this.mIsLocalVideoEnabled = this.mIsVideoCall ? isEnabled : false;
    }

    private void setLocalAudioEnabled(boolean isEnabled) {
        Logger.d(this.tag() + "setLocalAudioEnabled(isEnabled: " + isEnabled + ")");
        this.mIsLocalAudioEnabled = isEnabled;
    }

    private void setRemoteVideoEnabled(boolean isEnabled) {
        Logger.d(this.tag() + "setRemoteVideoEnabled(isEnabled: " + isEnabled + ")");
        boolean isToggled = this.mIsRemoteVideoEnabled != isEnabled;
        this.mIsRemoteVideoEnabled = isEnabled;
        if (isToggled && this.mListener != null) {
            SendBirdCall.runOnThreadOption(() -> {
                if (this.mListener != null) {
                    this.mListener.onRemoteVideoSettingsChanged(this);
                }
            });
        }
    }

    private void setRemoteAudioEnabled(boolean isEnabled) {
        Logger.d(this.tag() + "setRemoteAudioEnabled(isEnabled: " + isEnabled + ")");
        boolean isToggled = this.mIsRemoteAudioEnabled != isEnabled;
        this.mIsRemoteAudioEnabled = isEnabled;
        if (isToggled && this.mListener != null) {
            SendBirdCall.runOnThreadOption(() -> {
                if (this.mListener != null) {
                    this.mListener.onRemoteAudioSettingsChanged(this);
                }
            });
        }
    }

    private void setCustomItems(Map<String, String> customItems, long affectedAt) {
        if (this.mCustomItemsLastAffectedAt > affectedAt) {
            return;
        }
        this.mCustomItems = new HashMap<String, String>(customItems);
        this.mCustomItemsLastAffectedAt = affectedAt;
    }

    private String tag() {
        return this.mAmICallee ? "[DirectCall][Callee] " : "[DirectCall][Caller] ";
    }

    void onDialReceived() {
        Logger.d(this.tag() + "onDialReceived()");
        this.runOnSingleThreadPool(() -> this.mCurrentState.onDialReceived(this));
    }

    void onEvent(Command command) {
        Logger.d(this.tag() + "onEvent(command: " + command.getClass().getSimpleName() + ")");
        if (command instanceof AcceptPushCommand) {
            this.runOnSingleThreadPool(() -> this.mCurrentState.onAcceptReceived(this, (AcceptPushCommand)command));
        } else if (command instanceof OtherDeviceAcceptedPushCommand) {
            this.setLocalEndedCall(DirectCallEndResult.OTHER_DEVICE_ACCEPTED);
            this.runOnSingleThreadPool(() -> this.mCurrentState.onOtherDeviceAccepted(this));
        } else if (command instanceof OfferPushCommand) {
            String sdp = ((OfferPushCommand)command).getSdp();
            StringUtils.uncompress(sdp, result -> this.runOnSingleThreadPool(() -> this.mCurrentState.onOfferReceived(this, result)));
        } else if (command instanceof AnswerPushCommand) {
            String sdp = ((AnswerPushCommand)command).getSdp();
            StringUtils.uncompress(sdp, result -> this.runOnSingleThreadPool(() -> this.mCurrentState.onAnswerReceived(this, result)));
        } else if (command instanceof CandidatePushCommand) {
            Candidate candidate = ((CandidatePushCommand)command).getCandidate();
            if (candidate != null) {
                IceCandidate iceCandidate = new IceCandidate(candidate.getSdpMid(), candidate.getSdpMlineIndex(), candidate.getSdp());
                if (this.mPeerConnectionClient != null) {
                    this.mPeerConnectionClient.addRemoteIceCandidate(iceCandidate);
                }
            }
        } else if (command instanceof RemoveCandidatesPushCommand) {
            List candidateList = ((RemoveCandidatesPushCommand)command).getCandidates();
            if (candidateList != null && candidateList.size() > 0) {
                IceCandidate[] iceCandidates = new IceCandidate[candidateList.size()];
                for (int i = 0; i < candidateList.size(); ++i) {
                    Candidate candidate = (Candidate)candidateList.get(i);
                    if (candidate == null) continue;
                    iceCandidates[i] = new IceCandidate(candidate.getSdpMid(), candidate.getSdpMlineIndex(), candidate.getSdp());
                }
                if (this.mPeerConnectionClient != null) {
                    this.mPeerConnectionClient.removeRemoteIceCandidates(iceCandidates);
                }
            }
        } else if (command instanceof VideoStatusPushCommand) {
            boolean isEnabled = ((VideoStatusPushCommand)command).isEnabled();
            this.setRemoteVideoEnabled(isEnabled);
        } else if (command instanceof AudioStatusPushCommand) {
            boolean isEnabled = ((AudioStatusPushCommand)command).isEnabled();
            this.setRemoteAudioEnabled(isEnabled);
        } else if (command instanceof CancelPushCommand) {
            this.setEndedCall(DirectCallEndResult.CANCELED, ((CancelPushCommand)command).getEndedCallLog());
            this.runOnSingleThreadPool(() -> this.mCurrentState.onCancelReceived(this));
        } else if (command instanceof DeclinePushCommand) {
            this.setEndedCall(DirectCallEndResult.DECLINED, ((DeclinePushCommand)command).getEndedCallLog());
            this.runOnSingleThreadPool(() -> this.mCurrentState.onDeclineReceived(this));
        } else if (command instanceof NoAnswerPushCommand) {
            this.setEndedCall(DirectCallEndResult.NO_ANSWER, ((NoAnswerPushCommand)command).getEndedCallLog());
            this.runOnSingleThreadPool(() -> this.mCurrentState.onNoAnswerReceived(this));
        } else if (command instanceof EndPushCommand) {
            this.setEndedCall(DirectCallEndResult.COMPLETED, ((EndPushCommand)command).getEndedCallLog());
            this.runOnSingleThreadPool(() -> this.mCurrentState.onEndReceived(this));
        } else if (command instanceof UnknownEndPushCommand) {
            this.setEndedCall(DirectCallEndResult.UNKNOWN, ((UnknownEndPushCommand)command).getEndedCallLog());
            this.runOnSingleThreadPool(() -> this.mCurrentState.onUnknownEndReceived(this));
        } else if (command instanceof TimeoutPushCommand) {
            this.setEndedCall(DirectCallEndResult.TIMED_OUT, ((TimeoutPushCommand)command).getEndedCallLog());
            this.runOnSingleThreadPool(() -> this.mCurrentState.onTimeoutReceived(this));
        } else if (command instanceof ConnectionLostPushCommand) {
            this.setEndedCall(DirectCallEndResult.CONNECTION_LOST, ((ConnectionLostPushCommand)command).getEndedCallLog());
            this.runOnSingleThreadPool(() -> this.mCurrentState.onConnectionLostReceived(this));
        } else if (command instanceof UpdateCustomItemsPushCommand) {
            Map customItems = ((UpdateCustomItemsPushCommand)command).getCustomItems();
            long affectedAt = ((UpdateCustomItemsPushCommand)command).getAffectedAt();
            this.setCustomItems(customItems, affectedAt);
            List updatedKeys = ((UpdateCustomItemsPushCommand)command).getUpdatedKeys();
            this.dispatchEvent(DirectCallEventType.UPDATE_CUSTOM_ITEMS, updatedKeys);
        } else if (command instanceof DeleteCustomItemsPushCommand) {
            Map customItems = ((DeleteCustomItemsPushCommand)command).getCustomItems();
            long affectedAt = ((DeleteCustomItemsPushCommand)command).getAffectedAt();
            this.setCustomItems(customItems, affectedAt);
            List deletedKeys = ((DeleteCustomItemsPushCommand)command).getDeletedKeys();
            this.dispatchEvent(DirectCallEventType.DELETE_CUSTOM_ITEMS, deletedKeys);
        }
    }

    private void runOnSingleThreadPool(Runnable runnable) {
        if (this.mSingleThreadExecutor != null && !this.mSingleThreadExecutor.isShutdown()) {
            this.mSingleThreadExecutor.execute(runnable);
        }
    }

    void onAudioDeviceChanged(AudioDevice currentAudioDevice, Set<AudioDevice> availableAudioDevices) {
        Logger.d(this.tag() + "onAudioDeviceChanged(currentAudioDevice: " + (Object)((Object)currentAudioDevice) + ", availableAudioDevices: " + availableAudioDevices + ")");
        SendBirdCall.runOnThreadOption(() -> {
            if (this.mListener != null) {
                this.mListener.onAudioDeviceChanged(this, currentAudioDevice, availableAudioDevices);
            }
        });
    }

    void setStateTimerDelay(long delayMillis) {
        this.stopStateTimer();
        this.startStateTimer(delayMillis);
    }

    PeerConnectionEvents getPeerConnectionEvents() {
        return this.mPeerConnectionEvents;
    }

    CommandSender getCommandSender() {
        return this.mCommandSender;
    }

    void setCommandSender(CommandSender commandSender) {
        this.mCommandSender = commandSender;
    }

    static enum DirectCallEventType {
        ESTABLISHED,
        CONNECTED,
        RECONNECTING,
        RECONNECTED,
        ENDED,
        RINGING,
        UPDATE_CUSTOM_ITEMS,
        DELETE_CUSTOM_ITEMS;

    }
}

