/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

class UrlUtils {
    UrlUtils() {
    }

    static String getQueryString(Map<String, String> params) {
        HashMap<String, String> urlEncodedParams = new HashMap<String, String>();
        if (params != null && params.size() > 0) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                urlEncodedParams.put(UrlUtils.urlEncodeUTF8(key), UrlUtils.urlEncodeUTF8(value));
            }
        }
        StringBuilder sb = new StringBuilder();
        if (urlEncodedParams.size() > 0) {
            for (Map.Entry entry : urlEncodedParams.entrySet()) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(String.format("%s=%s", entry.getKey(), entry.getValue()));
            }
        }
        return sb.toString();
    }

    static String urlEncodeUTF8(String s) {
        String result = null;
        if (s != null) {
            try {
                result = URLEncoder.encode(s, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new UnsupportedOperationException(e);
            }
        }
        return result;
    }

    static String urlEncodeUTF8(Collection<String> strList) {
        String result = null;
        if (strList != null && strList.size() > 0) {
            StringBuilder sb = new StringBuilder();
            String separator = "";
            for (String str : strList) {
                sb.append(separator);
                separator = ",";
                sb.append(UrlUtils.urlEncodeUTF8(str));
            }
            result = sb.toString();
        }
        return result;
    }
}

