/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import com.sendbird.calls.CallRequest;
import com.sendbird.calls.shadow.com.google.gson.JsonObject;

class TimeoutRequest
extends CallRequest {
    private static final String COMMAND = "CALL";
    private static final String TYPE = "timeout";
    private String mCallId;
    private Reason mReason;

    TimeoutRequest(String callId, Reason reason) {
        super(COMMAND, TYPE);
        this.mCallId = callId;
        this.mReason = reason;
    }

    @Override
    boolean isAckRequired() {
        return true;
    }

    @Override
    JsonObject getDataObject() {
        JsonObject dataObj = new JsonObject();
        dataObj.addProperty("call_id", this.mCallId);
        dataObj.addProperty("reason", this.mReason.toString().toLowerCase());
        return dataObj;
    }

    static enum Reason {
        ANSWER_NOT_RECEIVED,
        OFFER_NOT_RECEIVED,
        WEBRTC_NOT_CONNECTED;

    }
}

