/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.content.Context;
import android.support.annotation.Nullable;
import com.sendbird.calls.Logger;
import com.sendbird.calls.PeerConnectionEvents;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.webrtc.AudioSource;
import org.webrtc.AudioTrack;
import org.webrtc.DataChannel;
import org.webrtc.DefaultVideoDecoderFactory;
import org.webrtc.DefaultVideoEncoderFactory;
import org.webrtc.EglBase;
import org.webrtc.IceCandidate;
import org.webrtc.MediaConstraints;
import org.webrtc.MediaStream;
import org.webrtc.MediaStreamTrack;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.RtpParameters;
import org.webrtc.RtpReceiver;
import org.webrtc.RtpSender;
import org.webrtc.RtpTransceiver;
import org.webrtc.SdpObserver;
import org.webrtc.SessionDescription;
import org.webrtc.SoftwareVideoDecoderFactory;
import org.webrtc.SoftwareVideoEncoderFactory;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoDecoderFactory;
import org.webrtc.VideoEncoderFactory;
import org.webrtc.VideoSink;
import org.webrtc.VideoSource;
import org.webrtc.VideoTrack;
import org.webrtc.audio.AudioDeviceModule;
import org.webrtc.audio.JavaAudioDeviceModule;

class _PeerConnectionClient {
    public static final String VIDEO_TRACK_ID = "ARDAMSv0";
    public static final String AUDIO_TRACK_ID = "ARDAMSa0";
    public static final String VIDEO_TRACK_TYPE = "video";
    private static final String TAG = "PCRTCClient";
    private static final String VIDEO_CODEC_VP8 = "VP8";
    private static final String VIDEO_CODEC_VP9 = "VP9";
    private static final String VIDEO_CODEC_H264 = "H264";
    private static final String VIDEO_CODEC_H264_BASELINE = "H264 Baseline";
    private static final String VIDEO_CODEC_H264_HIGH = "H264 High";
    private static final String AUDIO_CODEC_OPUS = "opus";
    private static final String AUDIO_CODEC_ISAC = "ISAC";
    private static final String VIDEO_CODEC_PARAM_START_BITRATE = "x-google-start-bitrate";
    private static final String VIDEO_FLEXFEC_FIELDTRIAL = "WebRTC-FlexFEC-03-Advertised/Enabled/WebRTC-FlexFEC-03/Enabled/";
    private static final String VIDEO_VP8_INTEL_HW_ENCODER_FIELDTRIAL = "WebRTC-IntelVP8/Enabled/";
    private static final String DISABLE_WEBRTC_AGC_FIELDTRIAL = "WebRTC-Audio-MinimizeResamplingOnMobile/Enabled/";
    private static final String AUDIO_CODEC_PARAM_BITRATE = "maxaveragebitrate";
    private static final String AUDIO_ECHO_CANCELLATION_CONSTRAINT = "googEchoCancellation";
    private static final String AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT = "googAutoGainControl";
    private static final String AUDIO_HIGH_PASS_FILTER_CONSTRAINT = "googHighpassFilter";
    private static final String AUDIO_NOISE_SUPPRESSION_CONSTRAINT = "googNoiseSuppression";
    private static final String DTLS_SRTP_KEY_AGREEMENT_CONSTRAINT = "DtlsSrtpKeyAgreement";
    private static final int HD_VIDEO_WIDTH = 1280;
    private static final int HD_VIDEO_HEIGHT = 720;
    private static final int DEFAULT_FPS = 24;
    private static final int BPS_IN_KBPS = 1000;
    private static final String RTCEVENTLOG_OUTPUT_DIR_NAME = "rtc_event_log";
    private static final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final PCObserver pcObserver = new PCObserver();
    private final SDPObserver sdpObserver = new SDPObserver();
    private final Timer statsTimer = new Timer();
    private final EglBase rootEglBase;
    private final Context appContext;
    private final PeerConnectionParameters peerConnectionParameters;
    private final PeerConnectionEvents events;
    private boolean isIceRestarting = false;
    @Nullable
    private PeerConnectionFactory factory;
    @Nullable
    private PeerConnection peerConnection;
    @Nullable
    private AudioSource audioSource;
    @Nullable
    private SurfaceTextureHelper surfaceTextureHelper;
    @Nullable
    private VideoSource videoSource;
    private boolean preferIsac;
    private boolean videoCapturerStopped;
    private boolean isErrorOccurred;
    @Nullable
    private VideoSink localRender;
    @Nullable
    private List<VideoSink> remoteSinks;
    private List<PeerConnection.IceServer> mIceServers;
    private int videoWidth = 1280;
    private int videoHeight = 720;
    private int videoFps = 24;
    private MediaConstraints audioConstraints;
    @Nullable
    private List<IceCandidate> queuedRemoteCandidates;
    private boolean isInitiator;
    @Nullable
    private SessionDescription localSdp;
    @Nullable
    private VideoCapturer videoCapturer;
    private boolean renderVideo = true;
    @Nullable
    private VideoTrack localVideoTrack;
    @Nullable
    private VideoTrack remoteVideoTrack;
    @Nullable
    private RtpSender localVideoSender;
    private boolean enableAudio = true;
    @Nullable
    private AudioTrack localAudioTrack;
    private final Object mIsSwitchingCameraObject = new Object();
    private boolean mIsSwitchingCamera;

    public _PeerConnectionClient(Context appContext, EglBase eglBase, PeerConnectionParameters peerConnectionParameters, PeerConnectionEvents events) {
        this.rootEglBase = eglBase;
        this.appContext = appContext;
        this.events = events;
        this.peerConnectionParameters = peerConnectionParameters;
        this.isErrorOccurred = false;
        String fieldTrials = _PeerConnectionClient.getFieldTrials(peerConnectionParameters);
        executor.execute(() -> {
            PeerConnectionFactory.initialize((PeerConnectionFactory.InitializationOptions)PeerConnectionFactory.InitializationOptions.builder((Context)appContext).setFieldTrials(fieldTrials).setEnableInternalTracer(true).createInitializationOptions());
            this.createPeerConnectionFactoryInternal(new PeerConnectionFactory.Options());
        });
    }

    public void createPeerConnection(VideoSink localRender, List<VideoSink> remoteSinks, VideoCapturer videoCapturer, List<PeerConnection.IceServer> iceServers) {
        if (this.peerConnectionParameters == null) {
            return;
        }
        this.localRender = localRender;
        this.remoteSinks = remoteSinks;
        this.videoCapturer = videoCapturer;
        this.mIceServers = iceServers;
        executor.execute(() -> {
            try {
                this.createMediaConstraintsInternal();
                this.createPeerConnectionInternal();
            }
            catch (Exception e) {
                this.reportError("Failed to create peer connection: " + e.getMessage(), false);
                throw e;
            }
        });
    }

    public void close() {
        executor.execute(new Runnable(){

            @Override
            public void run() {
                _PeerConnectionClient.this.closeInternal();
            }
        });
    }

    boolean isVideoCallEnabled() {
        return this.peerConnectionParameters.videoCallEnabled;
    }

    private void createPeerConnectionFactoryInternal(PeerConnectionFactory.Options options) {
        SoftwareVideoDecoderFactory decoderFactory;
        SoftwareVideoEncoderFactory encoderFactory;
        this.preferIsac = this.peerConnectionParameters.audioCodec != null && this.peerConnectionParameters.audioCodec.equals(AUDIO_CODEC_ISAC);
        AudioDeviceModule adm = this.createJavaAudioDevice();
        if (options != null) {
            // empty if block
        }
        boolean enableH264HighProfile = VIDEO_CODEC_H264_HIGH.equals(this.peerConnectionParameters.videoCodec);
        if (this.peerConnectionParameters.videoCodecHwAcceleration) {
            encoderFactory = new DefaultVideoEncoderFactory(this.rootEglBase.getEglBaseContext(), true, enableH264HighProfile);
            decoderFactory = new DefaultVideoDecoderFactory(this.rootEglBase.getEglBaseContext());
        } else {
            encoderFactory = new SoftwareVideoEncoderFactory();
            decoderFactory = new SoftwareVideoDecoderFactory();
        }
        this.factory = PeerConnectionFactory.builder().setOptions(options).setAudioDeviceModule(adm).setVideoEncoderFactory((VideoEncoderFactory)encoderFactory).setVideoDecoderFactory((VideoDecoderFactory)decoderFactory).createPeerConnectionFactory();
        adm.release();
    }

    AudioDeviceModule createJavaAudioDevice() {
        if (!this.peerConnectionParameters.useOpenSLES) {
            // empty if block
        }
        JavaAudioDeviceModule.AudioRecordErrorCallback audioRecordErrorCallback = new JavaAudioDeviceModule.AudioRecordErrorCallback(){

            public void onWebRtcAudioRecordInitError(String errorMessage) {
                _PeerConnectionClient.this.reportError(errorMessage, true);
            }

            public void onWebRtcAudioRecordStartError(JavaAudioDeviceModule.AudioRecordStartErrorCode errorCode, String errorMessage) {
                _PeerConnectionClient.this.reportError(errorMessage, true);
            }

            public void onWebRtcAudioRecordError(String errorMessage) {
                _PeerConnectionClient.this.reportError(errorMessage, true);
            }
        };
        JavaAudioDeviceModule.AudioTrackErrorCallback audioTrackErrorCallback = new JavaAudioDeviceModule.AudioTrackErrorCallback(){

            public void onWebRtcAudioTrackInitError(String errorMessage) {
                _PeerConnectionClient.this.reportError(errorMessage, true);
            }

            public void onWebRtcAudioTrackStartError(JavaAudioDeviceModule.AudioTrackStartErrorCode errorCode, String errorMessage) {
                _PeerConnectionClient.this.reportError(errorMessage, true);
            }

            public void onWebRtcAudioTrackError(String errorMessage) {
                _PeerConnectionClient.this.reportError(errorMessage, true);
            }
        };
        return JavaAudioDeviceModule.builder((Context)this.appContext).setUseHardwareAcousticEchoCanceler(!this.peerConnectionParameters.disableBuiltInAEC).setUseHardwareNoiseSuppressor(!this.peerConnectionParameters.disableBuiltInNS).setAudioRecordErrorCallback(audioRecordErrorCallback).setAudioTrackErrorCallback(audioTrackErrorCallback).createAudioDeviceModule();
    }

    private void createMediaConstraintsInternal() {
        this.audioConstraints = new MediaConstraints();
        if (this.peerConnectionParameters.noAudioProcessing) {
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_ECHO_CANCELLATION_CONSTRAINT, "false"));
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_AUTO_GAIN_CONTROL_CONSTRAINT, "false"));
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_HIGH_PASS_FILTER_CONSTRAINT, "false"));
            this.audioConstraints.mandatory.add(new MediaConstraints.KeyValuePair(AUDIO_NOISE_SUPPRESSION_CONSTRAINT, "false"));
        }
    }

    private void createPeerConnectionInternal() {
        if (this.factory == null || this.isErrorOccurred) {
            return;
        }
        this.queuedRemoteCandidates = new ArrayList<IceCandidate>();
        this.peerConnection = this.factory.createPeerConnection(this.createRTCConfiguration(this.mIceServers), (PeerConnection.Observer)this.pcObserver);
        this.isInitiator = false;
        List<String> mediaStreamLabels = Collections.singletonList("ARDAMS");
        if (this.isVideoCallEnabled()) {
            this.peerConnection.addTrack((MediaStreamTrack)this.createVideoTrack(this.videoCapturer), mediaStreamLabels);
            this.remoteVideoTrack = this.getRemoteVideoTrack();
            if (this.remoteVideoTrack != null) {
                this.remoteVideoTrack.setEnabled(this.renderVideo);
                for (VideoSink remoteSink : this.remoteSinks) {
                    this.remoteVideoTrack.addSink(remoteSink);
                }
            }
        }
        this.peerConnection.addTrack((MediaStreamTrack)this.createAudioTrack(), mediaStreamLabels);
        if (this.isVideoCallEnabled()) {
            this.findVideoSender();
        }
    }

    void setVideoConstraints(int videoWidth, int videoHeight, int videoFps) {
        if (this.isVideoCallEnabled()) {
            this.videoWidth = videoWidth;
            this.videoHeight = videoHeight;
            this.videoFps = videoFps;
            if (this.videoWidth == 0 || this.videoHeight == 0) {
                this.videoWidth = 1280;
                this.videoHeight = 720;
            }
            if (this.videoFps == 0) {
                this.videoFps = 24;
            }
            this.stopVideoSource();
            this.startVideoSource();
        }
    }

    private PeerConnection.RTCConfiguration createRTCConfiguration(List<PeerConnection.IceServer> iceServers) {
        PeerConnection.RTCConfiguration rtcConfig = new PeerConnection.RTCConfiguration(iceServers);
        rtcConfig.tcpCandidatePolicy = PeerConnection.TcpCandidatePolicy.DISABLED;
        rtcConfig.bundlePolicy = PeerConnection.BundlePolicy.MAXBUNDLE;
        rtcConfig.rtcpMuxPolicy = PeerConnection.RtcpMuxPolicy.REQUIRE;
        rtcConfig.continualGatheringPolicy = PeerConnection.ContinualGatheringPolicy.GATHER_CONTINUALLY;
        rtcConfig.keyType = PeerConnection.KeyType.ECDSA;
        rtcConfig.enableDtlsSrtp = true;
        rtcConfig.sdpSemantics = PeerConnection.SdpSemantics.UNIFIED_PLAN;
        rtcConfig.iceTransportsType = PeerConnection.IceTransportsType.RELAY;
        return rtcConfig;
    }

    void setConfiguration(List<PeerConnection.IceServer> iceServers) {
        if (this.peerConnection != null) {
            this.peerConnection.setConfiguration(this.createRTCConfiguration(iceServers));
        }
    }

    private void closeInternal() {
        this.statsTimer.cancel();
        if (this.peerConnection != null) {
            this.peerConnection.dispose();
            this.peerConnection = null;
        }
        if (this.audioSource != null) {
            this.audioSource.dispose();
            this.audioSource = null;
        }
        if (this.videoCapturer != null) {
            try {
                this.videoCapturer.stopCapture();
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            this.videoCapturerStopped = true;
            this.videoCapturer.dispose();
            this.videoCapturer = null;
        }
        if (this.videoSource != null) {
            this.videoSource.dispose();
            this.videoSource = null;
        }
        if (this.surfaceTextureHelper != null) {
            this.surfaceTextureHelper.dispose();
            this.surfaceTextureHelper = null;
        }
        this.localRender = null;
        this.remoteSinks = null;
        if (this.factory != null) {
            this.factory.dispose();
            this.factory = null;
        }
        this.rootEglBase.release();
        this.events.onPeerConnectionClosed();
        PeerConnectionFactory.stopInternalTracingCapture();
        PeerConnectionFactory.shutdownInternalTracer();
    }

    public boolean isHDVideo() {
        return this.isVideoCallEnabled() && this.videoWidth * this.videoHeight >= 921600;
    }

    private void getStats() {
        if (this.peerConnection == null || this.isErrorOccurred) {
            return;
        }
        this.peerConnection.getStats(rtcStatsReport -> executor.execute(() -> this.events.onRtcStatsEvent(rtcStatsReport.getStatsMap())));
    }

    public void enableStatsEvents(boolean enable, int periodMs) {
        if (enable) {
            try {
                this.statsTimer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        executor.execute(() -> _PeerConnectionClient.this.getStats());
                    }
                }, 0L, (long)periodMs);
            }
            catch (Exception exception) {}
        } else {
            this.statsTimer.cancel();
        }
    }

    public boolean setAudioEnabled(boolean enable) {
        if (this.peerConnection == null) {
            return false;
        }
        executor.execute(() -> {
            if (this.enableAudio != enable) {
                this.enableAudio = enable;
                if (this.localAudioTrack != null) {
                    this.localAudioTrack.setEnabled(this.enableAudio);
                }
            }
        });
        return true;
    }

    public boolean setVideoEnabled(boolean enable) {
        if (this.peerConnection == null) {
            return false;
        }
        executor.execute(() -> {
            if (this.renderVideo != enable) {
                this.renderVideo = enable;
                if (this.localVideoTrack != null) {
                    this.localVideoTrack.setEnabled(this.renderVideo);
                }
            }
        });
        return true;
    }

    public void createOffer(boolean isIceRestart) {
        executor.execute(() -> {
            if (this.peerConnection != null && !this.isErrorOccurred) {
                this.isIceRestarting = isIceRestart;
                if (isIceRestart) {
                    this.localSdp = null;
                }
                this.isInitiator = true;
                this.peerConnection.createOffer((SdpObserver)this.sdpObserver, this.getMediaConstraints(isIceRestart));
            }
        });
    }

    public void createAnswer() {
        executor.execute(() -> {
            if (this.peerConnection != null && !this.isErrorOccurred) {
                this.isInitiator = false;
                this.peerConnection.createAnswer((SdpObserver)this.sdpObserver, this.getMediaConstraints(false));
            }
        });
    }

    private MediaConstraints getMediaConstraints(boolean isIceRestart) {
        MediaConstraints sdpMediaConstraints = new MediaConstraints();
        sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveAudio", "true"));
        sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("OfferToReceiveVideo", Boolean.toString(this.isVideoCallEnabled())));
        if (isIceRestart) {
            sdpMediaConstraints.mandatory.add(new MediaConstraints.KeyValuePair("IceRestart", "true"));
        }
        return sdpMediaConstraints;
    }

    public void addRemoteIceCandidate(IceCandidate candidate) {
        executor.execute(() -> {
            if (this.peerConnection != null && !this.isErrorOccurred) {
                if (this.queuedRemoteCandidates != null) {
                    this.queuedRemoteCandidates.add(candidate);
                } else {
                    this.peerConnection.addIceCandidate(candidate);
                }
            }
        });
    }

    public void removeRemoteIceCandidates(IceCandidate[] candidates) {
        executor.execute(() -> {
            if (this.peerConnection == null || this.isErrorOccurred) {
                return;
            }
            this.drainCandidates();
            this.peerConnection.removeIceCandidates(candidates);
        });
    }

    public void setRemoteDescription(SessionDescription sdp) {
        executor.execute(() -> {
            if (this.peerConnection == null || this.isErrorOccurred) {
                return;
            }
            String sdpDescription = sdp.description;
            if (this.preferIsac) {
                sdpDescription = _PeerConnectionClient.preferCodec(sdpDescription, AUDIO_CODEC_ISAC, true);
            }
            if (this.isVideoCallEnabled()) {
                sdpDescription = _PeerConnectionClient.preferCodec(sdpDescription, _PeerConnectionClient.getSdpVideoCodecName(this.peerConnectionParameters), false);
            }
            if (this.peerConnectionParameters.audioStartBitrate > 0) {
                sdpDescription = _PeerConnectionClient.setStartBitrate(AUDIO_CODEC_OPUS, false, sdpDescription, this.peerConnectionParameters.audioStartBitrate);
            }
            SessionDescription sdpRemote = new SessionDescription(sdp.type, sdpDescription);
            this.peerConnection.setRemoteDescription((SdpObserver)this.sdpObserver, sdpRemote);
        });
    }

    public void stopVideoSource() {
        executor.execute(() -> {
            if (this.videoCapturer != null && !this.videoCapturerStopped) {
                try {
                    this.videoCapturer.stopCapture();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.videoCapturerStopped = true;
            }
        });
    }

    public void startVideoSource() {
        executor.execute(() -> {
            if (this.videoCapturer != null && this.videoCapturerStopped) {
                this.videoCapturer.startCapture(this.videoWidth, this.videoHeight, this.videoFps);
                this.videoCapturerStopped = false;
            }
        });
    }

    public void setVideoMaxBitrate(@Nullable Integer maxBitrateKbps) {
        executor.execute(() -> {
            if (this.peerConnection == null || this.localVideoSender == null || this.isErrorOccurred) {
                return;
            }
            if (this.localVideoSender == null) {
                return;
            }
            RtpParameters parameters = this.localVideoSender.getParameters();
            if (parameters.encodings.size() == 0) {
                return;
            }
            for (RtpParameters.Encoding encoding : parameters.encodings) {
                encoding.maxBitrateBps = maxBitrateKbps == null ? null : Integer.valueOf(maxBitrateKbps * 1000);
            }
            if (!this.localVideoSender.setParameters(parameters)) {
                // empty if block
            }
        });
    }

    private void reportError(String errorMessage, boolean isAudioError) {
        executor.execute(() -> {
            if (isAudioError) {
                this.events.onPeerConnectionAudioError(errorMessage);
                return;
            }
            if (!this.isErrorOccurred) {
                this.isErrorOccurred = true;
                this.events.onPeerConnectionError(errorMessage);
            }
        });
    }

    @Nullable
    private AudioTrack createAudioTrack() {
        this.audioSource = this.factory.createAudioSource(this.audioConstraints);
        this.localAudioTrack = this.factory.createAudioTrack(AUDIO_TRACK_ID, this.audioSource);
        this.localAudioTrack.setEnabled(this.enableAudio);
        return this.localAudioTrack;
    }

    @Nullable
    private VideoTrack createVideoTrack(VideoCapturer capturer) {
        if (capturer == null) {
            this.videoSource = this.factory.createVideoSource(false);
        } else {
            this.videoSource = this.factory.createVideoSource(capturer.isScreencast());
            this.surfaceTextureHelper = SurfaceTextureHelper.create((String)"CaptureThread", (EglBase.Context)this.rootEglBase.getEglBaseContext());
            capturer.initialize(this.surfaceTextureHelper, this.appContext, this.videoSource.getCapturerObserver());
            capturer.startCapture(this.videoWidth, this.videoHeight, this.videoFps);
        }
        this.localVideoTrack = this.factory.createVideoTrack(VIDEO_TRACK_ID, this.videoSource);
        this.localVideoTrack.setEnabled(this.renderVideo);
        this.localVideoTrack.addSink(this.localRender);
        return this.localVideoTrack;
    }

    private void findVideoSender() {
        for (RtpSender sender : this.peerConnection.getSenders()) {
            String trackType;
            if (sender.track() == null || !(trackType = sender.track().kind()).equals(VIDEO_TRACK_TYPE)) continue;
            this.localVideoSender = sender;
        }
    }

    @Nullable
    private VideoTrack getRemoteVideoTrack() {
        for (RtpTransceiver transceiver : this.peerConnection.getTransceivers()) {
            MediaStreamTrack track = transceiver.getReceiver().track();
            if (!(track instanceof VideoTrack)) continue;
            return (VideoTrack)track;
        }
        return null;
    }

    private static String getSdpVideoCodecName(PeerConnectionParameters parameters) {
        switch (parameters.videoCodec) {
            case "VP8": {
                return VIDEO_CODEC_VP8;
            }
            case "VP9": {
                return VIDEO_CODEC_VP9;
            }
            case "H264 High": 
            case "H264 Baseline": {
                return VIDEO_CODEC_H264;
            }
        }
        return VIDEO_CODEC_VP8;
    }

    private static String getFieldTrials(PeerConnectionParameters peerConnectionParameters) {
        String fieldTrials = "";
        if (peerConnectionParameters.videoFlexfecEnabled) {
            fieldTrials = fieldTrials + VIDEO_FLEXFEC_FIELDTRIAL;
        }
        fieldTrials = fieldTrials + VIDEO_VP8_INTEL_HW_ENCODER_FIELDTRIAL;
        if (peerConnectionParameters.disableWebRtcAGCAndHPF) {
            fieldTrials = fieldTrials + DISABLE_WEBRTC_AGC_FIELDTRIAL;
        }
        return fieldTrials;
    }

    private static String setStartBitrate(String codec, boolean isVideoCodec, String sdpDescription, int bitrateKbps) {
        Matcher codecMatcher;
        int i;
        String[] lines = sdpDescription.split("\r\n");
        int rtpmapLineIndex = -1;
        boolean sdpFormatUpdated = false;
        String codecRtpMap = null;
        String regex = "^a=rtpmap:(\\d+) " + codec + "(/\\d+)+[\r]?$";
        Pattern codecPattern = Pattern.compile(regex);
        for (i = 0; i < lines.length; ++i) {
            codecMatcher = codecPattern.matcher(lines[i]);
            if (!codecMatcher.matches()) continue;
            codecRtpMap = codecMatcher.group(1);
            rtpmapLineIndex = i;
            break;
        }
        if (codecRtpMap == null) {
            return sdpDescription;
        }
        regex = "^a=fmtp:" + codecRtpMap + " \\w+=\\d+.*[\r]?$";
        codecPattern = Pattern.compile(regex);
        for (i = 0; i < lines.length; ++i) {
            codecMatcher = codecPattern.matcher(lines[i]);
            if (!codecMatcher.matches()) continue;
            if (isVideoCodec) {
                int n = i;
                lines[n] = lines[n] + "; x-google-start-bitrate=" + bitrateKbps;
            } else {
                int n = i;
                lines[n] = lines[n] + "; maxaveragebitrate=" + bitrateKbps * 1000;
            }
            sdpFormatUpdated = true;
            break;
        }
        StringBuilder newSdpDescription = new StringBuilder();
        for (int i2 = 0; i2 < lines.length; ++i2) {
            newSdpDescription.append(lines[i2]).append("\r\n");
            if (sdpFormatUpdated || i2 != rtpmapLineIndex) continue;
            String bitrateSet = isVideoCodec ? "a=fmtp:" + codecRtpMap + " " + VIDEO_CODEC_PARAM_START_BITRATE + "=" + bitrateKbps : "a=fmtp:" + codecRtpMap + " " + AUDIO_CODEC_PARAM_BITRATE + "=" + bitrateKbps * 1000;
            newSdpDescription.append(bitrateSet).append("\r\n");
        }
        return newSdpDescription.toString();
    }

    private static int findMediaDescriptionLine(boolean isAudio, String[] sdpLines) {
        String mediaDescription = isAudio ? "m=audio " : "m=video ";
        for (int i = 0; i < sdpLines.length; ++i) {
            if (!sdpLines[i].startsWith(mediaDescription)) continue;
            return i;
        }
        return -1;
    }

    private static String joinString(Iterable<? extends CharSequence> s, String delimiter, boolean delimiterAtEnd) {
        Iterator<? extends CharSequence> iter = s.iterator();
        if (!iter.hasNext()) {
            return "";
        }
        StringBuilder buffer = new StringBuilder(iter.next());
        while (iter.hasNext()) {
            buffer.append(delimiter).append(iter.next());
        }
        if (delimiterAtEnd) {
            buffer.append(delimiter);
        }
        return buffer.toString();
    }

    @Nullable
    private static String movePayloadTypesToFront(List<String> preferredPayloadTypes, String mLine) {
        List<String> origLineParts = Arrays.asList(mLine.split(" "));
        if (origLineParts.size() <= 3) {
            return null;
        }
        List<String> header = origLineParts.subList(0, 3);
        ArrayList<String> unpreferredPayloadTypes = new ArrayList<String>(origLineParts.subList(3, origLineParts.size()));
        unpreferredPayloadTypes.removeAll(preferredPayloadTypes);
        ArrayList<String> newLineParts = new ArrayList<String>();
        newLineParts.addAll(header);
        newLineParts.addAll(preferredPayloadTypes);
        newLineParts.addAll(unpreferredPayloadTypes);
        return _PeerConnectionClient.joinString(newLineParts, " ", false);
    }

    private static String preferCodec(String sdpDescription, String codec, boolean isAudio) {
        String[] lines = sdpDescription.split("\r\n");
        int mLineIndex = _PeerConnectionClient.findMediaDescriptionLine(isAudio, lines);
        if (mLineIndex == -1) {
            return sdpDescription;
        }
        ArrayList<String> codecPayloadTypes = new ArrayList<String>();
        Pattern codecPattern = Pattern.compile("^a=rtpmap:(\\d+) " + codec + "(/\\d+)+[\r]?$");
        for (String line : lines) {
            Matcher codecMatcher = codecPattern.matcher(line);
            if (!codecMatcher.matches()) continue;
            codecPayloadTypes.add(codecMatcher.group(1));
        }
        if (codecPayloadTypes.isEmpty()) {
            return sdpDescription;
        }
        String newMLine = _PeerConnectionClient.movePayloadTypesToFront(codecPayloadTypes, lines[mLineIndex]);
        if (newMLine == null) {
            return sdpDescription;
        }
        lines[mLineIndex] = newMLine;
        return _PeerConnectionClient.joinString(Arrays.asList(lines), "\r\n", true);
    }

    private void drainCandidates() {
        if (this.queuedRemoteCandidates != null) {
            for (IceCandidate candidate : this.queuedRemoteCandidates) {
                this.peerConnection.addIceCandidate(candidate);
            }
            this.queuedRemoteCandidates = null;
        }
    }

    public void changeCaptureFormat(int width, int height, int framerate) {
        executor.execute(() -> this.changeCaptureFormatInternal(width, height, framerate));
    }

    private void changeCaptureFormatInternal(int width, int height, int framerate) {
        if (!this.isVideoCallEnabled() || this.isErrorOccurred || this.videoCapturer == null) {
            return;
        }
        this.videoSource.adaptOutputFormat(width, height, framerate);
    }

    private class SDPObserver
    implements SdpObserver {
        private SDPObserver() {
        }

        public void onCreateSuccess(SessionDescription origSdp) {
            if (_PeerConnectionClient.this.localSdp != null) {
                _PeerConnectionClient.this.reportError("Multiple SDP create.", false);
                return;
            }
            String sdpDescription = origSdp.description;
            if (_PeerConnectionClient.this.preferIsac) {
                sdpDescription = _PeerConnectionClient.preferCodec(sdpDescription, _PeerConnectionClient.AUDIO_CODEC_ISAC, true);
            }
            if (_PeerConnectionClient.this.isVideoCallEnabled()) {
                sdpDescription = _PeerConnectionClient.preferCodec(sdpDescription, _PeerConnectionClient.getSdpVideoCodecName(_PeerConnectionClient.this.peerConnectionParameters), false);
            }
            SessionDescription sdp = new SessionDescription(origSdp.type, sdpDescription);
            _PeerConnectionClient.this.localSdp = sdp;
            executor.execute(() -> {
                if (_PeerConnectionClient.this.peerConnection != null && !_PeerConnectionClient.this.isErrorOccurred) {
                    _PeerConnectionClient.this.peerConnection.setLocalDescription((SdpObserver)_PeerConnectionClient.this.sdpObserver, sdp);
                }
            });
        }

        public void onSetSuccess() {
            executor.execute(() -> {
                if (_PeerConnectionClient.this.peerConnection == null || _PeerConnectionClient.this.isErrorOccurred) {
                    return;
                }
                if (_PeerConnectionClient.this.isInitiator) {
                    if (_PeerConnectionClient.this.isIceRestarting) {
                        _PeerConnectionClient.this.isIceRestarting = false;
                        _PeerConnectionClient.this.events.onLocalDescription(true, _PeerConnectionClient.this.localSdp);
                        return;
                    }
                    if (_PeerConnectionClient.this.peerConnection.getRemoteDescription() == null) {
                        _PeerConnectionClient.this.events.onLocalDescription(_PeerConnectionClient.this.isInitiator, _PeerConnectionClient.this.localSdp);
                    } else {
                        _PeerConnectionClient.this.drainCandidates();
                    }
                } else if (_PeerConnectionClient.this.peerConnection.getLocalDescription() != null) {
                    _PeerConnectionClient.this.events.onLocalDescription(_PeerConnectionClient.this.isInitiator, _PeerConnectionClient.this.localSdp);
                    _PeerConnectionClient.this.drainCandidates();
                }
            });
        }

        public void onCreateFailure(String error) {
            _PeerConnectionClient.this.reportError("createSDP error: " + error, false);
        }

        public void onSetFailure(String error) {
            _PeerConnectionClient.this.reportError("setSDP error: " + error, false);
        }
    }

    private class PCObserver
    implements PeerConnection.Observer {
        private PCObserver() {
        }

        public void onIceCandidate(IceCandidate candidate) {
            Logger.d("[_PeerConnectionClient] PCObserver => onIceCandidate()");
            executor.execute(() -> _PeerConnectionClient.this.events.onIceCandidate(candidate));
        }

        public void onIceCandidatesRemoved(IceCandidate[] candidates) {
            Logger.d("[_PeerConnectionClient] PCObserver => onIceCandidatesRemoved() => candidates: " + candidates.length);
            executor.execute(() -> _PeerConnectionClient.this.events.onIceCandidatesRemoved(candidates));
        }

        public void onSignalingChange(PeerConnection.SignalingState newState) {
            Logger.d("[_PeerConnectionClient] PCObserver => onSignalingChange() => SignalingState: " + newState);
        }

        public void onIceConnectionChange(PeerConnection.IceConnectionState newState) {
            executor.execute(() -> {
                Logger.d("[_PeerConnectionClient] PCObserver => onIceConnectionChange() => IceConnectionState: " + newState);
                if (newState == PeerConnection.IceConnectionState.CONNECTED) {
                    _PeerConnectionClient.this.events.onIceConnected();
                } else if (newState == PeerConnection.IceConnectionState.DISCONNECTED) {
                    _PeerConnectionClient.this.events.onIceDisconnected();
                } else if (newState == PeerConnection.IceConnectionState.FAILED) {
                    _PeerConnectionClient.this.events.onIceFailed();
                }
            });
        }

        public void onConnectionChange(PeerConnection.PeerConnectionState newState) {
            executor.execute(() -> {
                Logger.d("[_PeerConnectionClient] PCObserver => onConnectionChange() => PeerConnectionState: " + newState);
                if (newState == PeerConnection.PeerConnectionState.CONNECTED) {
                    _PeerConnectionClient.this.events.onConnected();
                } else if (newState == PeerConnection.PeerConnectionState.DISCONNECTED) {
                    _PeerConnectionClient.this.events.onDisconnected();
                } else if (newState == PeerConnection.PeerConnectionState.FAILED) {
                    _PeerConnectionClient.this.events.onFailed();
                }
            });
        }

        public void onIceGatheringChange(PeerConnection.IceGatheringState newState) {
            Logger.d("[_PeerConnectionClient] PCObserver => onIceGatheringChange() => IceGatheringState: " + newState);
        }

        public void onIceConnectionReceivingChange(boolean receiving) {
            Logger.d("[_PeerConnectionClient] PCObserver => onIceConnectionReceivingChange() => IceConnectionReceiving changed to " + receiving);
        }

        public void onAddStream(MediaStream stream) {
            Logger.d("[_PeerConnectionClient] PCObserver => onAddStream()");
        }

        public void onRemoveStream(MediaStream stream) {
            Logger.d("[_PeerConnectionClient] PCObserver => onRemoveStream()");
        }

        public void onDataChannel(DataChannel dc) {
        }

        public void onRenegotiationNeeded() {
            Logger.d("[_PeerConnectionClient] PCObserver => onRenegotiationNeeded()");
        }

        public void onAddTrack(RtpReceiver receiver, MediaStream[] mediaStreams) {
            Logger.d("[_PeerConnectionClient] PCObserver => onAddTrack()");
        }
    }

    public static class PeerConnectionParameters {
        public final boolean videoCallEnabled;
        public final int videoMaxBitrate;
        public final String videoCodec;
        public final boolean videoCodecHwAcceleration;
        public final boolean videoFlexfecEnabled;
        public final int audioStartBitrate;
        public final String audioCodec;
        public final boolean noAudioProcessing;
        public final boolean useOpenSLES;
        public final boolean disableBuiltInAEC;
        public final boolean disableBuiltInAGC;
        public final boolean disableBuiltInNS;
        public final boolean disableWebRtcAGCAndHPF;

        public PeerConnectionParameters(boolean videoCallEnabled, int videoMaxBitrate, String videoCodec, boolean videoCodecHwAcceleration, boolean videoFlexfecEnabled, int audioStartBitrate, String audioCodec, boolean noAudioProcessing, boolean useOpenSLES, boolean disableBuiltInAEC, boolean disableBuiltInAGC, boolean disableBuiltInNS, boolean disableWebRtcAGCAndHPF) {
            this.videoCallEnabled = videoCallEnabled;
            this.videoMaxBitrate = videoMaxBitrate;
            this.videoCodec = videoCodec;
            this.videoFlexfecEnabled = videoFlexfecEnabled;
            this.videoCodecHwAcceleration = videoCodecHwAcceleration;
            this.audioStartBitrate = audioStartBitrate;
            this.audioCodec = audioCodec;
            this.noAudioProcessing = noAudioProcessing;
            this.useOpenSLES = useOpenSLES;
            this.disableBuiltInAEC = disableBuiltInAEC;
            this.disableBuiltInAGC = disableBuiltInAGC;
            this.disableBuiltInNS = disableBuiltInNS;
            this.disableWebRtcAGCAndHPF = disableWebRtcAGCAndHPF;
        }
    }
}

