/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.support.annotation.NonNull;
import com.sendbird.calls.Command;
import com.sendbird.calls.CommandSender;
import com.sendbird.calls.DirectCallEndResult;
import com.sendbird.calls.DirectCallLog;
import com.sendbird.calls.DirectCallLogListRequest;
import com.sendbird.calls.DirectCallLogListResponse;
import com.sendbird.calls.DirectCallUserRole;
import com.sendbird.calls.SendBirdCall;
import com.sendbird.calls.SendBirdException;
import com.sendbird.calls.handler.DirectCallLogListQueryResultHandler;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class DirectCallLogListQuery {
    private CommandSender mCommandSender;
    private Params mParams;
    private AtomicBoolean mIsLoading = new AtomicBoolean(false);
    private AtomicBoolean mHasNext = new AtomicBoolean(true);
    private String mToken;
    private String mMyUserId;

    DirectCallLogListQuery(@NonNull CommandSender commandRouter, @NonNull Params params, @NonNull String myUserId) {
        this.mCommandSender = commandRouter;
        this.mParams = params;
        this.mMyUserId = myUserId;
    }

    public boolean isLoading() {
        return this.mIsLoading.get();
    }

    public boolean hasNext() {
        return this.mHasNext.get();
    }

    public void next(DirectCallLogListQueryResultHandler handler) {
        if (!this.mHasNext.get()) {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(new ArrayList<DirectCallLog>(), null));
            }
            return;
        }
        if (!this.mIsLoading.compareAndSet(false, true)) {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(null, SendBirdException.getSendBirdException(1800206)));
            }
            return;
        }
        DirectCallLogListRequest request = new DirectCallLogListRequest(this.mMyUserId, this.mParams.mMyRole, this.mParams.mEndResults, this.mParams.mLimit, this.mToken);
        this.mCommandSender.send((Command)request, (response, e) -> {
            this.mIsLoading.set(false);
            if (e != null) {
                if (handler != null) {
                    SendBirdCall.runOnThreadOption(() -> handler.onResult(null, e));
                }
                return;
            }
            if (response instanceof DirectCallLogListResponse) {
                DirectCallLogListResponse res = (DirectCallLogListResponse)response;
                this.mToken = res.getNextToken();
                this.mHasNext.set(res.hasNext());
                if (handler != null) {
                    SendBirdCall.runOnThreadOption(() -> handler.onResult(res.getCallLogs(), null));
                }
            } else {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(null, SendBirdException.getSendBirdException(1800205)));
            }
        });
    }

    public static class Params {
        DirectCallUserRole mMyRole;
        List<DirectCallEndResult> mEndResults;
        int mLimit = 10;

        public Params setMyRole(DirectCallUserRole myRole) {
            this.mMyRole = myRole;
            return this;
        }

        public Params setEndResults(List<DirectCallEndResult> endResults) {
            this.mEndResults = endResults;
            return this;
        }

        public Params setLimit(int limit) {
            this.mLimit = limit <= 0 ? 10 : (limit > 100 ? 100 : limit);
            return this;
        }
    }
}

