/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.support.annotation.NonNull;
import com.sendbird.calls.DirectCall;
import com.sendbird.calls.DirectCallClosingState;
import com.sendbird.calls.DirectCallConnectedState;
import com.sendbird.calls.DirectCallState;
import com.sendbird.calls.DirectCallUserRole;
import org.webrtc.SessionDescription;

class DirectCallIceRestartingState
extends DirectCallState {
    private String mSdp;

    DirectCallIceRestartingState(String sdp) {
        this.setTimerDelay(30000L);
        this.mSdp = sdp;
    }

    @Override
    @NonNull
    String getStateName() {
        return DirectCallIceRestartingState.class.getSimpleName();
    }

    @Override
    void onCreate(DirectCall call) {
        if (this.mSdp != null && call.getMyRole() == DirectCallUserRole.CALLEE) {
            call.setRemoteDescription(SessionDescription.Type.OFFER, this.mSdp);
        } else if (call.getMyRole() == DirectCallUserRole.CALLER) {
            call.createOffer(true);
        }
    }

    @Override
    void onDestroy(DirectCall call) {
    }

    @Override
    void onOfferReceived(DirectCall call, String sdp) {
        super.onOfferReceived(call, sdp);
        call.setRemoteDescription(SessionDescription.Type.OFFER, sdp);
    }

    @Override
    void onAnswerReceived(DirectCall call, String sdp) {
        super.onAnswerReceived(call, sdp);
        call.setRemoteDescription(SessionDescription.Type.ANSWER, sdp);
    }

    @Override
    void end(DirectCall call) {
        super.end(call);
        call.sendEndRequest();
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void unknownEnd(DirectCall call) {
        super.unknownEnd(call);
        call.sendUnknownEndRequest();
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void timeout(DirectCall call) {
        super.timeout(call);
        call.sendConnectionLostRequest();
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onEndReceived(DirectCall call) {
        super.onEndReceived(call);
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onIceConnected(DirectCall call) {
        super.onIceConnected(call);
        call.changeState(new DirectCallConnectedState(true));
    }

    @Override
    void onConnectionLostReceived(DirectCall call) {
        super.onConnectionLostReceived(call);
        call.changeState(new DirectCallClosingState());
    }
}

