/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.os.ParcelFileDescriptor;
import java.io.File;
import java.io.IOException;
import org.webrtc.PeerConnection;

class _RtcEventLog {
    private static final String TAG = "RtcEventLog";
    private static final int OUTPUT_FILE_MAX_BYTES = 10000000;
    private final PeerConnection peerConnection;
    private RtcEventLogState state = RtcEventLogState.INACTIVE;

    public _RtcEventLog(PeerConnection peerConnection) {
        if (peerConnection == null) {
            throw new NullPointerException("The peer connection is null.");
        }
        this.peerConnection = peerConnection;
    }

    public void start(File outputFile) {
        ParcelFileDescriptor fileDescriptor;
        if (this.state == RtcEventLogState.STARTED) {
            return;
        }
        try {
            fileDescriptor = ParcelFileDescriptor.open((File)outputFile, (int)0x3C000000);
        }
        catch (IOException e) {
            return;
        }
        boolean success = this.peerConnection.startRtcEventLog(fileDescriptor.detachFd(), 10000000);
        if (!success) {
            return;
        }
        this.state = RtcEventLogState.STARTED;
    }

    public void stop() {
        if (this.state != RtcEventLogState.STARTED) {
            return;
        }
        this.peerConnection.stopRtcEventLog();
        this.state = RtcEventLogState.STOPPED;
    }

    static enum RtcEventLogState {
        INACTIVE,
        STARTED,
        STOPPED;

    }
}

