/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.os.Build;
import android.support.annotation.Nullable;
import com.sendbird.calls._AppRTCUtils;
import org.webrtc.ThreadUtils;

class _AppRTCProximitySensor
implements SensorEventListener {
    private static final String TAG = "AppRTCProximitySensor";
    private final ThreadUtils.ThreadChecker threadChecker = new ThreadUtils.ThreadChecker();
    private final Runnable onSensorStateListener;
    private final SensorManager sensorManager;
    @Nullable
    private Sensor proximitySensor;
    private boolean lastStateReportIsNear;

    static _AppRTCProximitySensor create(Context context, Runnable sensorStateListener) {
        return new _AppRTCProximitySensor(context, sensorStateListener);
    }

    private _AppRTCProximitySensor(Context context, Runnable sensorStateListener) {
        this.onSensorStateListener = sensorStateListener;
        this.sensorManager = (SensorManager)context.getSystemService("sensor");
    }

    public boolean start() {
        this.threadChecker.checkIsOnValidThread();
        if (!this.initDefaultSensor()) {
            return false;
        }
        this.sensorManager.registerListener((SensorEventListener)this, this.proximitySensor, 3);
        return true;
    }

    public void stop() {
        this.threadChecker.checkIsOnValidThread();
        if (this.proximitySensor == null) {
            return;
        }
        this.sensorManager.unregisterListener((SensorEventListener)this, this.proximitySensor);
    }

    public boolean sensorReportsNearState() {
        this.threadChecker.checkIsOnValidThread();
        return this.lastStateReportIsNear;
    }

    public final void onAccuracyChanged(Sensor sensor, int accuracy) {
        this.threadChecker.checkIsOnValidThread();
        _AppRTCUtils.assertIsTrue(sensor.getType() == 8);
        if (accuracy == 0) {
            // empty if block
        }
    }

    public final void onSensorChanged(SensorEvent event) {
        this.threadChecker.checkIsOnValidThread();
        _AppRTCUtils.assertIsTrue(event.sensor.getType() == 8);
        float distanceInCentimeters = event.values[0];
        this.lastStateReportIsNear = distanceInCentimeters < this.proximitySensor.getMaximumRange();
        if (this.onSensorStateListener != null) {
            this.onSensorStateListener.run();
        }
    }

    private boolean initDefaultSensor() {
        if (this.proximitySensor != null) {
            return true;
        }
        this.proximitySensor = this.sensorManager.getDefaultSensor(8);
        if (this.proximitySensor == null) {
            return false;
        }
        this.logProximitySensorInfo();
        return true;
    }

    private void logProximitySensorInfo() {
        if (this.proximitySensor == null) {
            return;
        }
        StringBuilder info = new StringBuilder("Proximity sensor: ");
        info.append("name=").append(this.proximitySensor.getName());
        info.append(", vendor: ").append(this.proximitySensor.getVendor());
        info.append(", power: ").append(this.proximitySensor.getPower());
        info.append(", resolution: ").append(this.proximitySensor.getResolution());
        info.append(", max range: ").append(this.proximitySensor.getMaximumRange());
        info.append(", min delay: ").append(this.proximitySensor.getMinDelay());
        if (Build.VERSION.SDK_INT >= 20) {
            info.append(", type: ").append(this.proximitySensor.getStringType());
        }
        if (Build.VERSION.SDK_INT >= 21) {
            info.append(", max delay: ").append(this.proximitySensor.getMaxDelay());
            info.append(", reporting mode: ").append(this.proximitySensor.getReportingMode());
            info.append(", isWakeUpSensor: ").append(this.proximitySensor.isWakeUpSensor());
        }
    }
}

