/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.os.Build;
import android.support.annotation.Nullable;
import com.sendbird.calls.AudioDevice;
import com.sendbird.calls._AppRTCBluetoothManager;
import com.sendbird.calls._AppRTCProximitySensor;
import com.sendbird.calls._AppRTCUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.webrtc.ThreadUtils;

class _AppRTCAudioManager {
    private static final String TAG = "AppRTCAudioManager";
    private static final String SPEAKERPHONE_AUTO = "auto";
    private static final String SPEAKERPHONE_TRUE = "true";
    private static final String SPEAKERPHONE_FALSE = "false";
    private final Context apprtcContext;
    @Nullable
    private AudioManager audioManager;
    @Nullable
    private AudioManagerEvents audioManagerEvents;
    private AudioManagerState amState;
    private int savedAudioMode = -2;
    private boolean savedIsSpeakerPhoneOn;
    private boolean savedIsMicrophoneMute;
    private boolean hasWiredHeadset;
    private AudioDevice defaultAudioDevice;
    private AudioDevice selectedAudioDevice;
    private AudioDevice userSelectedAudioDevice;
    @Nullable
    private final String useSpeakerphone;
    @Nullable
    private _AppRTCProximitySensor proximitySensor;
    private final _AppRTCBluetoothManager bluetoothManager;
    private Set<AudioDevice> audioDevices = new HashSet<AudioDevice>();
    private BroadcastReceiver wiredHeadsetReceiver;
    @Nullable
    private AudioManager.OnAudioFocusChangeListener audioFocusChangeListener;

    private void onProximitySensorChangedState() {
        if (!this.useSpeakerphone.equals(SPEAKERPHONE_AUTO)) {
            return;
        }
        if (this.audioDevices.size() == 2 && this.audioDevices.contains((Object)AudioDevice.EARPIECE) && this.audioDevices.contains((Object)AudioDevice.SPEAKERPHONE)) {
            if (this.proximitySensor.sensorReportsNearState()) {
                this.setAudioDeviceInternal(AudioDevice.EARPIECE);
            } else {
                this.setAudioDeviceInternal(AudioDevice.SPEAKERPHONE);
            }
        }
    }

    public static _AppRTCAudioManager create(Context context, boolean isVideoCall) {
        return new _AppRTCAudioManager(context, isVideoCall);
    }

    private _AppRTCAudioManager(Context context, boolean isVideoCall) {
        ThreadUtils.checkIsOnMainThread();
        this.apprtcContext = context;
        this.audioManager = (AudioManager)context.getSystemService("audio");
        this.bluetoothManager = _AppRTCBluetoothManager.create(context, this);
        this.wiredHeadsetReceiver = new WiredHeadsetReceiver();
        this.amState = AudioManagerState.UNINITIALIZED;
        this.useSpeakerphone = !isVideoCall && this.hasEarpiece() ? SPEAKERPHONE_FALSE : SPEAKERPHONE_AUTO;
        this.defaultAudioDevice = this.useSpeakerphone.equals(SPEAKERPHONE_FALSE) ? AudioDevice.EARPIECE : AudioDevice.SPEAKERPHONE;
        this.proximitySensor = _AppRTCProximitySensor.create(context, this::onProximitySensorChangedState);
        _AppRTCUtils.logDeviceInfo(TAG);
    }

    public void start(AudioManagerEvents audioManagerEvents) {
        ThreadUtils.checkIsOnMainThread();
        if (this.amState == AudioManagerState.RUNNING) {
            return;
        }
        this.audioManagerEvents = audioManagerEvents;
        this.amState = AudioManagerState.RUNNING;
        this.savedAudioMode = this.audioManager.getMode();
        this.savedIsSpeakerPhoneOn = this.audioManager.isSpeakerphoneOn();
        this.savedIsMicrophoneMute = this.audioManager.isMicrophoneMute();
        this.hasWiredHeadset = this.hasWiredHeadset();
        this.audioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

            public void onAudioFocusChange(int focusChange) {
                switch (focusChange) {
                    case 1: {
                        String typeOfChange = "AUDIOFOCUS_GAIN";
                        break;
                    }
                    case 2: {
                        String typeOfChange = "AUDIOFOCUS_GAIN_TRANSIENT";
                        break;
                    }
                    case 4: {
                        String typeOfChange = "AUDIOFOCUS_GAIN_TRANSIENT_EXCLUSIVE";
                        break;
                    }
                    case 3: {
                        String typeOfChange = "AUDIOFOCUS_GAIN_TRANSIENT_MAY_DUCK";
                        break;
                    }
                    case -1: {
                        String typeOfChange = "AUDIOFOCUS_LOSS";
                        break;
                    }
                    case -2: {
                        String typeOfChange = "AUDIOFOCUS_LOSS_TRANSIENT";
                        break;
                    }
                    case -3: {
                        String typeOfChange = "AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK";
                        break;
                    }
                    default: {
                        String typeOfChange = "AUDIOFOCUS_INVALID";
                    }
                }
            }
        };
        int result = this.audioManager.requestAudioFocus(this.audioFocusChangeListener, 0, 2);
        if (result == 1) {
            // empty if block
        }
        this.audioManager.setMode(3);
        this.setMicrophoneMute(false);
        this.userSelectedAudioDevice = null;
        this.selectedAudioDevice = null;
        this.audioDevices.clear();
        this.bluetoothManager.start();
        this.updateAudioDeviceState();
        this.registerReceiver(this.wiredHeadsetReceiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
    }

    public void stop() {
        ThreadUtils.checkIsOnMainThread();
        if (this.amState != AudioManagerState.RUNNING) {
            return;
        }
        this.amState = AudioManagerState.UNINITIALIZED;
        this.unregisterReceiver(this.wiredHeadsetReceiver);
        this.bluetoothManager.stop();
        this.setSpeakerphoneOn(this.savedIsSpeakerPhoneOn);
        this.setMicrophoneMute(this.savedIsMicrophoneMute);
        this.audioManager.setMode(this.savedAudioMode);
        this.audioManager.abandonAudioFocus(this.audioFocusChangeListener);
        this.audioFocusChangeListener = null;
        if (this.proximitySensor != null) {
            this.proximitySensor.stop();
            this.proximitySensor = null;
        }
        this.audioManagerEvents = null;
    }

    private void setAudioDeviceInternal(AudioDevice device) {
        _AppRTCUtils.assertIsTrue(this.audioDevices.contains((Object)device));
        switch (device) {
            case SPEAKERPHONE: {
                this.setSpeakerphoneOn(true);
                break;
            }
            case EARPIECE: {
                this.setSpeakerphoneOn(false);
                break;
            }
            case WIRED_HEADSET: {
                this.setSpeakerphoneOn(false);
                break;
            }
            case BLUETOOTH: {
                this.setSpeakerphoneOn(false);
                break;
            }
        }
        this.selectedAudioDevice = device;
    }

    public void setDefaultAudioDevice(AudioDevice defaultDevice) {
        ThreadUtils.checkIsOnMainThread();
        switch (defaultDevice) {
            case SPEAKERPHONE: {
                this.defaultAudioDevice = defaultDevice;
                break;
            }
            case EARPIECE: {
                if (this.hasEarpiece()) {
                    this.defaultAudioDevice = defaultDevice;
                    break;
                }
                this.defaultAudioDevice = AudioDevice.SPEAKERPHONE;
                break;
            }
        }
        this.updateAudioDeviceState();
    }

    void setDefaultAudioDeviceWithoutUpdate(AudioDevice defaultDevice) {
        ThreadUtils.checkIsOnMainThread();
        switch (defaultDevice) {
            case SPEAKERPHONE: {
                this.defaultAudioDevice = defaultDevice;
                break;
            }
            case EARPIECE: {
                if (this.hasEarpiece()) {
                    this.defaultAudioDevice = defaultDevice;
                    break;
                }
                this.defaultAudioDevice = AudioDevice.SPEAKERPHONE;
                break;
            }
        }
    }

    public boolean selectAudioDevice(AudioDevice device) {
        ThreadUtils.checkIsOnMainThread();
        if (!this.audioDevices.contains((Object)device)) {
            return false;
        }
        this.userSelectedAudioDevice = device;
        this.updateAudioDeviceState();
        return true;
    }

    public Set<AudioDevice> getAudioDevices() {
        ThreadUtils.checkIsOnMainThread();
        return Collections.unmodifiableSet(new HashSet<AudioDevice>(this.audioDevices));
    }

    public AudioDevice getSelectedAudioDevice() {
        ThreadUtils.checkIsOnMainThread();
        return this.selectedAudioDevice;
    }

    private void registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        this.apprtcContext.registerReceiver(receiver, filter);
    }

    private void unregisterReceiver(BroadcastReceiver receiver) {
        this.apprtcContext.unregisterReceiver(receiver);
    }

    private void setSpeakerphoneOn(boolean on) {
        boolean wasOn = this.audioManager.isSpeakerphoneOn();
        if (wasOn == on) {
            return;
        }
        this.audioManager.setSpeakerphoneOn(on);
    }

    private void setMicrophoneMute(boolean on) {
        boolean wasMuted = this.audioManager.isMicrophoneMute();
        if (wasMuted == on) {
            return;
        }
        this.audioManager.setMicrophoneMute(on);
    }

    boolean hasEarpiece() {
        return this.apprtcContext.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    @Deprecated
    private boolean hasWiredHeadset() {
        AudioDeviceInfo[] devices;
        if (Build.VERSION.SDK_INT < 23) {
            return this.audioManager.isWiredHeadsetOn();
        }
        for (AudioDeviceInfo device : devices = this.audioManager.getDevices(3)) {
            int type = device.getType();
            if (type == 3) {
                return true;
            }
            if (type != 11) continue;
            return true;
        }
        return false;
    }

    public void updateAudioDeviceState() {
        AudioDevice newAudioDevice;
        boolean needBluetoothAudioStop;
        ThreadUtils.checkIsOnMainThread();
        if (this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.HEADSET_AVAILABLE || this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.HEADSET_UNAVAILABLE || this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.SCO_DISCONNECTING) {
            this.bluetoothManager.updateDevice();
        }
        HashSet<AudioDevice> newAudioDevices = new HashSet<AudioDevice>();
        if (this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.SCO_CONNECTED || this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.SCO_CONNECTING || this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.HEADSET_AVAILABLE) {
            newAudioDevices.add(AudioDevice.BLUETOOTH);
        }
        if (this.hasWiredHeadset) {
            newAudioDevices.add(AudioDevice.WIRED_HEADSET);
        } else {
            newAudioDevices.add(AudioDevice.SPEAKERPHONE);
            if (this.hasEarpiece()) {
                newAudioDevices.add(AudioDevice.EARPIECE);
            }
        }
        boolean audioDeviceSetUpdated = !this.audioDevices.equals(newAudioDevices);
        this.audioDevices = newAudioDevices;
        if (this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.HEADSET_UNAVAILABLE && this.userSelectedAudioDevice == AudioDevice.BLUETOOTH) {
            this.userSelectedAudioDevice = null;
        }
        if (this.hasWiredHeadset && this.userSelectedAudioDevice == AudioDevice.SPEAKERPHONE) {
            this.userSelectedAudioDevice = AudioDevice.WIRED_HEADSET;
        }
        if (!this.hasWiredHeadset && this.userSelectedAudioDevice == AudioDevice.WIRED_HEADSET) {
            this.userSelectedAudioDevice = AudioDevice.SPEAKERPHONE;
        }
        boolean needBluetoothAudioStart = this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.HEADSET_AVAILABLE && (this.userSelectedAudioDevice == null || this.userSelectedAudioDevice == AudioDevice.BLUETOOTH);
        boolean bl = needBluetoothAudioStop = (this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.SCO_CONNECTED || this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.SCO_CONNECTING) && this.userSelectedAudioDevice != null && this.userSelectedAudioDevice != AudioDevice.BLUETOOTH;
        if (this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.HEADSET_AVAILABLE || this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.SCO_CONNECTING || this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.SCO_CONNECTED) {
            // empty if block
        }
        if (needBluetoothAudioStop) {
            this.bluetoothManager.stopScoAudio();
            this.bluetoothManager.updateDevice();
        }
        if (needBluetoothAudioStart && !needBluetoothAudioStop && !this.bluetoothManager.startScoAudio()) {
            this.audioDevices.remove((Object)AudioDevice.BLUETOOTH);
            audioDeviceSetUpdated = true;
        }
        if ((newAudioDevice = this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.SCO_CONNECTED ? AudioDevice.BLUETOOTH : (this.hasWiredHeadset ? AudioDevice.WIRED_HEADSET : this.defaultAudioDevice)) != this.selectedAudioDevice || audioDeviceSetUpdated) {
            this.setAudioDeviceInternal(newAudioDevice);
            if (this.audioManagerEvents != null) {
                this.audioManagerEvents.onAudioDeviceChanged(this.selectedAudioDevice, this.audioDevices);
            }
        }
    }

    private class WiredHeadsetReceiver
    extends BroadcastReceiver {
        private static final int STATE_UNPLUGGED = 0;
        private static final int STATE_PLUGGED = 1;
        private static final int HAS_NO_MIC = 0;
        private static final int HAS_MIC = 1;

        private WiredHeadsetReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            int state = intent.getIntExtra("state", 0);
            int microphone = intent.getIntExtra("microphone", 0);
            String name = intent.getStringExtra("name");
            _AppRTCAudioManager.this.hasWiredHeadset = state == 1;
            _AppRTCAudioManager.this.updateAudioDeviceState();
        }
    }

    public static interface AudioManagerEvents {
        public void onAudioDeviceChanged(AudioDevice var1, Set<AudioDevice> var2);
    }

    public static enum AudioManagerState {
        UNINITIALIZED,
        PREINITIALIZED,
        RUNNING;

    }
}

