/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

public class SendBirdError {
    public static final int DIAL_CANCELED = 1800100;
    public static final int MY_USER_ID_NOT_ALLOWED = 1800101;
    public static final int ERR_REQUEST_FAILED = 1800200;
    public static final int ERR_NO_RESPONSE_DUE_TO_TIMEOUT = 1800203;
    public static final int ERR_REQUEST_FAILED_DUE_TO_WEBSOCKET_CONNECTION_LOST = 1800204;
    public static final int ERR_WRONG_RESPONSE = 1800205;
    public static final int ERR_QUERY_IN_PROGRESS = 1800206;
    public static final int INTERNAL_SERVER_ERROR = 1800207;
    public static final int ERR_MALFORMED_DATA = 1800208;
    public static final int INVALID_PARAMETER_VALUE = 1800300;
    public static final int INVALID_PARAMETER_TYPE = 1800301;
    public static final int INSTANCE_NOT_INITIALIZED = 1800302;
    public static final int USER_NOT_AUTHENTICATED = 1800303;

    static String getErrorString(int errorCode) {
        return SendBirdError.getErrorString(errorCode, "");
    }

    static String getErrorString(int errorCode, String invalidParameter) {
        switch (errorCode) {
            case 1800100: {
                return "Call canceled before receiving a callback.";
            }
            case 1800101: {
                return "The caller can't dial their own user ID.";
            }
            case 1800200: {
                return "The http request failed.";
            }
            case 1800203: {
                return "The request failed to receive a response due to timeout.";
            }
            case 1800204: {
                return "The request failed because the websocket connection is lost.";
            }
            case 1800205: {
                return "The response contains an unexpected object type of data.";
            }
            case 1800206: {
                return "The previous query is still in progress.";
            }
            case 1800207: {
                return "An internal server error has occurred.";
            }
            case 1800208: {
                return "The data format of the response is invalid.";
            }
            case 1800300: {
                return invalidParameter + " is an invalid or empty value.";
            }
            case 1800301: {
                return "The data type of " + invalidParameter + " is invalid.";
            }
            case 1800302: {
                return "SendBirdCall instance not initialized.";
            }
            case 1800303: {
                return "The user is not authenticated.";
            }
        }
        return "";
    }
}

