/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.support.annotation.NonNull;
import com.sendbird.calls.AcceptParams;
import com.sendbird.calls.AcceptPushCommand;
import com.sendbird.calls.DirectCall;
import com.sendbird.calls.Logger;
import com.sendbird.calls.SendBirdException;

abstract class DirectCallState {
    private long mTimerDelay = 60000L;

    DirectCallState() {
    }

    @NonNull
    abstract String getStateName();

    abstract void onCreate(DirectCall var1);

    abstract void onDestroy(DirectCall var1);

    void setTimerDelay(long delayMillis) {
        this.mTimerDelay = delayMillis;
    }

    long getTimerDelay() {
        return this.mTimerDelay;
    }

    void onDialAckReceived(DirectCall call, SendBirdException e) {
        Logger.d("[" + this.getStateName() + "] onDialAckReceived(callId: " + call.getCallId() + ", e: " + e + ")");
    }

    void accept(DirectCall call, AcceptParams params) {
        Logger.d("[" + this.getStateName() + "] accept(callId: " + call.getCallId() + ")");
    }

    void onAcceptAckReceived(DirectCall call, SendBirdException e) {
        Logger.d("[" + this.getStateName() + "] onAcceptAckReceived(callId: " + call.getCallId() + ", e: " + e + ")");
    }

    void end(DirectCall call) {
        Logger.d("[" + this.getStateName() + "] end(callId: " + call.getCallId() + ")");
    }

    void onCancelAckReceived(DirectCall call, SendBirdException e) {
        Logger.d("[" + this.getStateName() + "] onCancelAckReceived(callId: " + call.getCallId() + ", e: " + e + ")");
    }

    void onDeclineAckReceived(DirectCall call, SendBirdException e) {
        Logger.d("[" + this.getStateName() + "] onDeclineAckReceived(callId: " + call.getCallId() + ", e: " + e + ")");
    }

    void onNoAnswerAckReceived(DirectCall call, SendBirdException e) {
        Logger.d("[" + this.getStateName() + "] onNoAnswerAckReceived(callId: " + call.getCallId() + ", e: " + e + ")");
    }

    void onEndAckReceived(DirectCall call, SendBirdException e) {
        Logger.d("[" + this.getStateName() + "] onEndAckReceived(callId: " + call.getCallId() + ", e: " + e + ")");
    }

    void unknownEnd(DirectCall call) {
        Logger.d("[" + this.getStateName() + "] unknownEnd(callId: " + call.getCallId() + ")");
    }

    void onUnknownEndAckReceived(DirectCall call, SendBirdException e) {
        Logger.d("[" + this.getStateName() + "] onUnknownEndAckReceived(callId: " + call.getCallId() + ", e: " + e + ")");
    }

    void timeout(DirectCall call) {
        Logger.d("[" + this.getStateName() + "] timeout(callId: " + call.getCallId() + ")");
    }

    void onTimeoutAckReceived(DirectCall call, SendBirdException e) {
        Logger.d("[" + this.getStateName() + "] onTimeoutAckReceived(callId: " + call.getCallId() + ", e: " + e + ")");
    }

    void onDialReceived(DirectCall call) {
        Logger.d("[" + this.getStateName() + "] onDialReceived(callId: " + call.getCallId() + ")");
    }

    void onAcceptReceived(DirectCall call, AcceptPushCommand command) {
        Logger.d("[" + this.getStateName() + "] onAcceptReceived(callId: " + call.getCallId() + ")");
    }

    void onOtherDeviceAccepted(DirectCall call) {
        Logger.d("[" + this.getStateName() + "] onOtherDeviceAccepted(callId: " + call.getCallId() + ")");
    }

    void onOfferReceived(DirectCall call, String sdp) {
        Logger.d("[" + this.getStateName() + "] onOfferReceived(callId: " + call.getCallId() + ")");
    }

    void onAnswerReceived(DirectCall call, String sdp) {
        Logger.d("[" + this.getStateName() + "] onAnswerReceived(callId: " + call.getCallId() + ")");
    }

    void onIceConnected(DirectCall call) {
        Logger.d("[" + this.getStateName() + "] onIceConnected(callId: " + call.getCallId() + ")");
    }

    void onIceDisconnected(DirectCall call) {
        Logger.d("[" + this.getStateName() + "] onIceDisconnected(callId: " + call.getCallId() + ")");
    }

    void onIceFailed(DirectCall call) {
        Logger.d("[" + this.getStateName() + "] onIceFailed(callId: " + call.getCallId() + ")");
    }

    void onClosed(DirectCall call) {
        Logger.d("[" + this.getStateName() + "] onClosed(callId: " + call.getCallId() + ")");
    }

    void onCancelReceived(DirectCall call) {
        Logger.d("[" + this.getStateName() + "] onCancelReceived(callId: " + call.getCallId() + ")");
    }

    void onDeclineReceived(DirectCall call) {
        Logger.d("[" + this.getStateName() + "] onDeclineReceived(callId: " + call.getCallId() + ")");
    }

    void onNoAnswerReceived(DirectCall call) {
        Logger.d("[" + this.getStateName() + "] onNoAnswerReceived(callId: " + call.getCallId() + ")");
    }

    void onEndReceived(DirectCall call) {
        Logger.d("[" + this.getStateName() + "] onEndReceived(callId: " + call.getCallId() + ")");
    }

    void onUnknownEndReceived(DirectCall call) {
        Logger.d("[" + this.getStateName() + "] onUnknownEndReceived(callId: " + call.getCallId() + ")");
    }

    void onTimeoutReceived(DirectCall call) {
        Logger.d("[" + this.getStateName() + "] onTimeout(callId: " + call.getCallId() + ")");
    }

    void onConnectionLostReceived(DirectCall call) {
        Logger.d("[" + this.getStateName() + "] onConnectionLostReceived(callId: " + call.getCallId() + ")");
    }
}

