/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.support.annotation.NonNull;
import com.sendbird.calls.DirectCall;
import com.sendbird.calls.DirectCallClosingState;
import com.sendbird.calls.DirectCallConnectedState;
import com.sendbird.calls.DirectCallState;

class DirectCallReconnectingState
extends DirectCallState {
    DirectCallReconnectingState() {
        this.setTimerDelay(30000L);
    }

    @Override
    @NonNull
    String getStateName() {
        return DirectCallReconnectingState.class.getSimpleName();
    }

    @Override
    void onCreate(DirectCall call) {
        call.startStateTimer(this.getTimerDelay());
        call.dispatchEvent(DirectCall.DirectCallEventType.RECONNECTING);
    }

    @Override
    void onDestroy(DirectCall call) {
        call.stopStateTimer();
    }

    @Override
    void onIceConnected(DirectCall call) {
        super.onIceConnected(call);
        call.changeState(new DirectCallConnectedState(true));
    }

    @Override
    void end(DirectCall call) {
        super.end(call);
        call.sendEndRequest();
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void unknownEnd(DirectCall call) {
        super.unknownEnd(call);
        call.sendUnknownEndRequest();
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onEndReceived(DirectCall call) {
        super.onEndReceived(call);
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onConnectionLostReceived(DirectCall call) {
        super.onConnectionLostReceived(call);
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void timeout(DirectCall call) {
        super.timeout(call);
        call.sendConnectionLostRequest();
        call.changeState(new DirectCallClosingState());
    }
}

