/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.support.annotation.NonNull;
import com.sendbird.calls.AcceptPushCommand;
import com.sendbird.calls.DirectCall;
import com.sendbird.calls.DirectCallClosingState;
import com.sendbird.calls.DirectCallOfferingState;
import com.sendbird.calls.DirectCallState;

class DirectCallDialingState
extends DirectCallState {
    DirectCallDialingState() {
    }

    @Override
    @NonNull
    String getStateName() {
        return DirectCallDialingState.class.getSimpleName();
    }

    @Override
    void onCreate(DirectCall call) {
        call.startStateTimer(this.getTimerDelay());
        call.startAliveTimer();
        call.sendPendingStatusRequests();
    }

    @Override
    void onDestroy(DirectCall call) {
        call.stopStateTimer();
    }

    @Override
    void onAcceptReceived(DirectCall call, AcceptPushCommand command) {
        super.onAcceptReceived(call, command);
        call.setRemoteConstraints(command.getConstraints());
        call.setPeerConnectionClientConfiguration(command.getTurnCredential());
        call.changeState(new DirectCallOfferingState());
    }

    @Override
    void end(DirectCall call) {
        super.end(call);
        call.sendCancelRequest();
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void unknownEnd(DirectCall call) {
        super.unknownEnd(call);
        call.sendUnknownEndRequest();
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void timeout(DirectCall call) {
        super.timeout(call);
        call.sendNoAnswerRequest();
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onNoAnswerReceived(DirectCall call) {
        super.onNoAnswerReceived(call);
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onDeclineReceived(DirectCall call) {
        super.onDeclineReceived(call);
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onTimeoutReceived(DirectCall call) {
        super.onTimeoutReceived(call);
        call.changeState(new DirectCallClosingState());
    }
}

