/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import android.support.annotation.NonNull;
import com.sendbird.calls.ApiClient;
import com.sendbird.calls.ApiRequest;
import com.sendbird.calls.CallRequest;
import com.sendbird.calls.Command;
import com.sendbird.calls.CommandSender;
import com.sendbird.calls.Logger;
import com.sendbird.calls.ResponseHandler;
import com.sendbird.calls.WebSocketClient;

class CommandRouter
implements CommandSender {
    private ApiClient mApiClient;
    private WebSocketClient mWebSocketClient;
    private boolean mIsApiOnlyMode = false;

    CommandRouter(@NonNull ApiClient apiClient, @NonNull WebSocketClient webSocketClient) {
        this.mApiClient = apiClient;
        this.mWebSocketClient = webSocketClient;
    }

    @Override
    public void send(Command command, ResponseHandler handler) {
        if (command instanceof CallRequest) {
            if (this.mWebSocketClient.getConnectionState() == WebSocketClient.ConnectionState.CONNECTED && !this.mIsApiOnlyMode) {
                this.mWebSocketClient.send(command, handler);
            } else {
                if (this.mWebSocketClient.getConnectionState() != WebSocketClient.ConnectionState.CONNECTING && this.mWebSocketClient.getConnectionState() != WebSocketClient.ConnectionState.CONNECTED) {
                    this.mWebSocketClient.connect();
                }
                this.mApiClient.send(command, handler);
            }
        } else if (command instanceof ApiRequest) {
            this.mApiClient.send(command, handler);
        }
    }

    @Override
    public void setSessionToken(String sessionToken) {
        Logger.d("[CommandRouter] setSessionToken()");
        this.mApiClient.setSessionToken(sessionToken);
        this.mWebSocketClient.setSessionToken(sessionToken);
    }

    @Override
    public void destroy() {
        Logger.d("[CommandRouter] destroy()");
        this.mWebSocketClient.disconnect();
        this.setSessionToken(null);
    }

    void disconnectWebSocket() {
        this.mWebSocketClient.disconnect();
    }

    void connectWebSocket(WebSocketClient.WebSocketOpenListener listener) {
        this.mWebSocketClient.setWebSocketOpenListener(listener);
        this.mWebSocketClient.connect();
    }

    void setApiOnlyMode(boolean enable) {
        this.mIsApiOnlyMode = enable;
    }
}

