/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.calls;

import com.sendbird.calls.ApiRequest;
import com.sendbird.calls.AudioStreamStat;
import com.sendbird.calls.CommandFactory;
import com.sendbird.calls.DirectCallUserRole;
import com.sendbird.calls.shadow.com.google.gson.JsonObject;

class StatsLogRequest
implements ApiRequest {
    private String mAppId;
    private String mCallId;
    private DirectCallUserRole mRole;
    boolean mIsVideoCall;
    double mStatTimestamp;
    String mNetworkType;
    AudioStreamStat mAudioStreamStat;

    StatsLogRequest(String appId, String callId, DirectCallUserRole role, boolean isVideoCall, double statTimestamp, String networkType, AudioStreamStat audioStreamStat) {
        this.mAppId = appId;
        this.mCallId = callId;
        this.mRole = role;
        this.mIsVideoCall = isVideoCall;
        this.mStatTimestamp = statTimestamp;
        this.mNetworkType = networkType;
        this.mAudioStreamStat = audioStreamStat;
    }

    @Override
    public String getUrl() {
        return "/internal/sdk/logs";
    }

    @Override
    public ApiRequest.HttpRequestMethod getMethod() {
        return ApiRequest.HttpRequestMethod.POST;
    }

    @Override
    public boolean isSessionTokenNeeded() {
        return true;
    }

    @Override
    public boolean isInternalApi() {
        return true;
    }

    @Override
    public String getPayload() {
        JsonObject obj = new JsonObject();
        obj.addProperty("log_group", "sdk_webrtc_statistics_v1");
        JsonObject logData = new JsonObject();
        logData.addProperty("webrtc_timestamp", this.mStatTimestamp);
        logData.addProperty("device_timestamp", System.currentTimeMillis());
        logData.addProperty("app_id", this.mAppId);
        logData.addProperty("call_id", this.mCallId);
        logData.addProperty("role", this.mRole.toString());
        logData.addProperty("is_video_call", this.mIsVideoCall);
        logData.addProperty("network_type", this.mNetworkType);
        logData.add("audio", this.mAudioStreamStat.toJson());
        obj.add("log_data", logData);
        return CommandFactory.sGson.toJson(obj);
    }
}

