/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.sendbird.call.ApiClient;
import com.sendbird.call.AuthenticateParams;
import com.sendbird.call.AuthenticateRequest;
import com.sendbird.call.AuthenticateResponse;
import com.sendbird.call.CallManager;
import com.sendbird.call.CallOptions;
import com.sendbird.call.CancelPushCommand;
import com.sendbird.call.Command;
import com.sendbird.call.CommandRouter;
import com.sendbird.call.CommandSender;
import com.sendbird.call.DeleteCustomItemsRequest;
import com.sendbird.call.DeleteCustomItemsResponse;
import com.sendbird.call.DialParams;
import com.sendbird.call.DirectCall;
import com.sendbird.call.DirectCallLogListQuery;
import com.sendbird.call.EventDispatcher;
import com.sendbird.call.EventReceiver;
import com.sendbird.call.Logger;
import com.sendbird.call.RegisterPushTokenRequest;
import com.sendbird.call.SendBirdCall;
import com.sendbird.call.SendBirdException;
import com.sendbird.call.UnregisterAllPushTokensRequest;
import com.sendbird.call.UnregisterPushTokenRequest;
import com.sendbird.call.UpdateCustomItemsRequest;
import com.sendbird.call.UpdateCustomItemsResponse;
import com.sendbird.call.User;
import com.sendbird.call.WebSocketClient;
import com.sendbird.call.handler.AuthenticateHandler;
import com.sendbird.call.handler.CompletionHandler;
import com.sendbird.call.handler.CustomItemsHandler;
import com.sendbird.call.handler.DialHandler;
import com.sendbird.call.handler.SendBirdCallListener;
import com.sendbird.call.shadow.com.google.gson.JsonObject;
import com.sendbird.call.shadow.com.google.gson.JsonParser;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

class SendBirdCallMain {
    @NonNull
    private CommandSender mCommandSender;
    @NonNull
    private EventReceiver mEventReceiver;
    @NonNull
    private CallManager mCallManager;
    private User mCurrentUser;
    private Context mContext;
    private String mAppId;
    private String mClientId;
    private String mApiHost;
    private String mWsHost;

    SendBirdCallMain(Context context, String appId) {
        this.init(context, appId);
    }

    SendBirdCallMain(Context context, String appId, String apiHost, String wsHost) {
        this.mApiHost = apiHost;
        this.mWsHost = wsHost;
        this.init(context, appId, apiHost, wsHost);
    }

    void init() {
        String apiHost = this.mApiHost == null ? this.getApiHost(this.mAppId) : this.mApiHost;
        String wsHost = this.mWsHost == null ? this.getWsHost(this.mAppId) : this.mWsHost;
        this.init(this.mContext, this.mAppId, apiHost, wsHost);
    }

    void init(Context context, String appId) {
        this.init(context, appId, this.getApiHost(appId), this.getWsHost(appId));
    }

    private void init(Context context, String appId, String apiHost, String wsHost) {
        this.mContext = context;
        this.mAppId = appId;
        this.mClientId = UUID.randomUUID().toString();
        EventDispatcher eventDispatcher = new EventDispatcher();
        this.mEventReceiver = new EventReceiver(context, eventDispatcher);
        this.mCommandSender = new CommandRouter(new ApiClient(apiHost, this.mClientId), new WebSocketClient(this.mEventReceiver, wsHost, this.mClientId));
        this.mCallManager = new CallManager(context, this.mCommandSender);
        eventDispatcher.listen(this.mCallManager);
    }

    User getCurrentUser() {
        return this.mCurrentUser;
    }

    DirectCall getCall(String callId) {
        Logger.d("[SendBirdCall] getCall(callId: " + callId + ")");
        return this.mCallManager.getCall(callId);
    }

    void authenticate(String appId, AuthenticateParams params, AuthenticateHandler handler) {
        if (TextUtils.isEmpty((CharSequence)appId)) {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(null, SendBirdException.getSendBirdException("APP ID")));
            }
            return;
        }
        if (params == null) {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(null, SendBirdException.getSendBirdException("AuthenticateParams")));
            }
            return;
        }
        if (params.mUserId == null) {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(null, SendBirdException.getSendBirdException("User ID")));
            }
            return;
        }
        Runnable sendingAuthenticateRequest = () -> {
            AuthenticateRequest authenticateRequest = new AuthenticateRequest(appId, params.mUserId, params.mAccessToken, params.mPushToken, params.mIsUnique);
            this.mCommandSender.send((Command)authenticateRequest, (response, e) -> {
                if (e != null) {
                    if (handler != null) {
                        SendBirdCall.runOnThreadOption(() -> handler.onResult(null, e));
                    }
                    return;
                }
                this.setSessionToken(((AuthenticateResponse)response).getSessionToken());
                this.setCurrentUser(((AuthenticateResponse)response).getCurrentUser());
                if (handler != null) {
                    SendBirdCall.runOnThreadOption(() -> handler.onResult(this.mCurrentUser, null));
                }
            });
        };
        if (this.getCurrentUser() != null && this.getCurrentUser().getUserId() != null) {
            if (!TextUtils.equals((CharSequence)this.getCurrentUser().getUserId(), (CharSequence)params.mUserId)) {
                this.deauthenticate(e -> {
                    this.init();
                    sendingAuthenticateRequest.run();
                });
            }
        } else {
            sendingAuthenticateRequest.run();
        }
    }

    void deauthenticate(String pushToken, CompletionHandler handler) {
        if (this.getCurrentUser() == null) {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(SendBirdException.getSendBirdException(1800303)));
            }
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)pushToken)) {
            this.unregisterPushToken(pushToken, e -> {
                if (e == null) {
                    this.deauthenticate(handler);
                } else {
                    SendBirdCall.runOnThreadOption(() -> {
                        if (handler != null) {
                            handler.onResult(e);
                        }
                    });
                }
            });
        } else {
            this.deauthenticate(handler);
        }
    }

    void deauthenticate(CompletionHandler handler) {
        Thread thread = new Thread(() -> {
            this.mCallManager.endAllCalls();
            this.mCommandSender.destroy();
            this.setCurrentUser(null);
            SendBirdCall.runOnThreadOption(() -> {
                if (handler != null) {
                    handler.onResult(null);
                }
            });
        });
        thread.setPriority(10);
        thread.start();
    }

    void registerPushToken(String pushToken, boolean unique, CompletionHandler handler) {
        if (pushToken == null) {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(SendBirdException.getSendBirdException("Push Token")));
            }
            return;
        }
        if (this.getCurrentUser() == null) {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(SendBirdException.getSendBirdException(1800303)));
            }
            return;
        }
        RegisterPushTokenRequest registerPushTokenRequest = new RegisterPushTokenRequest(this.getCurrentUser().getUserId(), pushToken, unique);
        this.mCommandSender.send((Command)registerPushTokenRequest, (response, e) -> {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(e));
            }
        });
    }

    void unregisterPushToken(String pushToken, CompletionHandler handler) {
        if (pushToken == null && handler != null) {
            SendBirdCall.runOnThreadOption(() -> handler.onResult(SendBirdException.getSendBirdException("Push Token")));
        }
        if (this.getCurrentUser() == null) {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(SendBirdException.getSendBirdException(1800303)));
            }
            return;
        }
        UnregisterPushTokenRequest unregisterPushTokenRequest = new UnregisterPushTokenRequest(this.getCurrentUser().getUserId(), pushToken);
        this.mCommandSender.send((Command)unregisterPushTokenRequest, (response, e) -> {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(e));
            }
        });
    }

    void unregisterAllPushTokens(CompletionHandler handler) {
        if (this.getCurrentUser() == null) {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(SendBirdException.getSendBirdException(1800303)));
            }
            return;
        }
        UnregisterAllPushTokensRequest unregisterAllPushTokensRequest = new UnregisterAllPushTokensRequest(this.getCurrentUser().getUserId());
        this.mCommandSender.send((Command)unregisterAllPushTokensRequest, (response, e) -> {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(e));
            }
        });
    }

    DirectCall dial(String calleeId, boolean isVideoCall, CallOptions callOptions, DialHandler handler) {
        return this.dial(new DialParams(calleeId).setVideoCall(isVideoCall).setCallOptions(callOptions), handler);
    }

    DirectCall dial(DialParams params, DialHandler handler) {
        if (params == null) {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(null, SendBirdException.getSendBirdException("DialParams")));
            }
            return null;
        }
        if (params.mCalleeId == null) {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(null, SendBirdException.getSendBirdException("Callee ID")));
            }
            return null;
        }
        if (this.getCurrentUser() == null) {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(null, SendBirdException.getSendBirdException(1800303)));
            }
            return null;
        }
        if (params.mCalleeId.equals(this.getCurrentUser().getUserId())) {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(null, SendBirdException.getSendBirdException(1800101)));
            }
            return null;
        }
        if (params.mCallOptions == null) {
            params.mCallOptions = new CallOptions();
        }
        return this.mCallManager.dial(params, handler);
    }

    void addListener(String identifier, SendBirdCallListener listener) {
        if (identifier == null || identifier.length() == 0 || listener == null) {
            return;
        }
        this.mCallManager.addSendBirdCallListener(identifier, listener);
    }

    SendBirdCallListener removeListener(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        return this.mCallManager.removeSendBirdCallListener(identifier);
    }

    void removeAllListener() {
        this.mCallManager.removeAllSendBirdCallListeners();
    }

    boolean handleFirebaseMessageData(Map<String, String> data) {
        if (data.containsKey("sendbird_call")) {
            String payload = data.get("sendbird_call");
            try {
                boolean isMyCommand;
                JsonObject json = JsonParser.parseString((String)payload).getAsJsonObject();
                JsonObject command = json.has("command") ? json.get("command").getAsJsonObject() : null;
                String clientId = json.has("client_id") ? json.get("client_id").getAsString() : "";
                String receiverType = json.has("receiver_type") ? json.get("receiver_type").getAsString() : "";
                boolean bl = isMyCommand = receiverType.equals("user") || receiverType.equals("client") && this.mClientId.equals(clientId) || receiverType.equals("sibling") && !this.mClientId.equals(clientId);
                if (isMyCommand && command != null) {
                    this.mEventReceiver.onFcmPushMessageReceived(command);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    DirectCallLogListQuery createDirectCallLogListQuery(DirectCallLogListQuery.Params params) {
        if (params == null) {
            params = new DirectCallLogListQuery.Params();
        }
        return new DirectCallLogListQuery(this.mCommandSender, params, this.mCurrentUser.getUserId());
    }

    void updateCustomItems(String callId, Map<String, String> customItems, CustomItemsHandler handler) {
        if (customItems == null) {
            SendBirdCall.runOnThreadOption(() -> {
                if (handler != null) {
                    handler.onResult(null, null, SendBirdException.getSendBirdException("customItems"));
                }
            });
            return;
        }
        DirectCall directCall = this.mCallManager.getCall(callId);
        if (directCall != null) {
            directCall.updateCustomItems(customItems, handler);
        } else {
            UpdateCustomItemsRequest request = new UpdateCustomItemsRequest(callId, customItems);
            this.mCommandSender.send((Command)request, (response, e) -> {
                if (response instanceof UpdateCustomItemsResponse) {
                    SendBirdCall.runOnThreadOption(() -> {
                        if (handler != null) {
                            handler.onResult(((UpdateCustomItemsResponse)response).getCustomItems(), ((UpdateCustomItemsResponse)response).getUpdatedKeys(), e);
                        }
                    });
                } else {
                    SendBirdCall.runOnThreadOption(() -> {
                        if (handler != null) {
                            handler.onResult(null, null, SendBirdException.getSendBirdException(1800208));
                        }
                    });
                }
            });
        }
    }

    void deleteCustomItems(String callId, Set<String> customItemKeys, CustomItemsHandler handler) {
        DirectCall directCall = this.mCallManager.getCall(callId);
        if (directCall != null) {
            directCall.deleteCustomItems(customItemKeys, handler);
        } else {
            DeleteCustomItemsRequest request = new DeleteCustomItemsRequest(callId, customItemKeys);
            this.mCommandSender.send((Command)request, (response, e) -> {
                if (response instanceof DeleteCustomItemsResponse) {
                    SendBirdCall.runOnThreadOption(() -> {
                        if (handler != null) {
                            handler.onResult(((DeleteCustomItemsResponse)response).getCustomItems(), ((DeleteCustomItemsResponse)response).getDeletedKeys(), e);
                        }
                    });
                } else {
                    SendBirdCall.runOnThreadOption(() -> {
                        if (handler != null) {
                            handler.onResult(null, null, SendBirdException.getSendBirdException(1800208));
                        }
                    });
                }
            });
        }
    }

    void deleteAllCustomItems(String callId, CustomItemsHandler handler) {
        this.deleteCustomItems(callId, null, handler);
    }

    private void setSessionToken(String sessionToken) {
        this.mCommandSender.setSessionToken(sessionToken);
    }

    private void setCurrentUser(User user) {
        Logger.d("[SendBirdMain] setCurrentUser(" + (user != null ? user.getUserId() : "null") + ")");
        this.mCurrentUser = user;
    }

    private String getApiHost(String appId) {
        return "https://api-" + appId + ".v2oip.sendbird.com";
    }

    private String getWsHost(String appId) {
        return "wss://ws-" + appId + ".v2oip.sendbird.com";
    }

    void connectWebSocket(WebSocketClient.WebSocketOpenListener listener) {
        ((CommandRouter)this.mCommandSender).connectWebSocket(listener);
    }

    void disconnectWebSocket() {
        ((CommandRouter)this.mCommandSender).disconnectWebSocket();
    }

    void setApiOnlyMode(boolean enable) {
        ((CommandRouter)this.mCommandSender).setApiOnlyMode(enable);
    }

    void clearAllCalls() {
        this.mCallManager.clearAllCalls();
    }

    void simulateReceivingCancelPushCommand(CancelPushCommand command) {
        this.mEventReceiver.dispatch((Command)command);
    }
}

