/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import android.os.Bundle;
import java.util.Map;
import org.webrtc.RTCStats;

class RtcStatsUtils {
    RtcStatsUtils() {
    }

    static Bundle getInboundAudioStreamProperties(Map<String, RTCStats> rtcStatsMap) {
        Bundle bundle = new Bundle();
        for (Map.Entry<String, RTCStats> entry : rtcStatsMap.entrySet()) {
            Map members;
            if (entry.getKey().startsWith("RTCInboundRTPAudioStream")) {
                if (entry.getValue() == null) continue;
                members = entry.getValue().getMembers();
                try {
                    if (members.containsKey("codecId") && members.get("codecId") instanceof String) {
                        bundle.putString("codec", (String)rtcStatsMap.get(members.get("codecId")).getMembers().get("mimeType"));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("jitter") && members.get("jitter") instanceof Double) {
                        bundle.putDouble("jitter", ((Double)members.get("jitter")).doubleValue());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (members.containsKey("packetsLost") && members.get("packetsLost") instanceof Integer) {
                        bundle.putInt("packetsLost", ((Integer)members.get("packetsLost")).intValue());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (!members.containsKey("packetsReceived") || !(members.get("packetsReceived") instanceof Long)) continue;
                    bundle.putLong("packetsReceived", ((Long)members.get("packetsReceived")).longValue());
                }
                catch (Exception exception) {}
                continue;
            }
            if (!entry.getKey().startsWith("RTCOutboundRTPAudioStream") || entry.getValue() == null) continue;
            try {
                members = entry.getValue().getMembers();
                if (!members.containsKey("packetsSent") || !(members.get("packetsSent") instanceof Long)) continue;
                bundle.putLong("packetsSent", ((Long)members.get("packetsSent")).longValue());
            }
            catch (Exception exception) {}
        }
        return bundle;
    }

    static double getAudioStreamRtt(Map<String, RTCStats> rtcStatsMap) {
        for (Map.Entry<String, RTCStats> entry : rtcStatsMap.entrySet()) {
            if (!entry.getKey().startsWith("RTCRemoteInboundRtpAudioStream")) continue;
            try {
                return (Double)entry.getValue().getMembers().get("roundTripTime");
            }
            catch (ClassCastException e) {
                return -1.0;
            }
            catch (NullPointerException e) {
                return -1.0;
            }
        }
        return -1.0;
    }

    static double getTimestamp(Map<String, RTCStats> rtcStatsMap) {
        for (Map.Entry<String, RTCStats> entry : rtcStatsMap.entrySet()) {
            if (entry.getKey().startsWith("RTCRemoteInbound")) continue;
            return entry.getValue().getTimestampUs();
        }
        return 0.0;
    }

    static String getNetworkType(Map<String, RTCStats> rtcStatsMap) {
        RTCStats transportStat = rtcStatsMap.get("RTCTransport_0_1");
        if (transportStat == null) {
            return "";
        }
        try {
            String selectedCandidatePairId = (String)transportStat.getMembers().get("selectedCandidatePairId");
            RTCStats selectedCandidateStat = rtcStatsMap.get(selectedCandidatePairId);
            String localCandidateId = (String)selectedCandidateStat.getMembers().get("localCandidateId");
            RTCStats localCandidateStat = rtcStatsMap.get(localCandidateId);
            String networkType = (String)localCandidateStat.getMembers().get("networkType");
            return networkType == null ? "" : networkType;
        }
        catch (ClassCastException e) {
            return "";
        }
        catch (NullPointerException e) {
            return "";
        }
    }

    static double getMos(int jitter, int latency, double packetsLostRate) {
        if (jitter < 0 || latency < 0 || Double.isNaN(packetsLostRate)) {
            return 0.0;
        }
        double effectiveLatency = (double)(latency + 2 * jitter) + 10.0;
        double R = 0.0;
        R = effectiveLatency < 160.0 ? 93.2 - effectiveLatency / 40.0 : 93.2 - (effectiveLatency - 120.0) / 10.0;
        if ((R -= 2.5 * packetsLostRate) < 0.0) {
            return 1.0;
        }
        if (R >= 100.0) {
            return 4.5;
        }
        return 1.0 + 0.035 * R + 7.0E-6 * R * (R - 60.0) * (100.0 - R);
    }
}

