/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.media.projection.MediaProjection;
import android.support.annotation.Nullable;
import com.sendbird.call.AudioDevice;
import com.sendbird.call.CallOptions;
import com.sendbird.call.Logger;
import com.sendbird.call.SendBirdCall;
import com.sendbird.call.SendBirdVideoView;
import com.sendbird.call._AppRTCAudioManager;
import com.sendbird.call._PeerConnectionClient;
import com.sendbird.call.handler.CompletionHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.webrtc.Camera1Enumerator;
import org.webrtc.Camera2Enumerator;
import org.webrtc.CameraEnumerator;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.EglBase;
import org.webrtc.FileVideoCapturer;
import org.webrtc.IceCandidate;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.ScreenCapturerAndroid;
import org.webrtc.SessionDescription;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoFileRenderer;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;

class PeerConnectionClient {
    private static final int STAT_CALLBACK_PERIOD_MS = 3000;
    private final EglBase mEglBase = EglBase.create();
    private ProxyVideoSink mRemoteProxyVideoSink = new ProxyVideoSink();
    private ProxyVideoSink mLocalProxyVideoSink = new ProxyVideoSink();
    private List<VideoSink> mRemoteSinks = new ArrayList<VideoSink>();
    private VideoFileRenderer mRemoteVideoFileRenderer;
    private _PeerConnectionClient mPeerConnectionClient;
    private _AppRTCAudioManager mAudioManager;
    private SendBirdVideoView mLocalVideoView;
    private SendBirdVideoView mRemoteVideoView;
    private boolean mIsSwappedFeeds;

    PeerConnectionClient(Context context, boolean isVideoCall, CallOptions callOptions, List<PeerConnection.IceServer> iceServers, _PeerConnectionClient.PeerConnectionEvents peerConnectionEvents) {
        SendBirdCall.runOnUIThread(() -> {
            this.mPeerConnectionClient = this.ready(context, isVideoCall, callOptions, iceServers, peerConnectionEvents);
        });
    }

    private _PeerConnectionClient ready(Context context, boolean isVideoCall, CallOptions callOptions, List<PeerConnection.IceServer> iceServers, _PeerConnectionClient.PeerConnectionEvents peerConnectionEvents) {
        this.initViewRenderers(callOptions);
        _PeerConnectionClient peerConnectionClient = this.createPeerConnectionClient(context, isVideoCall, callOptions, iceServers, peerConnectionEvents);
        this.setStartOptions(callOptions);
        return peerConnectionClient;
    }

    private void initViewRenderers(CallOptions callOptions) {
        Logger.d("[PeerConnectionClient] initViewRenderers()");
        this.mLocalVideoView = callOptions.mLocalVideoView;
        this.mRemoteVideoView = callOptions.mRemoteVideoView;
        if (this.mLocalVideoView != null) {
            this.mLocalVideoView.init(this.mEglBase.getEglBaseContext(), null);
        }
        if (this.mRemoteVideoView != null && this.mRemoteVideoView != this.mLocalVideoView) {
            this.mRemoteVideoView.init(this.mEglBase.getEglBaseContext(), null);
        }
        this.mRemoteSinks.clear();
        this.mRemoteSinks.add(this.mRemoteProxyVideoSink);
        this.setSwappedFeeds(false);
    }

    private void setSwappedFeeds(boolean isSwappedFeeds) {
        this.mIsSwappedFeeds = isSwappedFeeds;
        if (this.mLocalVideoView != null) {
            this.mLocalVideoView.setMirror(!isSwappedFeeds);
        }
        if (this.mRemoteVideoView != null) {
            this.mRemoteVideoView.setMirror(isSwappedFeeds);
        }
        this.mLocalProxyVideoSink.setTarget((VideoSink)(isSwappedFeeds ? this.mRemoteVideoView : this.mLocalVideoView));
        this.mRemoteProxyVideoSink.setTarget((VideoSink)(isSwappedFeeds ? this.mLocalVideoView : this.mRemoteVideoView));
    }

    private _PeerConnectionClient createPeerConnectionClient(Context context, boolean isVideoCall, CallOptions options, List<PeerConnection.IceServer> iceServers, _PeerConnectionClient.PeerConnectionEvents peerConnectionEvents) {
        Logger.d("[PeerConnectionClient] createPeerConnectionClient()");
        boolean videoCallEnabled = isVideoCall;
        int videoWidth = options.mVideoWidth;
        int videoHeight = options.mVideoHeight;
        int videoFps = options.mVideoFps;
        boolean videoMaxBitrate = false;
        String videoCodec = "VP8";
        boolean videoCodecHwAcceleration = true;
        boolean videoFlexFecEnabled = false;
        boolean audioStartBitrate = false;
        String audioCodec = "OPUS";
        boolean noAudioProcessing = false;
        boolean aecDump = false;
        boolean saveInputAudioToFile = false;
        boolean useOpenSLES = false;
        boolean disableBuiltInAEC = false;
        boolean disableBuiltInAGC = false;
        boolean disableBuiltInNS = false;
        boolean disableWebRtcAGCAndHPF = false;
        _PeerConnectionClient.DataChannelParameters dataChannelParameters = null;
        boolean loopback = false;
        boolean tracing = false;
        boolean enableRtcEventLog = false;
        _PeerConnectionClient.PeerConnectionParameters mPeerConnectionParameters = new _PeerConnectionClient.PeerConnectionParameters(videoCallEnabled, false, false, videoWidth, videoHeight, videoFps, 0, "VP8", true, false, 0, "OPUS", false, false, false, false, false, false, false, false, false, dataChannelParameters);
        this.mPeerConnectionClient = new _PeerConnectionClient(context, this.mEglBase, mPeerConnectionParameters, peerConnectionEvents);
        VideoCapturer videoCapturer = null;
        if (videoCallEnabled) {
            videoCapturer = this.createVideoCapturer(context, options.mFrontCamera, null);
        }
        this.mPeerConnectionClient.createPeerConnectionFactory(new PeerConnectionFactory.Options());
        this.mPeerConnectionClient.createPeerConnection((VideoSink)this.mLocalProxyVideoSink, this.mRemoteSinks, videoCapturer, iceServers);
        return this.mPeerConnectionClient;
    }

    void setConfiguration(@Nullable List<PeerConnection.IceServer> iceServers) {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.setConfiguration(iceServers);
        }
    }

    @TargetApi(value=21)
    private VideoCapturer createScreenCapturer(Intent screenCaptureIntent) {
        return new ScreenCapturerAndroid(screenCaptureIntent, new MediaProjection.Callback(){

            public void onStop() {
                Logger.d("[PeerConnectionClient] User revoked permission to capture the screen.");
            }
        });
    }

    private VideoCapturer createVideoCapturer(Context context, boolean useFrontCamera, File videoFileAsCamera) {
        FileVideoCapturer videoCapturer;
        if (videoFileAsCamera != null) {
            try {
                videoCapturer = new FileVideoCapturer(videoFileAsCamera.getPath());
            }
            catch (IOException e) {
                return null;
            }
        } else {
            videoCapturer = Camera2Enumerator.isSupported((Context)context) ? this.createCameraCapturer((CameraEnumerator)new Camera2Enumerator(context), useFrontCamera) : this.createCameraCapturer((CameraEnumerator)new Camera1Enumerator(true), useFrontCamera);
        }
        return videoCapturer;
    }

    private VideoCapturer createCameraCapturer(CameraEnumerator enumerator, boolean useFrontCamera) {
        String[] deviceNames = enumerator.getDeviceNames();
        if (useFrontCamera) {
            CameraVideoCapturer videoCapturer;
            for (String deviceName : deviceNames) {
                if (!enumerator.isFrontFacing(deviceName) || (videoCapturer = enumerator.createCapturer(deviceName, null)) == null) continue;
                return videoCapturer;
            }
            for (String deviceName : deviceNames) {
                if (enumerator.isFrontFacing(deviceName) || (videoCapturer = enumerator.createCapturer(deviceName, null)) == null) continue;
                return videoCapturer;
            }
        } else {
            CameraVideoCapturer videoCapturer;
            for (String deviceName : deviceNames) {
                if (!enumerator.isBackFacing(deviceName) || (videoCapturer = enumerator.createCapturer(deviceName, null)) == null) continue;
                return videoCapturer;
            }
            for (String deviceName : deviceNames) {
                if (enumerator.isBackFacing(deviceName) || (videoCapturer = enumerator.createCapturer(deviceName, null)) == null) continue;
                return videoCapturer;
            }
        }
        return null;
    }

    private void setStartOptions(CallOptions callOptions) {
        this.setVideoEnabled(callOptions.mVideoEnabled);
        this.setAudioEnabled(callOptions.mAudioEnabled);
    }

    void startAudioManager(Context context, boolean isVideoCall, _AppRTCAudioManager.AudioManagerEvents audioManagerEvents) {
        SendBirdCall.runOnUIThread(() -> {
            Logger.d("[PeerConnectionClient] startAudioManager()");
            this.mAudioManager = _AppRTCAudioManager.create(context, isVideoCall);
            this.mAudioManager.start(audioManagerEvents);
        });
    }

    AudioDevice getCurrentAudioDevice() {
        AudioDevice audioDevice = null;
        if (this.mAudioManager != null) {
            audioDevice = this.mAudioManager.getSelectedAudioDevice();
        }
        return audioDevice;
    }

    Set<AudioDevice> getAvailableAudioDevices() {
        Set<AudioDevice> audioDevices = new HashSet<AudioDevice>();
        if (this.mAudioManager != null) {
            audioDevices = this.mAudioManager.getAudioDevices();
        }
        return audioDevices;
    }

    boolean selectAudioDevice(AudioDevice audioDevice) {
        boolean result = false;
        if (this.mAudioManager != null) {
            if (audioDevice == AudioDevice.SPEAKERPHONE) {
                this.mAudioManager.setDefaultAudioDeviceWithoutUpdate(AudioDevice.SPEAKERPHONE);
            } else {
                this.mAudioManager.setDefaultAudioDeviceWithoutUpdate(AudioDevice.EARPIECE);
            }
            result = this.mAudioManager.selectAudioDevice(audioDevice);
        }
        return result;
    }

    void enableStatsEvents() {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.enableStatsEvents(true, 3000);
        }
    }

    void createOffer() {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.createOffer();
        }
    }

    void createAnswer() {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.createAnswer();
        }
    }

    void setRemoteDescription(SessionDescription sessionDescription) {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.setRemoteDescription(sessionDescription);
        }
    }

    void addRemoteIceCandidate(IceCandidate iceCandidate) {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.addRemoteIceCandidate(iceCandidate);
        }
    }

    void removeRemoteIceCandidates(IceCandidate[] iceCandidates) {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.removeRemoteIceCandidates(iceCandidates);
        }
    }

    void setVideoEnabled(boolean isEnabled) {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.setVideoEnabled(isEnabled);
        }
    }

    void setAudioEnabled(boolean isEnabled) {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.setAudioEnabled(isEnabled);
        }
    }

    void switchCamera(CompletionHandler handler) {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.switchCamera(e -> {
                if (handler != null) {
                    SendBirdCall.runOnThreadOption(() -> handler.onResult(e));
                }
            });
        }
    }

    void toggleSwappedFeeds() {
        this.setSwappedFeeds(!this.mIsSwappedFeeds);
    }

    void setLocalVideoView(SendBirdVideoView videoView) {
        if (videoView == this.mLocalVideoView) {
            return;
        }
        if (videoView == null) {
            if (this.mLocalProxyVideoSink != null) {
                this.mLocalProxyVideoSink.setTarget(null);
            }
            this.mLocalVideoView.release();
            this.mLocalVideoView = null;
            return;
        }
        if (videoView == this.mRemoteVideoView) {
            this.mLocalVideoView = videoView;
            this.mRemoteVideoView = null;
            this.mRemoteProxyVideoSink.setTarget(null);
        } else {
            if (this.mLocalProxyVideoSink != null) {
                this.mLocalProxyVideoSink.setTarget(null);
            }
            videoView.release();
            if (this.mLocalVideoView != null) {
                this.mLocalVideoView.release();
            }
            this.mLocalVideoView = videoView;
            this.mLocalVideoView.init(this.mEglBase.getEglBaseContext(), null);
        }
        this.mLocalVideoView.setMirror(true);
        this.mLocalProxyVideoSink.setTarget((VideoSink)this.mLocalVideoView);
    }

    void setRemoteVideoView(SendBirdVideoView videoView) {
        if (videoView == this.mRemoteVideoView) {
            return;
        }
        if (videoView == null) {
            if (this.mRemoteProxyVideoSink != null) {
                this.mRemoteProxyVideoSink.setTarget(null);
            }
            this.mRemoteVideoView.release();
            this.mRemoteVideoView = null;
            return;
        }
        if (videoView == this.mLocalVideoView) {
            this.mRemoteVideoView = videoView;
            this.mLocalVideoView = null;
            this.mLocalProxyVideoSink.setTarget(null);
        } else {
            if (this.mRemoteProxyVideoSink != null) {
                this.mRemoteProxyVideoSink.setTarget(null);
            }
            videoView.release();
            if (this.mRemoteVideoView != null) {
                this.mRemoteVideoView.release();
            }
            this.mRemoteVideoView = videoView;
            this.mRemoteVideoView.init(this.mEglBase.getEglBaseContext(), null);
        }
        this.mRemoteVideoView.setMirror(false);
        this.mRemoteProxyVideoSink.setTarget((VideoSink)this.mRemoteVideoView);
    }

    void close() {
        this.mIsSwappedFeeds = false;
        if (this.mLocalProxyVideoSink != null) {
            this.mLocalProxyVideoSink.setTarget(null);
        }
        if (this.mRemoteProxyVideoSink != null) {
            this.mRemoteProxyVideoSink.setTarget(null);
        }
        if (this.mLocalVideoView != null) {
            this.mLocalVideoView.release();
            this.mLocalVideoView = null;
        }
        if (this.mRemoteVideoView != null) {
            this.mRemoteVideoView.release();
            this.mRemoteVideoView = null;
        }
        if (this.mRemoteVideoFileRenderer != null) {
            this.mRemoteVideoFileRenderer.release();
            this.mRemoteVideoFileRenderer = null;
        }
        if (this.mAudioManager != null) {
            SendBirdCall.runOnUIThread(() -> {
                this.mAudioManager.stop();
                this.mAudioManager = null;
            });
        }
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.close();
        }
    }

    private static class ProxyVideoSink
    implements VideoSink {
        private VideoSink mTarget;

        private ProxyVideoSink() {
        }

        public synchronized void onFrame(VideoFrame frame) {
            if (this.mTarget == null) {
                return;
            }
            this.mTarget.onFrame(frame);
        }

        synchronized void setTarget(VideoSink target) {
            this.mTarget = target;
        }
    }
}

