/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import android.content.Context;
import com.sendbird.call.Logger;
import com.sendbird.call.PrefManager;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

class EventDeDuplicator {
    static final int MAX_MESSAGE_ID_SIZE = 100;
    private Context mContext;
    private Set<String> mMessageIds;

    EventDeDuplicator(Context context) {
        if (context != null) {
            this.mContext = context;
            Set<String> messageIds = PrefManager.getInstance(context).getMessageIds();
            this.mMessageIds = messageIds != null ? Collections.synchronizedSet(new LinkedHashSet<String>(messageIds)) : Collections.synchronizedSet(new LinkedHashSet());
        } else {
            this.mMessageIds = Collections.synchronizedSet(new LinkedHashSet());
        }
    }

    synchronized boolean isProcessed(String messageId) {
        Logger.d("[EventDeDuplicator] [Start] isProcessed() => mMessageIds(size: " + this.mMessageIds.size() + ")");
        boolean isProcessed = true;
        if (this.mMessageIds.contains(messageId)) {
            this.mMessageIds.remove(messageId);
            Logger.d("[EventDeDuplicator] isProcessed() => RemovedMessageId: " + messageId);
        } else {
            String firstMessageId;
            if (this.mMessageIds.size() >= 100 && this.mMessageIds.remove(firstMessageId = this.mMessageIds.iterator().next())) {
                Logger.d("[EventDeDuplicator] isProcessed() => RemovedFirstMessageId: " + firstMessageId);
            }
            this.mMessageIds.add(messageId);
            Logger.d("[EventDeDuplicator] isProcessed() => AddedMessageId: " + messageId);
            isProcessed = false;
        }
        if (this.mContext != null) {
            PrefManager.getInstance(this.mContext).setMessageIds(this.mMessageIds);
        }
        Logger.d("[EventDeDuplicator] isProcessed() => " + isProcessed);
        Logger.d("[EventDeDuplicator] [End] isProcessed() => mMessageIds(size: " + this.mMessageIds.size() + ")");
        return isProcessed;
    }

    int getMessageIdsSize() {
        return this.mMessageIds.size();
    }
}

