/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import android.support.annotation.NonNull;
import com.sendbird.call.AcceptParams;
import com.sendbird.call.DirectCall;
import com.sendbird.call.DirectCallAcceptingState;
import com.sendbird.call.DirectCallClosingState;
import com.sendbird.call.DirectCallState;
import com.sendbird.call.TurnCredential;

class DirectCallRingingState
extends DirectCallState {
    private TurnCredential mTurnCredential;

    DirectCallRingingState(TurnCredential turnCredential) {
        this.mTurnCredential = turnCredential;
    }

    @Override
    @NonNull
    String getStateName() {
        return DirectCallRingingState.class.getSimpleName();
    }

    @Override
    void onCreate(DirectCall call) {
        call.startStateTimer(this.getTimerDelay());
        call.startAliveTimer();
        call.dispatchEvent(DirectCall.DirectCallEventType.RINGING);
    }

    @Override
    void onDestroy(DirectCall call) {
        call.stopStateTimer();
    }

    @Override
    void accept(DirectCall call, AcceptParams params) {
        super.accept(call, params);
        call.sendAcceptRequest(params);
        call.changeState(new DirectCallAcceptingState(this.mTurnCredential));
    }

    @Override
    void end(DirectCall call) {
        super.end(call);
        call.sendDeclineRequest();
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void unknownEnd(DirectCall call) {
        super.unknownEnd(call);
        call.sendUnknownEndRequest();
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void timeout(DirectCall call) {
        super.timeout(call);
        call.sendNoAnswerRequest();
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onNoAnswerReceived(DirectCall call) {
        super.onNoAnswerReceived(call);
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onCancelReceived(DirectCall call) {
        super.onCancelReceived(call);
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onDeclineReceived(DirectCall call) {
        super.onDeclineReceived(call);
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onOtherDeviceAccepted(DirectCall call) {
        super.onOtherDeviceAccepted(call);
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onTimeoutReceived(DirectCall call) {
        super.onTimeoutReceived(call);
        call.changeState(new DirectCallClosingState());
    }
}

