/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import android.support.annotation.NonNull;
import com.sendbird.call.DirectCall;
import com.sendbird.call.DirectCallAbortedState;
import com.sendbird.call.DirectCallDialingState;
import com.sendbird.call.DirectCallEndedState;
import com.sendbird.call.DirectCallState;
import com.sendbird.call.SendBirdException;
import com.sendbird.call.handler.DialHandler;

class DirectCallIdleState
extends DirectCallState {
    private String mCalleeId;
    private DialHandler mDialHandler;

    DirectCallIdleState(String calleeId, DialHandler dialHandler) {
        this.mCalleeId = calleeId;
        this.mDialHandler = dialHandler;
    }

    @Override
    @NonNull
    String getStateName() {
        return DirectCallIdleState.class.getSimpleName();
    }

    @Override
    void onCreate(DirectCall call) {
        call.createPeerConnectionClient(null);
        call.sendDialRequest(this.mCalleeId);
    }

    @Override
    void onDestroy(DirectCall call) {
    }

    @Override
    void onDialAckReceived(DirectCall call, SendBirdException e) {
        super.onDialAckReceived(call, e);
        call.startAudioManager();
        if (e != null) {
            call.changeState(new DirectCallEndedState());
        } else {
            call.changeState(new DirectCallDialingState());
        }
        if (this.mDialHandler != null) {
            this.mDialHandler.onResult(e == null ? call : null, e);
        }
    }

    @Override
    void end(DirectCall call) {
        super.end(call);
        call.abort();
        call.changeState(new DirectCallAbortedState(this.mDialHandler));
    }
}

