/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import android.support.annotation.NonNull;
import com.sendbird.call.DirectCall;
import com.sendbird.call.DirectCallClosingState;
import com.sendbird.call.DirectCallConnectedState;
import com.sendbird.call.DirectCallState;
import com.sendbird.call.Logger;
import com.sendbird.call.TimeoutRequest;
import org.webrtc.SessionDescription;

class DirectCallAnsweringState
extends DirectCallState {
    private String mSdp;
    private boolean mIsOfferReceived;

    DirectCallAnsweringState(String sdp) {
        this.mSdp = sdp;
        this.mIsOfferReceived = sdp != null;
    }

    @Override
    @NonNull
    String getStateName() {
        return DirectCallAnsweringState.class.getSimpleName();
    }

    @Override
    void onCreate(DirectCall call) {
        Logger.e("onCreate sdp == null ? " + (this.mSdp == null));
        call.startStateTimer(this.getTimerDelay());
        call.dispatchEvent(DirectCall.DirectCallEventType.ESTABLISHED);
        if (this.mSdp != null) {
            this.handleReceivedOffer(call, this.mSdp);
        }
    }

    @Override
    void onDestroy(DirectCall call) {
        call.stopStateTimer();
    }

    @Override
    void onOfferReceived(DirectCall call, String sdp) {
        super.onOfferReceived(call, sdp);
        this.handleReceivedOffer(call, sdp);
    }

    @Override
    void onIceConnected(DirectCall call) {
        super.onIceConnected(call);
        call.changeState(new DirectCallConnectedState(false));
    }

    @Override
    void end(DirectCall call) {
        super.end(call);
        call.sendEndRequest();
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void unknownEnd(DirectCall call) {
        super.unknownEnd(call);
        call.sendUnknownEndRequest();
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void timeout(DirectCall call) {
        super.timeout(call);
        if (this.mIsOfferReceived) {
            call.sendTimeoutRequest(TimeoutRequest.Reason.WEBRTC_NOT_CONNECTED);
        } else {
            call.sendTimeoutRequest(TimeoutRequest.Reason.OFFER_NOT_RECEIVED);
        }
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onEndReceived(DirectCall call) {
        super.onEndReceived(call);
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onCancelReceived(DirectCall call) {
        super.onCancelReceived(call);
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onTimeoutReceived(DirectCall call) {
        super.onTimeoutReceived(call);
        call.changeState(new DirectCallClosingState());
    }

    private void handleReceivedOffer(DirectCall call, String sdp) {
        this.mIsOfferReceived = true;
        call.updateStartTimestamp();
        call.setRemoteDescription(SessionDescription.Type.OFFER, sdp);
        call.createAnswer();
    }
}

