/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import android.os.Build;
import android.text.TextUtils;
import android.util.Log;
import com.sendbird.call.ApiRequest;
import com.sendbird.call.ApiResponse;
import com.sendbird.call.Client;
import com.sendbird.call.Command;
import com.sendbird.call.CommandFactory;
import com.sendbird.call.Logger;
import com.sendbird.call.ResponseHandler;
import com.sendbird.call.SendBirdCall;
import com.sendbird.call.SendBirdException;
import com.sendbird.call.shadow.com.google.gson.Gson;
import com.sendbird.call.shadow.com.google.gson.annotations.SerializedName;
import com.sendbird.call.shadow.okhttp3.Call;
import com.sendbird.call.shadow.okhttp3.Callback;
import com.sendbird.call.shadow.okhttp3.MediaType;
import com.sendbird.call.shadow.okhttp3.OkHttpClient;
import com.sendbird.call.shadow.okhttp3.Request;
import com.sendbird.call.shadow.okhttp3.RequestBody;
import com.sendbird.call.shadow.okhttp3.Response;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

class ApiClient
implements Client {
    private static final Gson sGson = new Gson();
    private String mBaseUrl;
    private String mSessionToken;
    private String mClientId;
    private OkHttpClient mOkHttpClient = new OkHttpClient();
    private static final MediaType MIME_JSON = MediaType.parse((String)"application/json; charset=utf-8");

    ApiClient(String baseUrl, String clientId) {
        this.mBaseUrl = baseUrl;
        this.mClientId = clientId;
    }

    private String getOSVersion() {
        return String.valueOf(Build.VERSION.SDK_INT);
    }

    @Override
    public void send(Command command, ResponseHandler handler) {
        ApiRequest apiRequest = (ApiRequest)command;
        if (apiRequest.getMethod() == null || apiRequest.getUrl() == null) {
            Logger.e("[APIClient] getMethod() or geUrl() is null.");
            if (handler != null) {
                String invalidParameter = apiRequest.getMethod() == null ? "HTTP Method" : "HTTP URL";
                handler.onResponse(null, SendBirdException.getSendBirdException(invalidParameter));
            }
            return;
        }
        Request.Builder requestBuilder = new Request.Builder().header("Content-Type", "application/json").header("Connection", "Keep-Alive").header("User-Agent", "v2oip-android/" + SendBirdCall.getSdkVersion()).header("SendBird", "android," + this.getOSVersion() + "," + SendBirdCall.getSdkVersion()).header("SBCall-Client-Id", this.mClientId);
        if (!TextUtils.isEmpty((CharSequence)this.mSessionToken)) {
            requestBuilder.header("SBCall-Session-Token", this.mSessionToken);
        } else if (apiRequest.isSessionTokenNeeded()) {
            Logger.e("[APIClient] mSessionToken is null.");
            if (handler != null) {
                handler.onResponse(null, SendBirdException.getSendBirdException(1800303));
            }
            return;
        }
        if (apiRequest.isInternalApi()) {
            requestBuilder.addHeader("internal-key", "fd267a0ec7a5a57a4477217970644e548308cb22");
        }
        Logger.d("[APIClient] API request: " + apiRequest.getMethod() + " " + apiRequest.getUrl() + (apiRequest.getMethod() == ApiRequest.HttpRequestMethod.GET ? "?" : " ") + apiRequest.getPayload());
        switch (apiRequest.getMethod()) {
            case GET: {
                requestBuilder.get();
                requestBuilder.url(this.mBaseUrl + apiRequest.getUrl() + "?" + apiRequest.getPayload());
                break;
            }
            case POST: {
                requestBuilder.post(RequestBody.create((MediaType)MIME_JSON, (String)apiRequest.getPayload()));
                requestBuilder.url(this.mBaseUrl + apiRequest.getUrl());
                break;
            }
            case PUT: {
                requestBuilder.put(RequestBody.create((MediaType)MIME_JSON, (String)apiRequest.getPayload()));
                requestBuilder.url(this.mBaseUrl + apiRequest.getUrl());
                break;
            }
            case DELETE: {
                requestBuilder.delete(RequestBody.create((MediaType)MIME_JSON, (String)apiRequest.getPayload()));
                requestBuilder.url(this.mBaseUrl + apiRequest.getUrl());
            }
        }
        this.newCall(requestBuilder.build(), (body, e) -> {
            if (handler == null) {
                return;
            }
            if (e == null) {
                Command response = CommandFactory.parseApiCommand((com.sendbird.call.Request)apiRequest, (String)body);
                if (response == null) {
                    Logger.e("[APIClient] Failed to parse response into Command");
                    handler.onResponse(null, SendBirdException.getSendBirdExceptionWithMessage(1800205, "Failed to parse response"));
                } else if (response instanceof ApiResponse) {
                    handler.onResponse(response, null);
                } else {
                    handler.onResponse(response, SendBirdException.getSendBirdExceptionWithMessage(1800205, "Parsed command " + response.getClass().getSimpleName() + " is not a ApiResponse."));
                }
            } else {
                handler.onResponse(null, e);
            }
        });
    }

    @Override
    public void setSessionToken(String sessionToken) {
        if (TextUtils.isEmpty((CharSequence)sessionToken)) {
            return;
        }
        this.mSessionToken = sessionToken;
    }

    void evictAllConnections() {
        Logger.d("[APIClient] evictAllConnections()");
        new Thread(() -> this.mOkHttpClient.connectionPool().evictAll()).start();
    }

    void cancelAllRequests() {
        Logger.d("[APIClient] cancelAllRequests()");
        this.mOkHttpClient.dispatcher().cancelAll();
    }

    private void newCall(final Request request, final APIResponseHandler handler) {
        this.mOkHttpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                Logger.e("[APIClient] onFailure(). request = " + request.toString() + " isCanceled = " + call.isCanceled() + ", " + Log.getStackTraceString((Throwable)e));
                if (handler != null && !call.isCanceled()) {
                    handler.onResponse(null, SendBirdException.getSendBirdExceptionWithMessage(1800200, e.getMessage()));
                }
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) {
                block3: {
                    try {
                        String body = ApiClient.this.parseResponse(response);
                        if (handler != null) {
                            handler.onResponse(body, null);
                        }
                    }
                    catch (SendBirdException e) {
                        if (handler == null) break block3;
                        handler.onResponse(null, e);
                    }
                }
            }
        });
    }

    private String parseResponse(Response response) throws SendBirdException {
        if (response.body() == null) {
            Logger.e("[APIClient] Response's body is null.");
            throw SendBirdException.getSendBirdExceptionWithMessage(1800200, "Response is null");
        }
        try {
            String body = response.body().string();
            Logger.d("[APIClient] API response: " + response.code() + " " + body);
            if (!response.isSuccessful()) {
                ErrorMessage errorMessage = (ErrorMessage)sGson.fromJson(body, ErrorMessage.class);
                throw SendBirdException.getSendBirdExceptionWithMessage(1800200, "[" + errorMessage.getCode() + "] " + errorMessage.getMessage());
            }
            return body;
        }
        catch (IOException e) {
            Logger.e("[APIClient] Failed to get Response's body. " + e.getMessage());
            throw SendBirdException.getSendBirdExceptionWithMessage(1800200, e.getMessage());
        }
    }

    private static class ErrorMessage {
        @SerializedName(value="message")
        private String mMessage;
        @SerializedName(value="code")
        private int mCode;

        private ErrorMessage() {
        }

        String getMessage() {
            return this.mMessage;
        }

        int getCode() {
            return this.mCode;
        }
    }

    private static interface APIResponseHandler {
        public void onResponse(String var1, SendBirdException var2);
    }
}

