/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import com.sendbird.call.ApiRequest;
import com.sendbird.call.CommandFactory;
import com.sendbird.call.WebSocketRequest;
import com.sendbird.call.shadow.com.google.gson.JsonObject;

abstract class CallRequest
extends WebSocketRequest
implements ApiRequest {
    private static final int VERSION = 1;
    private String mCommand;
    private String mType;

    CallRequest(String command, String type) {
        this.mCommand = command;
        this.mType = type;
    }

    int getVersion() {
        return 1;
    }

    String getCommand() {
        return this.mCommand;
    }

    String getType() {
        return this.mType;
    }

    abstract JsonObject getDataObject();

    @Override
    public String getUrl() {
        return "/v1/action/direct_call";
    }

    @Override
    public ApiRequest.HttpRequestMethod getMethod() {
        return ApiRequest.HttpRequestMethod.POST;
    }

    @Override
    public boolean isSessionTokenNeeded() {
        return true;
    }

    @Override
    public boolean isInternalApi() {
        return false;
    }

    JsonObject toJson() {
        JsonObject obj = new JsonObject();
        obj.addProperty("version", this.getVersion());
        obj.addProperty("request_id", this.getRequestId());
        obj.addProperty("cmd", this.getCommand());
        obj.addProperty("type", this.getType());
        obj.add("payload", this.getDataObject());
        return obj;
    }

    @Override
    public String getPayload() {
        return CommandFactory.sGson.toJson(this.toJson());
    }
}

