/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import com.sendbird.call.CallRequest;
import com.sendbird.call.Candidate;
import com.sendbird.call.shadow.com.google.gson.JsonArray;
import com.sendbird.call.shadow.com.google.gson.JsonObject;
import java.util.List;

class RemoveCandidatesRequest
extends CallRequest {
    private static final String COMMAND = "SGNL";
    private static final String TYPE = "remove_candidates";
    private String mCallId;
    private List<Candidate> mCandidates;

    RemoveCandidatesRequest(String callId, List<Candidate> candidates) {
        super(COMMAND, TYPE);
        this.mCallId = callId;
        this.mCandidates = candidates;
    }

    @Override
    boolean isAckRequired() {
        return false;
    }

    @Override
    JsonObject getDataObject() {
        JsonObject dataObj = new JsonObject();
        dataObj.addProperty("call_id", this.mCallId);
        JsonArray candidatesArray = new JsonArray();
        for (Candidate candidate : this.mCandidates) {
            candidatesArray.add(candidate.toJson());
        }
        dataObj.add("candidates", candidatesArray);
        return dataObj;
    }
}

