/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import com.sendbird.call.CallRequest;
import com.sendbird.call.shadow.com.google.gson.JsonObject;
import java.util.Map;

class DialRequest
extends CallRequest {
    private static final String COMMAND = "CALL";
    private static final String TYPE = "dial";
    private String mCalleeId;
    private boolean mIsVideoCall;
    private boolean mAudioConstraints;
    private boolean mVideoConstraints;
    private Map<String, String> mCustomItems;

    DialRequest(String calleeId, boolean isVideoCall, boolean audioConstraints, boolean videoConstraints, Map<String, String> customItems) {
        super(COMMAND, TYPE);
        this.mCalleeId = calleeId;
        this.mIsVideoCall = isVideoCall;
        this.mAudioConstraints = audioConstraints;
        this.mVideoConstraints = videoConstraints;
        this.mCustomItems = customItems;
    }

    @Override
    boolean isAckRequired() {
        return true;
    }

    @Override
    JsonObject getDataObject() {
        JsonObject dataObj = new JsonObject();
        dataObj.addProperty("callee_id", this.mCalleeId);
        dataObj.addProperty("is_video_call", this.mIsVideoCall);
        JsonObject constraintsObj = new JsonObject();
        constraintsObj.addProperty("audio", this.mAudioConstraints);
        constraintsObj.addProperty("video", this.mVideoConstraints);
        dataObj.add("constraints", constraintsObj);
        if (this.mCustomItems != null) {
            JsonObject customItemsObj = new JsonObject();
            for (Map.Entry<String, String> entry : this.mCustomItems.entrySet()) {
                customItemsObj.addProperty(entry.getKey(), entry.getValue());
            }
            dataObj.add("custom_items", customItemsObj);
        }
        return dataObj;
    }
}

