/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import com.sendbird.call.ApiRequest;
import com.sendbird.call.CommandFactory;
import com.sendbird.call.shadow.com.google.gson.JsonArray;
import com.sendbird.call.shadow.com.google.gson.JsonObject;
import java.util.Set;

class DeleteCustomItemsRequest
implements ApiRequest {
    private Set<String> mCustomItemKeys;
    private String mCallId;

    public DeleteCustomItemsRequest(String callId, Set<String> customItemKeys) {
        this.mCustomItemKeys = customItemKeys;
        this.mCallId = callId;
    }

    @Override
    public String getUrl() {
        return "/v1/direct_calls/" + this.mCallId + "/custom_items";
    }

    @Override
    public ApiRequest.HttpRequestMethod getMethod() {
        return ApiRequest.HttpRequestMethod.DELETE;
    }

    @Override
    public boolean isSessionTokenNeeded() {
        return true;
    }

    @Override
    public String getPayload() {
        JsonObject obj = new JsonObject();
        if (this.mCustomItemKeys != null && this.mCustomItemKeys.size() > 0) {
            JsonArray customItemsKeysArray = new JsonArray();
            for (String key : this.mCustomItemKeys) {
                customItemsKeysArray.add(key);
            }
            obj.add("keys", customItemsKeysArray);
        }
        return CommandFactory.sGson.toJson(obj);
    }
}

