/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import com.sendbird.call.AcceptPushCommand;
import com.sendbird.call.AcceptResponse;
import com.sendbird.call.AnswerPushCommand;
import com.sendbird.call.AudioStatusPushCommand;
import com.sendbird.call.AuthenticateRequest;
import com.sendbird.call.AuthenticateResponse;
import com.sendbird.call.CancelPushCommand;
import com.sendbird.call.CancelResponse;
import com.sendbird.call.CandidatePushCommand;
import com.sendbird.call.Command;
import com.sendbird.call.ConnectionLostPushCommand;
import com.sendbird.call.ConnectionLostResponse;
import com.sendbird.call.DeclinePushCommand;
import com.sendbird.call.DeclineResponse;
import com.sendbird.call.DeleteCustomItemsPushCommand;
import com.sendbird.call.DeleteCustomItemsRequest;
import com.sendbird.call.DeleteCustomItemsResponse;
import com.sendbird.call.DialPushCommand;
import com.sendbird.call.DialResponse;
import com.sendbird.call.DirectCallLogListRequest;
import com.sendbird.call.DirectCallLogListResponse;
import com.sendbird.call.EndPushCommand;
import com.sendbird.call.EndResponse;
import com.sendbird.call.ErrorResponse;
import com.sendbird.call.NoAnswerPushCommand;
import com.sendbird.call.NoAnswerResponse;
import com.sendbird.call.OfferPushCommand;
import com.sendbird.call.OtherDeviceAcceptedPushCommand;
import com.sendbird.call.RegisterPushTokenRequest;
import com.sendbird.call.RegisterPushTokenResponse;
import com.sendbird.call.RemoveCandidatesPushCommand;
import com.sendbird.call.Request;
import com.sendbird.call.TimeoutPushCommand;
import com.sendbird.call.TimeoutResponse;
import com.sendbird.call.UnknownEndPushCommand;
import com.sendbird.call.UnknownEndResponse;
import com.sendbird.call.UnregisterAllPushTokensRequest;
import com.sendbird.call.UnregisterAllPushTokensResponse;
import com.sendbird.call.UnregisterPushTokenRequest;
import com.sendbird.call.UnregisterPushTokenResponse;
import com.sendbird.call.UpdateCustomItemsPushCommand;
import com.sendbird.call.UpdateCustomItemsRequest;
import com.sendbird.call.UpdateCustomItemsResponse;
import com.sendbird.call.VideoStatusPushCommand;
import com.sendbird.call.shadow.com.google.gson.Gson;
import com.sendbird.call.shadow.com.google.gson.JsonElement;
import com.sendbird.call.shadow.com.google.gson.JsonObject;
import com.sendbird.call.shadow.com.google.gson.JsonParser;

class CommandFactory {
    static final Gson sGson = new Gson();

    CommandFactory() {
    }

    private static JsonObject parseJson(String json) {
        try {
            return JsonParser.parseString(json).getAsJsonObject();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static Command parseApiCommand(Request request, String json) {
        JsonObject jsonObject = CommandFactory.parseJson(json);
        if (jsonObject == null) {
            return null;
        }
        if (jsonObject.has("cmd")) {
            return CommandFactory.parseCallCommand(jsonObject);
        }
        try {
            if (request instanceof AuthenticateRequest) {
                return sGson.fromJson(json, AuthenticateResponse.class);
            }
            if (request instanceof DirectCallLogListRequest) {
                return sGson.fromJson(json, DirectCallLogListResponse.class);
            }
            if (request instanceof RegisterPushTokenRequest) {
                return sGson.fromJson(json, RegisterPushTokenResponse.class);
            }
            if (request instanceof UnregisterPushTokenRequest) {
                return sGson.fromJson(json, UnregisterPushTokenResponse.class);
            }
            if (request instanceof UnregisterAllPushTokensRequest) {
                return sGson.fromJson(json, UnregisterAllPushTokensResponse.class);
            }
            if (request instanceof UpdateCustomItemsRequest) {
                return sGson.fromJson(json, UpdateCustomItemsResponse.class);
            }
            if (request instanceof DeleteCustomItemsRequest) {
                return sGson.fromJson(json, DeleteCustomItemsResponse.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    static Command parseCallCommand(String json) {
        JsonObject jsonObject = CommandFactory.parseJson(json);
        if (jsonObject == null) {
            return null;
        }
        return CommandFactory.parseCallCommand(jsonObject);
    }

    static Command parseCallCommand(JsonObject obj) {
        try {
            boolean isError;
            boolean bl = isError = obj.has("error") && obj.get("error").getAsBoolean();
            if (isError) {
                return sGson.fromJson((JsonElement)obj, ErrorResponse.class);
            }
            String requestId = obj.has("request_id") ? obj.get("request_id").getAsString() : "";
            String command = obj.has("cmd") ? obj.get("cmd").getAsString() : "";
            String type = obj.has("type") ? obj.get("type").getAsString() : "";
            String messageId = obj.has("message_id") ? obj.get("message_id").getAsString() : "";
            JsonObject data = obj.has("payload") ? obj.get("payload").getAsJsonObject() : new JsonObject();
            data.addProperty("request_id", requestId);
            data.addProperty("message_id", messageId);
            if (command.equals("CALL")) {
                switch (type) {
                    case "dial_ack": {
                        return sGson.fromJson((JsonElement)data, DialResponse.class);
                    }
                    case "dial": {
                        return sGson.fromJson((JsonElement)data, DialPushCommand.class);
                    }
                    case "cancel_ack": {
                        return sGson.fromJson((JsonElement)data, CancelResponse.class);
                    }
                    case "cancel": {
                        return sGson.fromJson((JsonElement)data, CancelPushCommand.class);
                    }
                    case "accept_ack": {
                        return sGson.fromJson((JsonElement)data, AcceptResponse.class);
                    }
                    case "accept": {
                        return sGson.fromJson((JsonElement)data, AcceptPushCommand.class);
                    }
                    case "other_device_accepted": {
                        return sGson.fromJson((JsonElement)data, OtherDeviceAcceptedPushCommand.class);
                    }
                    case "decline_ack": {
                        return sGson.fromJson((JsonElement)data, DeclineResponse.class);
                    }
                    case "decline": {
                        return sGson.fromJson((JsonElement)data, DeclinePushCommand.class);
                    }
                    case "end_ack": {
                        return sGson.fromJson((JsonElement)data, EndResponse.class);
                    }
                    case "end": {
                        return sGson.fromJson((JsonElement)data, EndPushCommand.class);
                    }
                    case "no_answer_ack": {
                        return sGson.fromJson((JsonElement)data, NoAnswerResponse.class);
                    }
                    case "no_answer": {
                        return sGson.fromJson((JsonElement)data, NoAnswerPushCommand.class);
                    }
                    case "timeout_ack": {
                        return sGson.fromJson((JsonElement)data, TimeoutResponse.class);
                    }
                    case "timeout": {
                        return sGson.fromJson((JsonElement)data, TimeoutPushCommand.class);
                    }
                    case "connection_lost_ack": {
                        return sGson.fromJson((JsonElement)data, ConnectionLostResponse.class);
                    }
                    case "connection_lost": {
                        return sGson.fromJson((JsonElement)data, ConnectionLostPushCommand.class);
                    }
                    case "unknown_end_ack": {
                        return sGson.fromJson((JsonElement)data, UnknownEndResponse.class);
                    }
                    case "unknown_end": {
                        return sGson.fromJson((JsonElement)data, UnknownEndPushCommand.class);
                    }
                }
            } else if (command.equals("SGNL")) {
                switch (type) {
                    case "offer": {
                        return sGson.fromJson((JsonElement)data, OfferPushCommand.class);
                    }
                    case "answer": {
                        return sGson.fromJson((JsonElement)data, AnswerPushCommand.class);
                    }
                    case "candidate": {
                        return sGson.fromJson((JsonElement)data, CandidatePushCommand.class);
                    }
                    case "remove_candidates": {
                        return sGson.fromJson((JsonElement)data, RemoveCandidatesPushCommand.class);
                    }
                }
            } else if (command.equals("COMM")) {
                switch (type) {
                    case "audio": {
                        return sGson.fromJson((JsonElement)data, AudioStatusPushCommand.class);
                    }
                    case "video": {
                        return sGson.fromJson((JsonElement)data, VideoStatusPushCommand.class);
                    }
                    case "custom_items_update": {
                        return sGson.fromJson((JsonElement)data, UpdateCustomItemsPushCommand.class);
                    }
                    case "custom_items_delete": {
                        return sGson.fromJson((JsonElement)data, DeleteCustomItemsPushCommand.class);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

