/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.sendbird.call.AcceptParams;
import com.sendbird.call.AcceptPushCommand;
import com.sendbird.call.AcceptRequest;
import com.sendbird.call.AliveRequest;
import com.sendbird.call.AnswerPushCommand;
import com.sendbird.call.AnswerRequest;
import com.sendbird.call.AudioDevice;
import com.sendbird.call.AudioStatusPushCommand;
import com.sendbird.call.AudioStatusRequest;
import com.sendbird.call.BaseCall;
import com.sendbird.call.BroadcastListener;
import com.sendbird.call.CallOptions;
import com.sendbird.call.CancelPushCommand;
import com.sendbird.call.CancelRequest;
import com.sendbird.call.CancelResponse;
import com.sendbird.call.Candidate;
import com.sendbird.call.CandidatePushCommand;
import com.sendbird.call.CandidateRequest;
import com.sendbird.call.Command;
import com.sendbird.call.CommandSender;
import com.sendbird.call.ConnectionLostPushCommand;
import com.sendbird.call.ConnectionLostRequest;
import com.sendbird.call.ConnectionLostResponse;
import com.sendbird.call.Constraints;
import com.sendbird.call.DeclinePushCommand;
import com.sendbird.call.DeclineRequest;
import com.sendbird.call.DeclineResponse;
import com.sendbird.call.DeleteCustomItemsPushCommand;
import com.sendbird.call.DeleteCustomItemsRequest;
import com.sendbird.call.DeleteCustomItemsResponse;
import com.sendbird.call.DialParams;
import com.sendbird.call.DialPushCommand;
import com.sendbird.call.DialRequest;
import com.sendbird.call.DialResponse;
import com.sendbird.call.DirectCallCanceledState;
import com.sendbird.call.DirectCallConnectedState;
import com.sendbird.call.DirectCallEndListener;
import com.sendbird.call.DirectCallEndResult;
import com.sendbird.call.DirectCallEndedState;
import com.sendbird.call.DirectCallEndingState;
import com.sendbird.call.DirectCallIdleState;
import com.sendbird.call.DirectCallLog;
import com.sendbird.call.DirectCallRingingState;
import com.sendbird.call.DirectCallState;
import com.sendbird.call.DirectCallUser;
import com.sendbird.call.DirectCallUserRole;
import com.sendbird.call.EndPushCommand;
import com.sendbird.call.EndRequest;
import com.sendbird.call.EndResponse;
import com.sendbird.call.Logger;
import com.sendbird.call.NoAnswerPushCommand;
import com.sendbird.call.NoAnswerRequest;
import com.sendbird.call.NoAnswerResponse;
import com.sendbird.call.OfferPushCommand;
import com.sendbird.call.OfferRequest;
import com.sendbird.call.OtherDeviceAcceptedPushCommand;
import com.sendbird.call.PeerConnectionClient;
import com.sendbird.call.PeerConnectionClientFactory;
import com.sendbird.call.RemoveCandidatesPushCommand;
import com.sendbird.call.RemoveCandidatesRequest;
import com.sendbird.call.RingingListener;
import com.sendbird.call.SendBirdCall;
import com.sendbird.call.SendBirdException;
import com.sendbird.call.StringUtils;
import com.sendbird.call.TimeoutPushCommand;
import com.sendbird.call.TimeoutRequest;
import com.sendbird.call.TimeoutResponse;
import com.sendbird.call.TurnCredential;
import com.sendbird.call.UnknownEndPushCommand;
import com.sendbird.call.UnknownEndRequest;
import com.sendbird.call.UnknownEndResponse;
import com.sendbird.call.UpdateCustomItemsPushCommand;
import com.sendbird.call.UpdateCustomItemsRequest;
import com.sendbird.call.UpdateCustomItemsResponse;
import com.sendbird.call.VideoStatusPushCommand;
import com.sendbird.call._PeerConnectionClient;
import com.sendbird.call.handler.CustomItemsHandler;
import com.sendbird.call.handler.DialHandler;
import com.sendbird.call.handler.DirectCallListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.webrtc.IceCandidate;
import org.webrtc.PeerConnection;
import org.webrtc.SessionDescription;
import org.webrtc.StatsReport;

public class DirectCall
extends BaseCall {
    private static final boolean ENABLE_STATS_EVENTS = true;
    private static final long ALIVE_INTERVAL = 10000L;
    private Context mContext;
    private CommandSender mCommandSender;
    private RingingListener mRingingListener;
    private BroadcastListener mBroadcastListener;
    private DirectCallEndListener mEndListener;
    private CallOptions mCallOptions;
    private boolean mIsVideoCall;
    private boolean mAmICallee;
    private DirectCallUserRole mMyRole;
    private String mCallId;
    private DirectCallUser mCaller;
    private DirectCallUser mCallee;
    private Map<String, String> mCustomItems;
    private long mCustomItemsLastAffectedAt = 0L;
    private TurnCredential mTurnCredential;
    private PeerConnectionClient mPeerConnectionClient;
    private long mStartTimestamp = 0L;
    private long mEndTimestamp = 0L;
    private DirectCallEndResult mEndResult = DirectCallEndResult.NONE;
    private DirectCallUser mEndedBy;
    private long mDuration;
    private DirectCallState mCurrentState;
    private Timer mStateTimer = new Timer();
    private Timer mAliveTimer = new Timer();
    private DirectCallListener mListener;
    private boolean mIsLocalVideoEnabled = true;
    private boolean mIsRemoteVideoEnabled = true;
    private boolean mIsLocalAudioEnabled = true;
    private boolean mIsRemoteAudioEnabled = true;
    private ExecutorService mSingleThreadExecutor = Executors.newSingleThreadExecutor();
    private _PeerConnectionClient.PeerConnectionEvents mPeerConnectionEvents = new _PeerConnectionClient.PeerConnectionEvents(){

        @Override
        public void onLocalDescription(boolean isInitiator, SessionDescription sdp) {
            Logger.d(DirectCall.this.tag() + "[PCE] onLocalDescription()");
            if (sdp != null && sdp.description != null) {
                StringUtils.compress(sdp.description, result -> {
                    if (result != null && result.length() > 0) {
                        if (isInitiator) {
                            DirectCall.this.sendOfferRequest(result);
                        } else {
                            DirectCall.this.sendAnswerRequest(result);
                        }
                    }
                });
            }
        }

        @Override
        public void onIceCandidate(IceCandidate candidate) {
            Logger.d(DirectCall.this.tag() + "[PCE] onIceCandidate(" + (candidate != null ? candidate.toString() : null) + ")");
            if (candidate != null && candidate.sdp != null && candidate.sdp.contains("typ relay")) {
                DirectCall.this.sendCandidateRequest(candidate);
            }
        }

        @Override
        public void onIceCandidatesRemoved(IceCandidate[] candidates) {
            Logger.d(DirectCall.this.tag() + "[PCE] onIceCandidatesRemoved(" + (candidates != null ? candidates.length : 0) + ")");
            if (candidates != null) {
                DirectCall.this.sendRemoveCandidatesRequest(candidates);
            }
        }

        @Override
        public void onIceConnected() {
            Logger.d(DirectCall.this.tag() + "[PCE] onIceConnected()");
            DirectCall.this.runOnSingleThreadPool(() -> DirectCall.this.mCurrentState.onIceConnected(DirectCall.this));
        }

        @Override
        public void onConnected() {
            Logger.d(DirectCall.this.tag() + "[PCE] onConnected()");
            if (DirectCall.this.mPeerConnectionClient != null) {
                DirectCall.this.mPeerConnectionClient.enableStatsEvents();
            }
        }

        @Override
        public void onIceDisconnected() {
            Logger.d(DirectCall.this.tag() + "[PCE] onIceDisconnected()");
            DirectCall.this.runOnSingleThreadPool(() -> DirectCall.this.mCurrentState.onIceDisconnected(DirectCall.this));
        }

        @Override
        public void onIceFailed() {
            Logger.d(DirectCall.this.tag() + "[PCE] onIceFailed()");
            DirectCall.this.runOnSingleThreadPool(() -> DirectCall.this.mCurrentState.onIceFailed(DirectCall.this));
        }

        @Override
        public void onDisconnected() {
            Logger.d(DirectCall.this.tag() + "[PCE] onDisconnected()");
        }

        @Override
        public void onFailed() {
            Logger.d(DirectCall.this.tag() + "[PCE] onFailed()");
        }

        @Override
        public void onPeerConnectionClosed() {
            Logger.d(DirectCall.this.tag() + "[PCE] onPeerConnectionClosed()");
            DirectCall.this.runOnSingleThreadPool(() -> DirectCall.this.mCurrentState.onClosed(DirectCall.this));
        }

        @Override
        public void onPeerConnectionStatsReady(StatsReport[] reports) {
        }

        @Override
        public void onPeerConnectionError(String description) {
            Logger.e(DirectCall.this.tag() + "[PCE] onPeerConnectionError() => " + description);
            DirectCall.this.runOnSingleThreadPool(() -> DirectCall.this.mCurrentState.unknownEnd(DirectCall.this));
        }

        @Override
        public void onPeerConnectionAudioError(String description) {
            Logger.e(DirectCall.this.tag() + "[PCE] onPeerConnectionAudioError() => " + description);
        }
    };

    DirectCall(Context context, CommandSender sender, @NonNull DialParams params, DialHandler dialHandler, RingingListener ringingListener, BroadcastListener broadcastListener) {
        Logger.d("[DirectCall] DirectCall() as caller");
        this.mContext = context;
        this.mCommandSender = sender;
        this.mRingingListener = ringingListener;
        this.mBroadcastListener = broadcastListener;
        this.mIsVideoCall = params.mIsVideoCall;
        this.mAmICallee = false;
        this.mMyRole = DirectCallUserRole.CALLER;
        this.mCallOptions = params.mCallOptions;
        this.mCustomItems = params.mCustomItems;
        this.mCurrentState = new DirectCallIdleState(params.mCalleeId, dialHandler);
        this.runOnSingleThreadPool(() -> this.mCurrentState.onCreate(this));
    }

    DirectCall(Context context, CommandSender sender, DialPushCommand command, RingingListener ringingListener, BroadcastListener broadcastListener) {
        Logger.d("[DirectCall] DirectCall(command: DialPushCommand) as callee");
        this.mContext = context;
        this.mCommandSender = sender;
        this.mRingingListener = ringingListener;
        this.mBroadcastListener = broadcastListener;
        this.mIsVideoCall = command.isVideoCall();
        this.mAmICallee = true;
        this.mMyRole = DirectCallUserRole.CALLEE;
        this.mCallId = command.getCallId();
        this.mCaller = command.getCaller();
        this.mCallee = command.getCallee();
        this.mCustomItems = command.getCustomItems();
        this.setRemoteConstraints(command.getConstraints());
        this.mTurnCredential = command.getTurnCredential();
        this.mCurrentState = new DirectCallRingingState();
        this.runOnSingleThreadPool(() -> this.mCurrentState.onCreate(this));
    }

    DirectCall(Context context, CommandSender sender, CancelPushCommand command, RingingListener ringingListener, BroadcastListener broadcastListener) {
        Logger.d("[DirectCall] DirectCall(command: CancelPushCommand) as callee");
        this.mContext = context;
        this.mCommandSender = sender;
        this.mRingingListener = ringingListener;
        this.mBroadcastListener = broadcastListener;
        this.mIsVideoCall = command.getEndedCallLog().isVideoCall();
        this.mAmICallee = true;
        this.mMyRole = DirectCallUserRole.CALLEE;
        this.mCallId = command.getCallId();
        this.mCaller = command.getEndedCallLog().getCaller();
        this.mCallee = command.getEndedCallLog().getCallee();
        this.setEndedCall(DirectCallEndResult.CANCELED, command.getEndedCallLog());
        this.mCurrentState = new DirectCallCanceledState();
        this.runOnSingleThreadPool(() -> this.mCurrentState.onCreate(this));
    }

    public String getCallId() {
        return this.mCallId;
    }

    public boolean isVideoCall() {
        return this.mIsVideoCall;
    }

    public DirectCallUser getCaller() {
        return this.mCaller;
    }

    public DirectCallUser getCallee() {
        return this.mCallee;
    }

    public DirectCallUser getLocalUser() {
        if (this.mAmICallee) {
            return this.mCallee;
        }
        return this.mCaller;
    }

    public DirectCallUser getRemoteUser() {
        if (this.mAmICallee) {
            return this.mCaller;
        }
        return this.mCallee;
    }

    public DirectCallUserRole getMyRole() {
        return this.mMyRole;
    }

    public DirectCallUser getEndedBy() {
        return this.mEndedBy;
    }

    public DirectCallEndResult getEndResult() {
        return this.mEndResult;
    }

    public long getDuration() {
        long duration = this.mDuration;
        if (duration == 0L && this.mStartTimestamp > 0L) {
            duration = Math.max(System.currentTimeMillis() - this.mStartTimestamp, 0L);
        }
        return duration;
    }

    public void setListener(DirectCallListener listener) {
        Logger.d(this.tag() + "setListener()");
        this.mListener = listener;
    }

    public void accept(CallOptions callOptions) {
        this.accept(new AcceptParams().setCallOptions(callOptions));
    }

    public void accept(AcceptParams params) {
        Logger.d(this.tag() + "accept()");
        if (params == null) {
            params = new AcceptParams();
        }
        if (params.mCallOptions == null) {
            params.mCallOptions = new CallOptions();
        }
        AcceptParams finalParams = params;
        this.runOnSingleThreadPool(() -> this.mCurrentState.accept(this, finalParams));
    }

    public void end() {
        Logger.d(this.tag() + "end()");
        this.runOnSingleThreadPool(() -> this.mCurrentState.end(this));
    }

    public boolean isEnded() {
        boolean isEnded = false;
        if (this.mCurrentState instanceof DirectCallEndingState || this.mCurrentState instanceof DirectCallEndedState) {
            isEnded = true;
        }
        return isEnded;
    }

    public boolean isLocalAudioEnabled() {
        return this.mIsLocalAudioEnabled;
    }

    public boolean isRemoteAudioEnabled() {
        return this.mIsRemoteAudioEnabled;
    }

    public void muteMicrophone() {
        Logger.d(this.tag() + "muteMicrophone()");
        if (this.mPeerConnectionClient != null && this.isWebRtcConnected()) {
            this.mPeerConnectionClient.setAudioEnabled(false);
            this.setLocalAudioEnabled(false);
            AudioStatusRequest request = new AudioStatusRequest(this.mCallId, false);
            this.mCommandSender.send((Command)request, null);
        }
    }

    public void unmuteMicrophone() {
        Logger.d(this.tag() + "unmuteMicrophone()");
        if (this.mPeerConnectionClient != null && this.isWebRtcConnected()) {
            this.mPeerConnectionClient.setAudioEnabled(true);
            this.setLocalAudioEnabled(true);
            AudioStatusRequest request = new AudioStatusRequest(this.mCallId, true);
            this.mCommandSender.send((Command)request, null);
        }
    }

    public AudioDevice getCurrentAudioDevice() {
        AudioDevice audioDevice = null;
        if (this.mPeerConnectionClient != null) {
            audioDevice = this.mPeerConnectionClient.getCurrentAudioDevice();
        }
        Logger.d(this.tag() + "getCurrentAudioDevice() => " + (Object)((Object)audioDevice));
        return audioDevice;
    }

    public Set<AudioDevice> getAvailableAudioDevices() {
        HashSet<AudioDevice> audioDevices = new HashSet();
        if (this.mPeerConnectionClient != null) {
            audioDevices = this.mPeerConnectionClient.getAvailableAudioDevices();
        }
        Logger.d(this.tag() + "getAvailableAudioDevices() => " + audioDevices);
        return audioDevices;
    }

    public boolean selectAudioDevice(AudioDevice audioDevice) {
        boolean result = false;
        if (this.mPeerConnectionClient != null) {
            result = this.mPeerConnectionClient.selectAudioDevice(audioDevice);
        }
        Logger.d(this.tag() + "selectAudioDevice(audioDevice: " + (Object)((Object)audioDevice) + ") => " + result);
        return result;
    }

    public Map<String, String> getCustomItems() {
        if (this.mCustomItems == null) {
            return new HashMap<String, String>();
        }
        return new HashMap<String, String>(this.mCustomItems);
    }

    public void updateCustomItems(Map<String, String> customItems, CustomItemsHandler handler) {
        if (customItems == null) {
            SendBirdCall.runOnThreadOption(() -> {
                if (handler != null) {
                    handler.onResult(null, null, SendBirdException.getSendBirdException("customItems"));
                }
            });
            return;
        }
        UpdateCustomItemsRequest request = new UpdateCustomItemsRequest(this.mCallId, customItems);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (response instanceof UpdateCustomItemsResponse) {
                Map result = ((UpdateCustomItemsResponse)response).getCustomItems();
                List affectedKeys = ((UpdateCustomItemsResponse)response).getUpdatedKeys();
                long affectedAt = ((UpdateCustomItemsResponse)response).getAffectedAt();
                if (e == null && result != null) {
                    this.setCustomItems(result, affectedAt);
                }
                SendBirdCall.runOnThreadOption(() -> {
                    if (handler != null) {
                        handler.onResult(result, affectedKeys, e);
                    }
                });
            } else {
                SendBirdCall.runOnThreadOption(() -> {
                    if (handler != null) {
                        handler.onResult(null, null, SendBirdException.getSendBirdException(1800208));
                    }
                });
            }
        });
    }

    public void deleteCustomItems(Set<String> customItemKeys, CustomItemsHandler handler) {
        DeleteCustomItemsRequest request = new DeleteCustomItemsRequest(this.mCallId, customItemKeys);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (response instanceof DeleteCustomItemsResponse) {
                Map result = ((DeleteCustomItemsResponse)response).getCustomItems();
                List affectedKeys = ((DeleteCustomItemsResponse)response).getDeletedKeys();
                long affectedAt = ((DeleteCustomItemsResponse)response).getAffectedAt();
                if (e == null && result != null) {
                    this.setCustomItems(result, affectedAt);
                }
                SendBirdCall.runOnThreadOption(() -> {
                    if (handler != null) {
                        handler.onResult(result, affectedKeys, null);
                    }
                });
            } else {
                SendBirdCall.runOnThreadOption(() -> {
                    if (handler != null) {
                        handler.onResult(null, null, SendBirdException.getSendBirdException(1800208));
                    }
                });
            }
        });
    }

    public void deleteAllCustomItems(CustomItemsHandler handler) {
        this.deleteCustomItems(null, handler);
    }

    void changeState(@NonNull DirectCallState nextState) {
        Logger.d(this.tag() + "changeState(). " + this.mCurrentState.getStateName() + " => " + nextState.getStateName());
        if (this.mCurrentState.getStateName().equals(nextState.getStateName())) {
            return;
        }
        this.mCurrentState.onDestroy(this);
        this.mCurrentState = nextState;
        this.mCurrentState.onCreate(this);
    }

    void updateStartTimestamp() {
        Logger.d(this.tag() + "updateStartTimestamp()");
        this.mStartTimestamp = System.currentTimeMillis();
    }

    void updateEndTimestamp() {
        this.mEndTimestamp = System.currentTimeMillis();
        if (this.mStartTimestamp > 0L) {
            this.mDuration = Math.max(this.mEndTimestamp - this.mStartTimestamp, 0L);
        }
        Logger.d(this.tag() + "updateEndTimestamp() => mDuration: " + this.mDuration);
    }

    void startStateTimer(long delayMillis) {
        Logger.d(this.tag() + "[" + this.mCurrentState.getStateName() + "] => startStateTimer(" + delayMillis + ")");
        this.mStateTimer = new Timer();
        this.mStateTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                DirectCall.this.runOnSingleThreadPool(() -> DirectCall.this.mCurrentState.timeout(DirectCall.this));
            }
        }, delayMillis);
    }

    void stopStateTimer() {
        Logger.d(this.tag() + "[" + this.mCurrentState.getStateName() + "] => stopStateTimer()");
        this.mStateTimer.cancel();
    }

    void startAliveTimer() {
        Logger.d(this.tag() + "[" + this.mCurrentState.getStateName() + "] => startAliveTimer(" + 10000L + ")");
        this.mAliveTimer = new Timer();
        this.mAliveTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!TextUtils.isEmpty((CharSequence)DirectCall.this.mCallId)) {
                    AliveRequest aliveRequest = new AliveRequest(DirectCall.this.mCallId);
                    DirectCall.this.mCommandSender.send((Command)aliveRequest, null);
                }
            }
        }, 0L, 10000L);
    }

    void stopAliveTimer() {
        Logger.d(this.tag() + "[" + this.mCurrentState.getStateName() + "] => stopAliveTimer()");
        this.mAliveTimer.cancel();
    }

    void sendDialRequest(String calleeId) {
        Logger.d(this.tag() + "sendDialRequest(calleeId: " + calleeId + ")");
        DialRequest request = new DialRequest(calleeId, this.mIsVideoCall, this.mCallOptions.mVideoEnabled, this.mCallOptions.mAudioEnabled, this.mCustomItems);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (e == null && response instanceof DialResponse) {
                this.mIsVideoCall = ((DialResponse)response).isVideoCall();
                this.mCallId = ((DialResponse)response).getCallId();
                this.mCaller = ((DialResponse)response).getCaller();
                this.mCallee = ((DialResponse)response).getCallee();
                this.setLocalVideoEnabled(this.mCallOptions.mVideoEnabled);
                this.setLocalAudioEnabled(this.mCallOptions.mAudioEnabled);
            } else {
                this.setLocalEndedCall(DirectCallEndResult.DIAL_FAILED);
            }
            this.runOnSingleThreadPool(() -> this.mCurrentState.onDialAckReceived(this, e));
        });
    }

    void sendAcceptRequest(AcceptParams params) {
        Logger.d(this.tag() + "sendAcceptRequest()");
        this.mCallOptions = params.mCallOptions;
        this.setLocalVideoEnabled(params.mCallOptions.mVideoEnabled);
        this.setLocalAudioEnabled(params.mCallOptions.mAudioEnabled);
        this.createPeerConnection(this.mTurnCredential);
        AcceptRequest request = new AcceptRequest(this.mCallId, params.mCallOptions.mVideoEnabled, params.mCallOptions.mAudioEnabled);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (e != null) {
                this.setLocalEndedCall(DirectCallEndResult.ACCEPT_FAILED);
            }
            this.runOnSingleThreadPool(() -> this.mCurrentState.onAcceptAckReceived(this, e));
        });
    }

    void createOffer() {
        Logger.d(this.tag() + "createOffer()");
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.createOffer();
        }
    }

    void createAnswer() {
        Logger.d(this.tag() + "createAnswer()");
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.createAnswer();
        }
    }

    void setRemoteDescription(SessionDescription.Type type, String sdp) {
        Logger.d(this.tag() + "setRemoteDescription(type: " + type.canonicalForm() + ")");
        if (sdp != null && sdp.length() > 0 && this.mPeerConnectionClient != null) {
            SessionDescription sessionDescription = new SessionDescription(type, sdp);
            this.mPeerConnectionClient.setRemoteDescription(sessionDescription);
        }
    }

    void sendCancelRequest() {
        Logger.d(this.tag() + "sendCancelRequest()");
        this.setLocalEndedCall(DirectCallEndResult.CANCELED);
        CancelRequest request = new CancelRequest(this.mCallId);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (response instanceof CancelResponse) {
                this.setEndedCall(DirectCallEndResult.CANCELED, ((CancelResponse)response).getEndedCallLog());
            }
            this.runOnSingleThreadPool(() -> this.mCurrentState.onCancelAckReceived(this, e));
        });
    }

    void sendDeclineRequest() {
        Logger.d(this.tag() + "sendDeclineRequest()");
        this.setLocalEndedCall(DirectCallEndResult.DECLINED);
        DeclineRequest request = new DeclineRequest(this.mCallId);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (response instanceof DeclineResponse) {
                this.setEndedCall(DirectCallEndResult.DECLINED, ((DeclineResponse)response).getEndedCallLog());
            }
            this.runOnSingleThreadPool(() -> this.mCurrentState.onDeclineAckReceived(this, e));
        });
    }

    void sendNoAnswerRequest() {
        Logger.d(this.tag() + "sendNoAnswerRequest()");
        this.setLocalEndedCall(DirectCallEndResult.NO_ANSWER);
        NoAnswerRequest request = new NoAnswerRequest(this.mCallId);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (response instanceof NoAnswerResponse) {
                this.setEndedCall(DirectCallEndResult.NO_ANSWER, ((NoAnswerResponse)response).getEndedCallLog());
            }
            this.runOnSingleThreadPool(() -> this.mCurrentState.onNoAnswerAckReceived(this, e));
        });
    }

    void sendEndRequest() {
        Logger.d(this.tag() + "sendEndRequest()");
        this.setLocalEndedCall(DirectCallEndResult.COMPLETED);
        EndRequest request = new EndRequest(this.mCallId);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (response instanceof EndResponse) {
                this.setEndedCall(DirectCallEndResult.COMPLETED, ((EndResponse)response).getEndedCallLog());
            }
            this.runOnSingleThreadPool(() -> this.mCurrentState.onEndAckReceived(this, e));
        });
    }

    void sendUnknownEndRequest() {
        Logger.d(this.tag() + "sendUnknownEndRequest()");
        this.setLocalEndedCall(DirectCallEndResult.UNKNOWN);
        UnknownEndRequest request = new UnknownEndRequest(this.mCallId);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (response instanceof UnknownEndResponse) {
                this.setEndedCall(DirectCallEndResult.UNKNOWN, ((UnknownEndResponse)response).getEndedCallLog());
            }
            this.runOnSingleThreadPool(() -> this.mCurrentState.onUnknownEndAckReceived(this, e));
        });
    }

    void sendTimeoutRequest(@NonNull TimeoutRequest.Reason reason) {
        Logger.d(this.tag() + "sendTimeoutRequest()");
        this.setLocalEndedCall(DirectCallEndResult.TIMED_OUT);
        TimeoutRequest request = new TimeoutRequest(this.mCallId, reason);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (response instanceof TimeoutResponse) {
                this.setEndedCall(DirectCallEndResult.TIMED_OUT, ((TimeoutResponse)response).getEndedCallLog());
            }
            this.runOnSingleThreadPool(() -> this.mCurrentState.onTimeoutAckReceived(this, e));
        });
    }

    void sendConnectionLostRequest() {
        Logger.d(this.tag() + "sendConnectionLostRequest()");
        this.setLocalEndedCall(DirectCallEndResult.CONNECTION_LOST);
        ConnectionLostRequest request = new ConnectionLostRequest(this.mCallId);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (response instanceof ConnectionLostResponse) {
                this.setEndedCall(DirectCallEndResult.CONNECTION_LOST, ((ConnectionLostResponse)response).getEndedCallLog());
            }
        });
    }

    void abort() {
        Logger.d(this.tag() + "abort()");
        this.setLocalEndedCall(DirectCallEndResult.CANCELED);
        this.close();
    }

    void close() {
        Logger.d(this.tag() + "close()");
        this.closePeerConnectionClient();
    }

    void dispatchEvent(DirectCallEventType type) {
        this.dispatchEvent(type, null);
    }

    private void dispatchEvent(DirectCallEventType type, List<String> customItemKeys) {
        Logger.d(this.tag() + "dispatchEvent(type: " + (Object)((Object)type) + "), mListener = " + this.mListener);
        if (type == DirectCallEventType.RINGING && this.mRingingListener != null) {
            this.mRingingListener.onRinging(this);
            return;
        }
        if (type == DirectCallEventType.ENDED && this.mEndListener != null) {
            this.mEndListener.onEnded(this);
        }
        if (this.mListener == null) {
            return;
        }
        switch (type) {
            case ESTABLISHED: {
                SendBirdCall.runOnThreadOption(() -> {
                    if (this.mListener != null) {
                        this.mListener.onEstablished(this);
                    }
                });
                return;
            }
            case CONNECTED: {
                SendBirdCall.runOnThreadOption(() -> {
                    if (this.mListener != null) {
                        this.mListener.onConnected(this);
                    }
                });
                return;
            }
            case ENDED: {
                SendBirdCall.runOnThreadOption(() -> {
                    if (this.mListener != null) {
                        this.mListener.onEnded(this);
                    }
                });
                return;
            }
            case RECONNECTED: {
                SendBirdCall.runOnThreadOption(() -> {
                    if (this.mListener != null) {
                        this.mListener.onReconnected(this);
                    }
                });
                return;
            }
            case RECONNECTING: {
                SendBirdCall.runOnThreadOption(() -> {
                    if (this.mListener != null) {
                        this.mListener.onReconnecting(this);
                    }
                });
                return;
            }
            case UPDATE_CUSTOM_ITEMS: {
                SendBirdCall.runOnThreadOption(() -> {
                    if (this.mListener != null && !this.isEnded()) {
                        this.mListener.onCustomItemsUpdated(this, customItemKeys);
                    }
                });
                return;
            }
            case DELETE_CUSTOM_ITEMS: {
                SendBirdCall.runOnThreadOption(() -> {
                    if (this.mListener != null && !this.isEnded()) {
                        this.mListener.onCustomItemsDeleted(this, customItemKeys);
                    }
                });
                return;
            }
        }
    }

    void setEndListener(DirectCallEndListener listener) {
        this.mEndListener = listener;
    }

    private void sendOfferRequest(@NonNull String sdp) {
        Logger.d(this.tag() + "sendOfferRequest()");
        OfferRequest request = new OfferRequest(this.mCallId, sdp);
        this.mCommandSender.send((Command)request, null);
    }

    private void sendAnswerRequest(@NonNull String sdp) {
        Logger.d(this.tag() + "sendAnswerRequest()");
        AnswerRequest request = new AnswerRequest(this.mCallId, sdp);
        this.mCommandSender.send((Command)request, null);
    }

    private void sendCandidateRequest(@NonNull IceCandidate candidate) {
        Logger.d(this.tag() + "sendCandidateRequest()");
        CandidateRequest request = new CandidateRequest(this.mCallId, new Candidate(candidate.sdp, candidate.sdpMLineIndex, candidate.sdpMid));
        this.mCommandSender.send((Command)request, null);
    }

    private void sendRemoveCandidatesRequest(@NonNull IceCandidate[] removeCandidates) {
        Logger.d(this.tag() + "sendRemoveCandidatesRequest()");
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        for (IceCandidate candidate : removeCandidates) {
            candidates.add(new Candidate(candidate.sdp, candidate.sdpMLineIndex, candidate.sdpMid));
        }
        RemoveCandidatesRequest request = new RemoveCandidatesRequest(this.mCallId, candidates);
        this.mCommandSender.send((Command)request, null);
    }

    private boolean isWebRtcConnected() {
        return this.mCurrentState instanceof DirectCallConnectedState;
    }

    void setRemoteConstraints(Constraints constraints) {
        this.setRemoteAudioEnabled(constraints.getAudioConstraints());
        this.setRemoteVideoEnabled(constraints.getVideoConstraints());
    }

    void createPeerConnection(TurnCredential turnCredential) {
        String userName = turnCredential.getUserName();
        String password = turnCredential.getPassword();
        List turnUrls = turnCredential.getTurnUrls();
        ArrayList<PeerConnection.IceServer> iceServers = new ArrayList<PeerConnection.IceServer>();
        if (userName != null && password != null && turnUrls != null && turnUrls.size() > 0) {
            for (String turnUrl : turnUrls) {
                PeerConnection.IceServer turnServer = PeerConnection.IceServer.builder((String)turnUrl).setUsername(userName).setPassword(password).createIceServer();
                iceServers.add(turnServer);
            }
        }
        this.mPeerConnectionClient = PeerConnectionClientFactory.create(this.mContext, this.mIsVideoCall, this.mCallOptions, iceServers, this.mPeerConnectionEvents, (currentAudioDevice, availableAudioDevices) -> {
            if (this.mBroadcastListener != null) {
                this.mBroadcastListener.onAudioDeviceChanged(currentAudioDevice, availableAudioDevices);
            }
        });
    }

    private void setLocalEndedCall(@NonNull DirectCallEndResult endResult) {
        Logger.d(this.tag() + "setLocalEndedCall(endResult: " + endResult + ")");
        this.mEndResult = endResult;
        this.mEndedBy = this.getLocalUser();
    }

    private void setEndedCall(@NonNull DirectCallEndResult endResult, @NonNull DirectCallLog endedCallLog) {
        Logger.d(this.tag() + "setEndedCall(endResult: " + endResult + ", duration: " + endedCallLog.getDuration() + ")");
        this.mEndResult = endResult;
        this.mEndedBy = endedCallLog.getEndedBy();
        this.mDuration = endedCallLog.getDuration();
        this.mCaller = endedCallLog.getCaller();
        this.mCallee = endedCallLog.getCallee();
    }

    private void closePeerConnectionClient() {
        if (this.mPeerConnectionClient != null) {
            Logger.d(this.tag() + "closePeerConnectionClient()");
            this.mPeerConnectionClient.close();
        } else {
            this.runOnSingleThreadPool(() -> this.mCurrentState.onClosed(this));
        }
    }

    private void setLocalVideoEnabled(boolean isEnabled) {
        Logger.d(this.tag() + "setLocalVideoEnabled(isEnabled: " + isEnabled + ")");
        this.mIsLocalVideoEnabled = this.mIsVideoCall ? isEnabled : false;
    }

    private void setLocalAudioEnabled(boolean isEnabled) {
        Logger.d(this.tag() + "setLocalAudioEnabled(isEnabled: " + isEnabled + ")");
        this.mIsLocalAudioEnabled = isEnabled;
    }

    private void setRemoteVideoEnabled(boolean isEnabled) {
    }

    private void setRemoteAudioEnabled(boolean isEnabled) {
        Logger.d(this.tag() + "setRemoteAudioEnabled(isEnabled: " + isEnabled + ")");
        boolean isToggled = this.mIsRemoteAudioEnabled != isEnabled;
        this.mIsRemoteAudioEnabled = isEnabled;
        if (isToggled && this.mListener != null) {
            SendBirdCall.runOnThreadOption(() -> {
                if (this.mListener != null) {
                    this.mListener.onRemoteAudioSettingsChanged(this);
                }
            });
        }
    }

    private void setCustomItems(Map<String, String> customItems, long affectedAt) {
        if (this.mCustomItemsLastAffectedAt > affectedAt) {
            return;
        }
        this.mCustomItems = new HashMap<String, String>(customItems);
        this.mCustomItemsLastAffectedAt = affectedAt;
    }

    private String tag() {
        return this.mAmICallee ? "[DirectCall][Callee] " : "[DirectCall][Caller] ";
    }

    void onDialReceived() {
        Logger.d(this.tag() + "onDialReceived()");
        this.runOnSingleThreadPool(() -> this.mCurrentState.onDialReceived(this));
    }

    void onEvent(Command command) {
        Logger.d(this.tag() + "onEvent(command: " + command.getClass().getSimpleName() + ")");
        if (command instanceof AcceptPushCommand) {
            this.runOnSingleThreadPool(() -> this.mCurrentState.onAcceptReceived(this, (AcceptPushCommand)command));
        } else if (command instanceof OtherDeviceAcceptedPushCommand) {
            this.setLocalEndedCall(DirectCallEndResult.OTHER_DEVICE_ACCEPTED);
            this.runOnSingleThreadPool(() -> this.mCurrentState.onOtherDeviceAccepted(this));
        } else if (command instanceof OfferPushCommand) {
            String sdp = ((OfferPushCommand)command).getSdp();
            StringUtils.uncompress(sdp, result -> this.runOnSingleThreadPool(() -> this.mCurrentState.onOfferReceived(this, result)));
        } else if (command instanceof AnswerPushCommand) {
            String sdp = ((AnswerPushCommand)command).getSdp();
            StringUtils.uncompress(sdp, result -> this.runOnSingleThreadPool(() -> this.mCurrentState.onAnswerReceived(this, result)));
        } else if (command instanceof CandidatePushCommand) {
            Candidate candidate = ((CandidatePushCommand)command).getCandidate();
            if (candidate != null) {
                IceCandidate iceCandidate = new IceCandidate(candidate.getSdpMid(), candidate.getSdpMlineIndex(), candidate.getSdp());
                if (this.mPeerConnectionClient != null) {
                    this.mPeerConnectionClient.addRemoteIceCandidate(iceCandidate);
                }
            }
        } else if (command instanceof RemoveCandidatesPushCommand) {
            List candidateList = ((RemoveCandidatesPushCommand)command).getCandidates();
            if (candidateList != null && candidateList.size() > 0) {
                IceCandidate[] iceCandidates = new IceCandidate[candidateList.size()];
                for (int i = 0; i < candidateList.size(); ++i) {
                    Candidate candidate = (Candidate)candidateList.get(i);
                    if (candidate == null) continue;
                    iceCandidates[i] = new IceCandidate(candidate.getSdpMid(), candidate.getSdpMlineIndex(), candidate.getSdp());
                }
                if (this.mPeerConnectionClient != null) {
                    this.mPeerConnectionClient.removeRemoteIceCandidates(iceCandidates);
                }
            }
        } else if (command instanceof VideoStatusPushCommand) {
            boolean isEnabled = ((VideoStatusPushCommand)command).isEnabled();
            this.setRemoteVideoEnabled(isEnabled);
        } else if (command instanceof AudioStatusPushCommand) {
            boolean isEnabled = ((AudioStatusPushCommand)command).isEnabled();
            this.setRemoteAudioEnabled(isEnabled);
        } else if (command instanceof CancelPushCommand) {
            this.setEndedCall(DirectCallEndResult.CANCELED, ((CancelPushCommand)command).getEndedCallLog());
            this.runOnSingleThreadPool(() -> this.mCurrentState.onCancelReceived(this));
        } else if (command instanceof DeclinePushCommand) {
            this.setEndedCall(DirectCallEndResult.DECLINED, ((DeclinePushCommand)command).getEndedCallLog());
            this.runOnSingleThreadPool(() -> this.mCurrentState.onDeclineReceived(this));
        } else if (command instanceof NoAnswerPushCommand) {
            this.setEndedCall(DirectCallEndResult.NO_ANSWER, ((NoAnswerPushCommand)command).getEndedCallLog());
            this.runOnSingleThreadPool(() -> this.mCurrentState.onNoAnswerReceived(this));
        } else if (command instanceof EndPushCommand) {
            this.setEndedCall(DirectCallEndResult.COMPLETED, ((EndPushCommand)command).getEndedCallLog());
            this.runOnSingleThreadPool(() -> this.mCurrentState.onEndReceived(this));
        } else if (command instanceof UnknownEndPushCommand) {
            this.setEndedCall(DirectCallEndResult.UNKNOWN, ((UnknownEndPushCommand)command).getEndedCallLog());
            this.runOnSingleThreadPool(() -> this.mCurrentState.onUnknownEndReceived(this));
        } else if (command instanceof TimeoutPushCommand) {
            this.setEndedCall(DirectCallEndResult.TIMED_OUT, ((TimeoutPushCommand)command).getEndedCallLog());
            this.runOnSingleThreadPool(() -> this.mCurrentState.onTimeoutReceived(this));
        } else if (command instanceof ConnectionLostPushCommand) {
            this.setEndedCall(DirectCallEndResult.CONNECTION_LOST, ((ConnectionLostPushCommand)command).getEndedCallLog());
            this.runOnSingleThreadPool(() -> this.mCurrentState.onConnectionLostReceived(this));
        } else if (command instanceof UpdateCustomItemsPushCommand) {
            Map customItems = ((UpdateCustomItemsPushCommand)command).getCustomItems();
            long affectedAt = ((UpdateCustomItemsPushCommand)command).getAffectedAt();
            this.setCustomItems(customItems, affectedAt);
            List updatedKeys = ((UpdateCustomItemsPushCommand)command).getUpdatedKeys();
            this.dispatchEvent(DirectCallEventType.UPDATE_CUSTOM_ITEMS, updatedKeys);
        } else if (command instanceof DeleteCustomItemsPushCommand) {
            Map customItems = ((DeleteCustomItemsPushCommand)command).getCustomItems();
            long affectedAt = ((DeleteCustomItemsPushCommand)command).getAffectedAt();
            this.setCustomItems(customItems, affectedAt);
            List deletedKeys = ((DeleteCustomItemsPushCommand)command).getDeletedKeys();
            this.dispatchEvent(DirectCallEventType.DELETE_CUSTOM_ITEMS, deletedKeys);
        }
    }

    private void runOnSingleThreadPool(Runnable runnable) {
        if (this.mSingleThreadExecutor != null && !this.mSingleThreadExecutor.isShutdown()) {
            this.mSingleThreadExecutor.execute(runnable);
        }
    }

    void onAudioDeviceChanged(AudioDevice currentAudioDevice, Set<AudioDevice> availableAudioDevices) {
        Logger.d(this.tag() + "onAudioDeviceChanged(currentAudioDevice: " + (Object)((Object)currentAudioDevice) + ", availableAudioDevices: " + availableAudioDevices + ")");
        SendBirdCall.runOnThreadOption(() -> {
            if (this.mListener != null) {
                this.mListener.onAudioDeviceChanged(this, currentAudioDevice, availableAudioDevices);
            }
        });
    }

    void setStateTimerDelay(long delayMillis) {
        this.stopStateTimer();
        this.startStateTimer(delayMillis);
    }

    _PeerConnectionClient.PeerConnectionEvents getPeerConnectionEvents() {
        return this.mPeerConnectionEvents;
    }

    static enum DirectCallEventType {
        ESTABLISHED,
        CONNECTED,
        RECONNECTING,
        RECONNECTED,
        ENDED,
        RINGING,
        UPDATE_CUSTOM_ITEMS,
        DELETE_CUSTOM_ITEMS;

    }
}

