/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import android.os.Environment;
import android.support.annotation.Nullable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.ExecutorService;
import org.webrtc.audio.JavaAudioDeviceModule;

class _RecordedAudioToFileController
implements JavaAudioDeviceModule.SamplesReadyCallback {
    private static final String TAG = "RecordedAudioToFile";
    private static final long MAX_FILE_SIZE_IN_BYTES = 58348800L;
    private final Object lock = new Object();
    private final ExecutorService executor;
    @Nullable
    private OutputStream rawAudioFileOutputStream;
    private boolean isRunning;
    private long fileSizeInBytes;

    public _RecordedAudioToFileController(ExecutorService executor) {
        this.executor = executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start() {
        if (!this.isExternalStorageWritable()) {
            return false;
        }
        Object object = this.lock;
        synchronized (object) {
            this.isRunning = true;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.lock;
        synchronized (object) {
            this.isRunning = false;
            if (this.rawAudioFileOutputStream != null) {
                try {
                    this.rawAudioFileOutputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.rawAudioFileOutputStream = null;
            }
            this.fileSizeInBytes = 0L;
        }
    }

    private boolean isExternalStorageWritable() {
        String state = Environment.getExternalStorageState();
        return "mounted".equals(state);
    }

    private void openRawAudioOutputFile(int sampleRate, int channelCount) {
        String fileName = Environment.getExternalStorageDirectory().getPath() + File.separator + "recorded_audio_16bits_" + String.valueOf(sampleRate) + "Hz" + (channelCount == 1 ? "_mono" : "_stereo") + ".pcm";
        File outputFile = new File(fileName);
        try {
            this.rawAudioFileOutputStream = new FileOutputStream(outputFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onWebRtcAudioRecordSamplesReady(JavaAudioDeviceModule.AudioSamples samples) {
        if (samples.getAudioFormat() != 2) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.isRunning) {
                return;
            }
            if (this.rawAudioFileOutputStream == null) {
                this.openRawAudioOutputFile(samples.getSampleRate(), samples.getChannelCount());
                this.fileSizeInBytes = 0L;
            }
        }
        this.executor.execute(() -> {
            if (this.rawAudioFileOutputStream != null) {
                try {
                    if (this.fileSizeInBytes < 58348800L) {
                        this.rawAudioFileOutputStream.write(samples.getData());
                        this.fileSizeInBytes += (long)samples.getData().length;
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }
}

