/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothHeadset;
import android.bluetooth.BluetoothProfile;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioManager;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.support.annotation.Nullable;
import com.sendbird.call._AppRTCAudioManager;
import java.util.List;
import java.util.Set;
import org.webrtc.ThreadUtils;

class _AppRTCBluetoothManager {
    private static final String TAG = "AppRTCBluetoothManager";
    private static final int BLUETOOTH_SCO_TIMEOUT_MS = 4000;
    private static final int MAX_SCO_CONNECTION_ATTEMPTS = 2;
    private final Context apprtcContext;
    private final _AppRTCAudioManager apprtcAudioManager;
    @Nullable
    private final AudioManager audioManager;
    private final Handler handler;
    int scoConnectionAttempts;
    private State bluetoothState;
    private final BluetoothProfile.ServiceListener bluetoothServiceListener;
    @Nullable
    private BluetoothAdapter bluetoothAdapter;
    @Nullable
    private BluetoothHeadset bluetoothHeadset;
    @Nullable
    private BluetoothDevice bluetoothDevice;
    private final BroadcastReceiver bluetoothHeadsetReceiver;
    private final Runnable bluetoothTimeoutRunnable = new Runnable(){

        @Override
        public void run() {
            _AppRTCBluetoothManager.this.bluetoothTimeout();
        }
    };

    static _AppRTCBluetoothManager create(Context context, _AppRTCAudioManager audioManager) {
        return new _AppRTCBluetoothManager(context, audioManager);
    }

    protected _AppRTCBluetoothManager(Context context, _AppRTCAudioManager audioManager) {
        ThreadUtils.checkIsOnMainThread();
        this.apprtcContext = context;
        this.apprtcAudioManager = audioManager;
        this.audioManager = this.getAudioManager(context);
        this.bluetoothState = State.UNINITIALIZED;
        this.bluetoothServiceListener = new BluetoothServiceListener();
        this.bluetoothHeadsetReceiver = new BluetoothHeadsetBroadcastReceiver();
        this.handler = new Handler(Looper.getMainLooper());
    }

    public State getState() {
        ThreadUtils.checkIsOnMainThread();
        return this.bluetoothState;
    }

    public void start() {
        ThreadUtils.checkIsOnMainThread();
        if (!this.hasPermission(this.apprtcContext, "android.permission.BLUETOOTH")) {
            return;
        }
        if (this.bluetoothState != State.UNINITIALIZED) {
            return;
        }
        this.bluetoothHeadset = null;
        this.bluetoothDevice = null;
        this.scoConnectionAttempts = 0;
        this.bluetoothAdapter = BluetoothAdapter.getDefaultAdapter();
        if (this.bluetoothAdapter == null) {
            return;
        }
        if (!this.audioManager.isBluetoothScoAvailableOffCall()) {
            return;
        }
        this.logBluetoothAdapterInfo(this.bluetoothAdapter);
        if (!this.getBluetoothProfileProxy(this.apprtcContext, this.bluetoothServiceListener, 1)) {
            return;
        }
        IntentFilter bluetoothHeadsetFilter = new IntentFilter();
        bluetoothHeadsetFilter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        bluetoothHeadsetFilter.addAction("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED");
        this.registerReceiver(this.bluetoothHeadsetReceiver, bluetoothHeadsetFilter);
        this.bluetoothState = State.HEADSET_UNAVAILABLE;
    }

    public void stop() {
        ThreadUtils.checkIsOnMainThread();
        if (this.bluetoothAdapter == null) {
            return;
        }
        this.stopScoAudio();
        if (this.bluetoothState == State.UNINITIALIZED) {
            return;
        }
        this.unregisterReceiver(this.bluetoothHeadsetReceiver);
        this.cancelTimer();
        if (this.bluetoothHeadset != null) {
            this.bluetoothAdapter.closeProfileProxy(1, (BluetoothProfile)this.bluetoothHeadset);
            this.bluetoothHeadset = null;
        }
        this.bluetoothAdapter = null;
        this.bluetoothDevice = null;
        this.bluetoothState = State.UNINITIALIZED;
    }

    public boolean startScoAudio() {
        ThreadUtils.checkIsOnMainThread();
        if (this.scoConnectionAttempts >= 2) {
            return false;
        }
        if (this.bluetoothState != State.HEADSET_AVAILABLE) {
            return false;
        }
        this.bluetoothState = State.SCO_CONNECTING;
        this.audioManager.startBluetoothSco();
        this.audioManager.setBluetoothScoOn(true);
        ++this.scoConnectionAttempts;
        this.startTimer();
        return true;
    }

    public void stopScoAudio() {
        ThreadUtils.checkIsOnMainThread();
        if (this.bluetoothState != State.SCO_CONNECTING && this.bluetoothState != State.SCO_CONNECTED) {
            return;
        }
        this.cancelTimer();
        this.audioManager.stopBluetoothSco();
        this.audioManager.setBluetoothScoOn(false);
        this.bluetoothState = State.SCO_DISCONNECTING;
    }

    public void updateDevice() {
        if (this.bluetoothState == State.UNINITIALIZED || this.bluetoothHeadset == null) {
            return;
        }
        List devices = this.bluetoothHeadset.getConnectedDevices();
        if (devices.isEmpty()) {
            this.bluetoothDevice = null;
            this.bluetoothState = State.HEADSET_UNAVAILABLE;
        } else {
            this.bluetoothDevice = (BluetoothDevice)devices.get(0);
            this.bluetoothState = State.HEADSET_AVAILABLE;
        }
    }

    @Nullable
    protected AudioManager getAudioManager(Context context) {
        return (AudioManager)context.getSystemService("audio");
    }

    protected void registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        this.apprtcContext.registerReceiver(receiver, filter);
    }

    protected void unregisterReceiver(BroadcastReceiver receiver) {
        this.apprtcContext.unregisterReceiver(receiver);
    }

    protected boolean getBluetoothProfileProxy(Context context, BluetoothProfile.ServiceListener listener, int profile) {
        return this.bluetoothAdapter.getProfileProxy(context, listener, profile);
    }

    protected boolean hasPermission(Context context, String permission2) {
        return this.apprtcContext.checkPermission(permission2, Process.myPid(), Process.myUid()) == 0;
    }

    @SuppressLint(value={"HardwareIds"})
    protected void logBluetoothAdapterInfo(BluetoothAdapter localAdapter) {
        Set pairedDevices = localAdapter.getBondedDevices();
        if (!pairedDevices.isEmpty()) {
            for (BluetoothDevice bluetoothDevice : pairedDevices) {
            }
        }
    }

    private void updateAudioDeviceState() {
        ThreadUtils.checkIsOnMainThread();
        this.apprtcAudioManager.updateAudioDeviceState();
    }

    private void startTimer() {
        ThreadUtils.checkIsOnMainThread();
        this.handler.postDelayed(this.bluetoothTimeoutRunnable, 4000L);
    }

    private void cancelTimer() {
        ThreadUtils.checkIsOnMainThread();
        this.handler.removeCallbacks(this.bluetoothTimeoutRunnable);
    }

    private void bluetoothTimeout() {
        ThreadUtils.checkIsOnMainThread();
        if (this.bluetoothState == State.UNINITIALIZED || this.bluetoothHeadset == null) {
            return;
        }
        if (this.bluetoothState != State.SCO_CONNECTING) {
            return;
        }
        boolean scoConnected = false;
        List devices = this.bluetoothHeadset.getConnectedDevices();
        if (devices.size() > 0) {
            this.bluetoothDevice = (BluetoothDevice)devices.get(0);
            if (this.bluetoothHeadset.isAudioConnected(this.bluetoothDevice)) {
                scoConnected = true;
            }
        }
        if (scoConnected) {
            this.bluetoothState = State.SCO_CONNECTED;
            this.scoConnectionAttempts = 0;
        } else {
            this.stopScoAudio();
        }
        this.updateAudioDeviceState();
    }

    private boolean isScoOn() {
        return this.audioManager.isBluetoothScoOn();
    }

    private String stateToString(int state) {
        switch (state) {
            case 0: {
                return "DISCONNECTED";
            }
            case 2: {
                return "CONNECTED";
            }
            case 1: {
                return "CONNECTING";
            }
            case 3: {
                return "DISCONNECTING";
            }
            case 10: {
                return "OFF";
            }
            case 12: {
                return "ON";
            }
            case 13: {
                return "TURNING_OFF";
            }
            case 11: {
                return "TURNING_ON";
            }
        }
        return "INVALID";
    }

    private class BluetoothHeadsetBroadcastReceiver
    extends BroadcastReceiver {
        private BluetoothHeadsetBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (_AppRTCBluetoothManager.this.bluetoothState == State.UNINITIALIZED) {
                return;
            }
            String action = intent.getAction();
            if (action.equals("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 0);
                if (state == 2) {
                    _AppRTCBluetoothManager.this.scoConnectionAttempts = 0;
                    _AppRTCBluetoothManager.this.updateAudioDeviceState();
                } else if (state != 1 && state != 3 && state == 0) {
                    _AppRTCBluetoothManager.this.stopScoAudio();
                    _AppRTCBluetoothManager.this.updateAudioDeviceState();
                }
            } else if (action.equals("android.bluetooth.headset.profile.action.AUDIO_STATE_CHANGED")) {
                int state = intent.getIntExtra("android.bluetooth.profile.extra.STATE", 10);
                if (state == 12) {
                    _AppRTCBluetoothManager.this.cancelTimer();
                    if (_AppRTCBluetoothManager.this.bluetoothState == State.SCO_CONNECTING) {
                        _AppRTCBluetoothManager.this.bluetoothState = State.SCO_CONNECTED;
                        _AppRTCBluetoothManager.this.scoConnectionAttempts = 0;
                        _AppRTCBluetoothManager.this.updateAudioDeviceState();
                    }
                } else if (state != 11 && state == 10) {
                    if (this.isInitialStickyBroadcast()) {
                        return;
                    }
                    _AppRTCBluetoothManager.this.updateAudioDeviceState();
                }
            }
        }
    }

    private class BluetoothServiceListener
    implements BluetoothProfile.ServiceListener {
        private BluetoothServiceListener() {
        }

        public void onServiceConnected(int profile, BluetoothProfile proxy) {
            if (profile != 1 || _AppRTCBluetoothManager.this.bluetoothState == State.UNINITIALIZED) {
                return;
            }
            _AppRTCBluetoothManager.this.bluetoothHeadset = (BluetoothHeadset)proxy;
            _AppRTCBluetoothManager.this.updateAudioDeviceState();
        }

        public void onServiceDisconnected(int profile) {
            if (profile != 1 || _AppRTCBluetoothManager.this.bluetoothState == State.UNINITIALIZED) {
                return;
            }
            _AppRTCBluetoothManager.this.stopScoAudio();
            _AppRTCBluetoothManager.this.bluetoothHeadset = null;
            _AppRTCBluetoothManager.this.bluetoothDevice = null;
            _AppRTCBluetoothManager.this.bluetoothState = State.HEADSET_UNAVAILABLE;
            _AppRTCBluetoothManager.this.updateAudioDeviceState();
        }
    }

    public static enum State {
        UNINITIALIZED,
        ERROR,
        HEADSET_UNAVAILABLE,
        HEADSET_AVAILABLE,
        SCO_DISCONNECTING,
        SCO_CONNECTING,
        SCO_CONNECTED;

    }
}

