/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.os.Build;
import android.support.annotation.Nullable;
import com.sendbird.call.SendBirdCall;
import com.sendbird.call._AppRTCBluetoothManager;
import com.sendbird.call._AppRTCProximitySensor;
import com.sendbird.call._AppRTCUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.webrtc.ThreadUtils;

class _AppRTCAudioManager {
    private static final String TAG = "AppRTCAudioManager";
    private static final String SPEAKERPHONE_AUTO = "auto";
    private static final String SPEAKERPHONE_TRUE = "true";
    private static final String SPEAKERPHONE_FALSE = "false";
    private final Context apprtcContext;
    @Nullable
    private AudioManager audioManager;
    @Nullable
    private AudioManagerEvents audioManagerEvents;
    private AudioManagerState amState;
    private int savedAudioMode = -2;
    private boolean savedIsSpeakerPhoneOn;
    private boolean savedIsMicrophoneMute;
    private boolean hasWiredHeadset;
    private SendBirdCall.AudioDevice defaultAudioDevice;
    private SendBirdCall.AudioDevice selectedAudioDevice;
    private SendBirdCall.AudioDevice userSelectedAudioDevice;
    @Nullable
    private final String useSpeakerphone;
    @Nullable
    private _AppRTCProximitySensor proximitySensor;
    private final _AppRTCBluetoothManager bluetoothManager;
    private Set<SendBirdCall.AudioDevice> audioDevices = new HashSet<SendBirdCall.AudioDevice>();
    private BroadcastReceiver wiredHeadsetReceiver;
    @Nullable
    private AudioManager.OnAudioFocusChangeListener audioFocusChangeListener;

    private void onProximitySensorChangedState() {
        if (!this.useSpeakerphone.equals(SPEAKERPHONE_AUTO)) {
            return;
        }
        if (this.audioDevices.size() == 2 && this.audioDevices.contains((Object)SendBirdCall.AudioDevice.EARPIECE) && this.audioDevices.contains((Object)SendBirdCall.AudioDevice.SPEAKER_PHONE)) {
            if (this.proximitySensor.sensorReportsNearState()) {
                this.setAudioDeviceInternal(SendBirdCall.AudioDevice.EARPIECE);
            } else {
                this.setAudioDeviceInternal(SendBirdCall.AudioDevice.SPEAKER_PHONE);
            }
        }
    }

    public static _AppRTCAudioManager create(Context context) {
        return new _AppRTCAudioManager(context);
    }

    private _AppRTCAudioManager(Context context) {
        ThreadUtils.checkIsOnMainThread();
        this.apprtcContext = context;
        this.audioManager = (AudioManager)context.getSystemService("audio");
        this.bluetoothManager = _AppRTCBluetoothManager.create(context, this);
        this.wiredHeadsetReceiver = new WiredHeadsetReceiver();
        this.amState = AudioManagerState.UNINITIALIZED;
        this.useSpeakerphone = SPEAKERPHONE_AUTO;
        this.defaultAudioDevice = this.useSpeakerphone.equals(SPEAKERPHONE_FALSE) ? SendBirdCall.AudioDevice.EARPIECE : SendBirdCall.AudioDevice.SPEAKER_PHONE;
        this.proximitySensor = _AppRTCProximitySensor.create(context, this::onProximitySensorChangedState);
        _AppRTCUtils.logDeviceInfo(TAG);
    }

    public void start(AudioManagerEvents audioManagerEvents) {
        ThreadUtils.checkIsOnMainThread();
        if (this.amState == AudioManagerState.RUNNING) {
            return;
        }
        this.audioManagerEvents = audioManagerEvents;
        this.amState = AudioManagerState.RUNNING;
        this.savedAudioMode = this.audioManager.getMode();
        this.savedIsSpeakerPhoneOn = this.audioManager.isSpeakerphoneOn();
        this.savedIsMicrophoneMute = this.audioManager.isMicrophoneMute();
        this.hasWiredHeadset = this.hasWiredHeadset();
        this.audioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){

            public void onAudioFocusChange(int focusChange) {
                switch (focusChange) {
                    case 1: {
                        String typeOfChange = "AUDIOFOCUS_GAIN";
                        break;
                    }
                    case 2: {
                        String typeOfChange = "AUDIOFOCUS_GAIN_TRANSIENT";
                        break;
                    }
                    case 4: {
                        String typeOfChange = "AUDIOFOCUS_GAIN_TRANSIENT_EXCLUSIVE";
                        break;
                    }
                    case 3: {
                        String typeOfChange = "AUDIOFOCUS_GAIN_TRANSIENT_MAY_DUCK";
                        break;
                    }
                    case -1: {
                        String typeOfChange = "AUDIOFOCUS_LOSS";
                        break;
                    }
                    case -2: {
                        String typeOfChange = "AUDIOFOCUS_LOSS_TRANSIENT";
                        break;
                    }
                    case -3: {
                        String typeOfChange = "AUDIOFOCUS_LOSS_TRANSIENT_CAN_DUCK";
                        break;
                    }
                    default: {
                        String typeOfChange = "AUDIOFOCUS_INVALID";
                    }
                }
            }
        };
        int result = this.audioManager.requestAudioFocus(this.audioFocusChangeListener, 0, 2);
        if (result == 1) {
            // empty if block
        }
        this.audioManager.setMode(3);
        this.setMicrophoneMute(false);
        this.userSelectedAudioDevice = SendBirdCall.AudioDevice.NONE;
        this.selectedAudioDevice = SendBirdCall.AudioDevice.NONE;
        this.audioDevices.clear();
        this.bluetoothManager.start();
        this.updateAudioDeviceState();
        this.registerReceiver(this.wiredHeadsetReceiver, new IntentFilter("android.intent.action.HEADSET_PLUG"));
    }

    public void stop() {
        ThreadUtils.checkIsOnMainThread();
        if (this.amState != AudioManagerState.RUNNING) {
            return;
        }
        this.amState = AudioManagerState.UNINITIALIZED;
        this.unregisterReceiver(this.wiredHeadsetReceiver);
        this.bluetoothManager.stop();
        this.setSpeakerphoneOn(this.savedIsSpeakerPhoneOn);
        this.setMicrophoneMute(this.savedIsMicrophoneMute);
        this.audioManager.setMode(this.savedAudioMode);
        this.audioManager.abandonAudioFocus(this.audioFocusChangeListener);
        this.audioFocusChangeListener = null;
        if (this.proximitySensor != null) {
            this.proximitySensor.stop();
            this.proximitySensor = null;
        }
        this.audioManagerEvents = null;
    }

    private void setAudioDeviceInternal(SendBirdCall.AudioDevice device) {
        _AppRTCUtils.assertIsTrue(this.audioDevices.contains((Object)device));
        switch (device) {
            case SPEAKER_PHONE: {
                this.setSpeakerphoneOn(true);
                break;
            }
            case EARPIECE: {
                this.setSpeakerphoneOn(false);
                break;
            }
            case WIRED_HEADSET: {
                this.setSpeakerphoneOn(false);
                break;
            }
            case BLUETOOTH: {
                this.setSpeakerphoneOn(false);
                break;
            }
        }
        this.selectedAudioDevice = device;
    }

    public void setDefaultAudioDevice(SendBirdCall.AudioDevice defaultDevice) {
        ThreadUtils.checkIsOnMainThread();
        switch (defaultDevice) {
            case SPEAKER_PHONE: {
                this.defaultAudioDevice = defaultDevice;
                break;
            }
            case EARPIECE: {
                if (this.hasEarpiece()) {
                    this.defaultAudioDevice = defaultDevice;
                    break;
                }
                this.defaultAudioDevice = SendBirdCall.AudioDevice.SPEAKER_PHONE;
                break;
            }
        }
        this.updateAudioDeviceState();
    }

    public void selectAudioDevice(SendBirdCall.AudioDevice device) {
        ThreadUtils.checkIsOnMainThread();
        if (!this.audioDevices.contains((Object)device)) {
            // empty if block
        }
        this.userSelectedAudioDevice = device;
        this.updateAudioDeviceState();
    }

    public Set<SendBirdCall.AudioDevice> getAudioDevices() {
        ThreadUtils.checkIsOnMainThread();
        return Collections.unmodifiableSet(new HashSet<SendBirdCall.AudioDevice>(this.audioDevices));
    }

    public SendBirdCall.AudioDevice getSelectedAudioDevice() {
        ThreadUtils.checkIsOnMainThread();
        return this.selectedAudioDevice;
    }

    private void registerReceiver(BroadcastReceiver receiver, IntentFilter filter) {
        this.apprtcContext.registerReceiver(receiver, filter);
    }

    private void unregisterReceiver(BroadcastReceiver receiver) {
        this.apprtcContext.unregisterReceiver(receiver);
    }

    private void setSpeakerphoneOn(boolean on) {
        boolean wasOn = this.audioManager.isSpeakerphoneOn();
        if (wasOn == on) {
            return;
        }
        this.audioManager.setSpeakerphoneOn(on);
    }

    private void setMicrophoneMute(boolean on) {
        boolean wasMuted = this.audioManager.isMicrophoneMute();
        if (wasMuted == on) {
            return;
        }
        this.audioManager.setMicrophoneMute(on);
    }

    private boolean hasEarpiece() {
        return this.apprtcContext.getPackageManager().hasSystemFeature("android.hardware.telephony");
    }

    @Deprecated
    private boolean hasWiredHeadset() {
        AudioDeviceInfo[] devices;
        if (Build.VERSION.SDK_INT < 23) {
            return this.audioManager.isWiredHeadsetOn();
        }
        for (AudioDeviceInfo device : devices = this.audioManager.getDevices(3)) {
            int type = device.getType();
            if (type == 3) {
                return true;
            }
            if (type != 11) continue;
            return true;
        }
        return false;
    }

    public void updateAudioDeviceState() {
        SendBirdCall.AudioDevice newAudioDevice;
        boolean needBluetoothAudioStop;
        ThreadUtils.checkIsOnMainThread();
        if (this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.HEADSET_AVAILABLE || this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.HEADSET_UNAVAILABLE || this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.SCO_DISCONNECTING) {
            this.bluetoothManager.updateDevice();
        }
        HashSet<SendBirdCall.AudioDevice> newAudioDevices = new HashSet<SendBirdCall.AudioDevice>();
        if (this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.SCO_CONNECTED || this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.SCO_CONNECTING || this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.HEADSET_AVAILABLE) {
            newAudioDevices.add(SendBirdCall.AudioDevice.BLUETOOTH);
        }
        if (this.hasWiredHeadset) {
            newAudioDevices.add(SendBirdCall.AudioDevice.WIRED_HEADSET);
        } else {
            newAudioDevices.add(SendBirdCall.AudioDevice.SPEAKER_PHONE);
            if (this.hasEarpiece()) {
                newAudioDevices.add(SendBirdCall.AudioDevice.EARPIECE);
            }
        }
        boolean audioDeviceSetUpdated = !this.audioDevices.equals(newAudioDevices);
        this.audioDevices = newAudioDevices;
        if (this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.HEADSET_UNAVAILABLE && this.userSelectedAudioDevice == SendBirdCall.AudioDevice.BLUETOOTH) {
            this.userSelectedAudioDevice = SendBirdCall.AudioDevice.NONE;
        }
        if (this.hasWiredHeadset && this.userSelectedAudioDevice == SendBirdCall.AudioDevice.SPEAKER_PHONE) {
            this.userSelectedAudioDevice = SendBirdCall.AudioDevice.WIRED_HEADSET;
        }
        if (!this.hasWiredHeadset && this.userSelectedAudioDevice == SendBirdCall.AudioDevice.WIRED_HEADSET) {
            this.userSelectedAudioDevice = SendBirdCall.AudioDevice.SPEAKER_PHONE;
        }
        boolean needBluetoothAudioStart = this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.HEADSET_AVAILABLE && (this.userSelectedAudioDevice == SendBirdCall.AudioDevice.NONE || this.userSelectedAudioDevice == SendBirdCall.AudioDevice.BLUETOOTH);
        boolean bl = needBluetoothAudioStop = (this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.SCO_CONNECTED || this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.SCO_CONNECTING) && this.userSelectedAudioDevice != SendBirdCall.AudioDevice.NONE && this.userSelectedAudioDevice != SendBirdCall.AudioDevice.BLUETOOTH;
        if (this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.HEADSET_AVAILABLE || this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.SCO_CONNECTING || this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.SCO_CONNECTED) {
            // empty if block
        }
        if (needBluetoothAudioStop) {
            this.bluetoothManager.stopScoAudio();
            this.bluetoothManager.updateDevice();
        }
        if (needBluetoothAudioStart && !needBluetoothAudioStop && !this.bluetoothManager.startScoAudio()) {
            this.audioDevices.remove((Object)SendBirdCall.AudioDevice.BLUETOOTH);
            audioDeviceSetUpdated = true;
        }
        if ((newAudioDevice = this.bluetoothManager.getState() == _AppRTCBluetoothManager.State.SCO_CONNECTED ? SendBirdCall.AudioDevice.BLUETOOTH : (this.hasWiredHeadset ? SendBirdCall.AudioDevice.WIRED_HEADSET : this.defaultAudioDevice)) != this.selectedAudioDevice || audioDeviceSetUpdated) {
            this.setAudioDeviceInternal(newAudioDevice);
            if (this.audioManagerEvents != null) {
                this.audioManagerEvents.onAudioDeviceChanged(this.selectedAudioDevice, this.audioDevices);
            }
        }
    }

    private class WiredHeadsetReceiver
    extends BroadcastReceiver {
        private static final int STATE_UNPLUGGED = 0;
        private static final int STATE_PLUGGED = 1;
        private static final int HAS_NO_MIC = 0;
        private static final int HAS_MIC = 1;

        private WiredHeadsetReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            int state = intent.getIntExtra("state", 0);
            int microphone = intent.getIntExtra("microphone", 0);
            String name = intent.getStringExtra("name");
            _AppRTCAudioManager.this.hasWiredHeadset = state == 1;
            _AppRTCAudioManager.this.updateAudioDeviceState();
        }
    }

    public static interface AudioManagerEvents {
        public void onAudioDeviceChanged(SendBirdCall.AudioDevice var1, Set<SendBirdCall.AudioDevice> var2);
    }

    public static enum AudioManagerState {
        UNINITIALIZED,
        PREINITIALIZED,
        RUNNING;

    }
}

