/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import android.support.annotation.NonNull;
import com.sendbird.call.Client;
import com.sendbird.call.Command;
import com.sendbird.call.CommandFactory;
import com.sendbird.call.ErrorResponse;
import com.sendbird.call.EventReceiver;
import com.sendbird.call.Logger;
import com.sendbird.call.ResponseHandler;
import com.sendbird.call.SendBirdCall;
import com.sendbird.call.SendBirdException;
import com.sendbird.call.WebSocketPushCommand;
import com.sendbird.call.WebSocketRequest;
import com.sendbird.call.WebSocketResponse;
import com.sendbird.call.shadow.okhttp3.OkHttpClient;
import com.sendbird.call.shadow.okhttp3.Request;
import com.sendbird.call.shadow.okhttp3.Response;
import com.sendbird.call.shadow.okhttp3.WebSocket;
import com.sendbird.call.shadow.okhttp3.WebSocketListener;
import com.sendbird.call.shadow.okio.ByteString;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

class WebSocketClient
implements Client {
    private static final int ACK_TIMEOUT_IN_MILLIS = 30000;
    private static final long RECONNECTION_BACK_OFF_PERIOD = 1000L;
    private String mSessionToken;
    private String mClientId;
    private EventReceiver mEventReceiver;
    private OkHttpClient mOkHttpClient;
    private WebSocket mWebSocket;
    private Request mRequest;
    private String mWebSocketHost;
    private ConnectionState mConnectionState = ConnectionState.CLOSED;
    private ExecutorService mWriteExecutor = Executors.newSingleThreadExecutor();
    private ExecutorService mReceiveExecutor = Executors.newSingleThreadExecutor();
    private boolean mExplicitDisconnect = false;
    private Map<String, AckHandler> mAckMap = new ConcurrentHashMap<String, AckHandler>();
    private WebSocketListener mWebSocketListener = new WebSocketListener(){
        private StringBuffer mRecvBuffer = new StringBuffer();

        public void onOpen(WebSocket webSocket, Response response) {
            Logger.d("[WebSocketClient] onOpen().");
            WebSocketClient.this.mConnectionState = ConnectionState.CONNECTED;
            if (WebSocketClient.this.mWebSocketOpenListener != null) {
                WebSocketClient.this.mWebSocketOpenListener.onConnected();
            }
        }

        public void onMessage(WebSocket webSocket, String text) {
            Logger.d("[WebSocketClient] onMessage(). Received text: " + text);
            WebSocketClient.this.mReceiveExecutor.execute(() -> WebSocketClient.this.onMessageReceived(text));
        }

        public void onMessage(WebSocket webSocket, ByteString bytes) {
            Logger.d("[WebSocketClient] onMessage(). bytes = " + bytes);
        }

        public void onClosing(WebSocket webSocket, int code, String reason) {
            Logger.d("[WebSocketClient] onClosing(code: " + code + ", reason: " + reason + ")");
            WebSocketClient.this.mConnectionState = ConnectionState.CLOSING;
            if (!WebSocketClient.this.mExplicitDisconnect) {
                WebSocketClient.this.reconnect();
            }
        }

        public void onClosed(WebSocket webSocket, int code, String reason) {
            Logger.d("[WebSocketClient] onClosed(code: " + code + ", reason: " + reason + ")");
            if (!WebSocketClient.this.mExplicitDisconnect) {
                WebSocketClient.this.reconnect();
            }
        }

        public void onFailure(WebSocket webSocket, Throwable t, Response response) {
            Logger.d("[WebSocketClient] onFailure(t: " + t.getMessage() + ")");
            if (!WebSocketClient.this.mExplicitDisconnect) {
                WebSocketClient.this.reconnect();
            }
        }
    };
    private WebSocketOpenListener mWebSocketOpenListener;

    WebSocketClient(@NonNull EventReceiver eventReceiver, @NonNull String webSocketHost, String clientId) {
        this.mEventReceiver = eventReceiver;
        this.mWebSocketHost = webSocketHost;
        this.mClientId = clientId;
    }

    @Override
    public void send(Command command, ResponseHandler handler) {
        if (!(command instanceof WebSocketRequest)) {
            if (handler != null) {
                handler.onResponse(null, SendBirdException.getSendBirdException(1800300));
            }
            return;
        }
        WebSocketRequest request = (WebSocketRequest)command;
        if (this.getConnectionState() == ConnectionState.CONNECTED) {
            if (handler != null && request.isAckRequired()) {
                this.mAckMap.put(request.getRequestId(), new AckHandler(request.getRequestId(), handler));
            }
            if (!this.mWriteExecutor.isShutdown()) {
                this.mWriteExecutor.execute(() -> {
                    Logger.d("[WebSocketClient] Send message: " + request.getClass().getSimpleName() + " " + request.getPayload());
                    this.mWebSocket.send(request.getPayload() + "\n");
                });
            }
        } else if (handler != null) {
            handler.onResponse(null, SendBirdException.getSendBirdExceptionWithMessage(1800204, "Connection closed."));
        }
    }

    @Override
    public void setSessionToken(String sessionToken) {
        this.mSessionToken = sessionToken;
    }

    void connect() {
        Logger.d("[WebSocketClient] connect(). currentState = " + (Object)((Object)this.getConnectionState()));
        if (this.getConnectionState() == ConnectionState.CONNECTED || this.getConnectionState() == ConnectionState.CONNECTING) {
            return;
        }
        if (this.mSessionToken == null) {
            Logger.e("[WebSocketClient] connect(). mSessionToken is null.");
            return;
        }
        this.mExplicitDisconnect = false;
        StringBuilder sb = new StringBuilder(this.mWebSocketHost);
        sb.append("/?sendbird_app_id=").append(SendBirdCall.getApplicationId()).append("&sbcall_session_token=").append(this.mSessionToken).append("&sbcall_client_id=").append(this.mClientId);
        this.mRequest = new Request.Builder().header("User-Agent", "v2oip-android/" + SendBirdCall.getSdkVersion()).header("Request-Sent-Timestamp", String.valueOf(System.currentTimeMillis())).url(sb.toString()).build();
        Logger.d("[WebSocketClient] WS request: " + sb.toString());
        this.mOkHttpClient = new OkHttpClient.Builder().readTimeout(0L, TimeUnit.MILLISECONDS).build();
        if (this.mWriteExecutor == null) {
            this.mWriteExecutor = Executors.newSingleThreadExecutor();
        }
        this.mConnectionState = ConnectionState.CONNECTING;
        this.mWebSocket = this.mOkHttpClient.newWebSocket(this.mRequest, this.mWebSocketListener);
        if (this.mOkHttpClient.dispatcher() != null) {
            this.mOkHttpClient.dispatcher().executorService().shutdown();
        }
    }

    void disconnect() {
        this.mExplicitDisconnect = true;
        this.quit();
    }

    ConnectionState getConnectionState() {
        return this.mConnectionState;
    }

    private void quit() {
        Logger.d("[WebSocketClient] quit() mExplicitDisconnect: " + this.mExplicitDisconnect);
        if (this.mWriteExecutor != null) {
            try {
                this.mWriteExecutor.shutdown();
                if (this.mExplicitDisconnect) {
                    this.mWriteExecutor.awaitTermination(10L, TimeUnit.SECONDS);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.mWriteExecutor = null;
            }
        }
        if (!this.mExplicitDisconnect && this.mWebSocket != null) {
            this.mWebSocket.cancel();
        }
        try {
            if (this.mWebSocket != null) {
                boolean isClosedGracefully = this.mWebSocket.close(1000, "");
                Logger.d("[WebSocketClient] isClosedGracefully: " + isClosedGracefully);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.mConnectionState = ConnectionState.CLOSED;
        this.mWebSocket = null;
        this.mOkHttpClient = null;
        this.mRequest = null;
        if (this.mExplicitDisconnect) {
            for (Map.Entry<String, AckHandler> entry : this.mAckMap.entrySet()) {
                AckHandler handler = entry.getValue();
                if (handler == null || handler.mResponseHandler == null) continue;
                this.mReceiveExecutor.execute(() -> handler.mResponseHandler.onResponse(null, SendBirdException.getSendBirdExceptionWithMessage(1800204, "WebSocket connection was closed.")));
            }
            this.mAckMap.clear();
        }
    }

    private void reconnect() {
        this.quit();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.connect();
    }

    private void onMessageReceived(String text) {
        Command command = CommandFactory.parseCallCommand((String)text);
        if (command == null) {
            Logger.e("[WebSocketClient] Failed to parse received text into Command");
            return;
        }
        if (command instanceof WebSocketResponse) {
            Logger.d("[WebSocketClient] received response: " + command.getClass().getSimpleName());
            WebSocketResponse wsResponse = (WebSocketResponse)command;
            AckHandler ackResponse = this.mAckMap.remove(wsResponse.getRequestId());
            if (ackResponse != null) {
                ackResponse.cancelAckTimer();
                ResponseHandler responseHandler = ackResponse.mResponseHandler;
                if (responseHandler != null) {
                    if (wsResponse instanceof ErrorResponse) {
                        responseHandler.onResponse((Command)wsResponse, SendBirdException.getSendBirdExceptionWithMessage(((ErrorResponse)wsResponse).getCode(), ((ErrorResponse)wsResponse).getMessage()));
                    } else {
                        responseHandler.onResponse(command, null);
                    }
                }
            }
        } else if (command instanceof WebSocketPushCommand) {
            Logger.d("[WebSocketClient] received event command: " + command.getClass().getSimpleName());
            WebSocketPushCommand pushCommand = (WebSocketPushCommand)command;
            this.mEventReceiver.onWebSocketCommandReceived(pushCommand);
        }
    }

    void setWebSocketOpenListener(WebSocketOpenListener listener) {
        this.mWebSocketOpenListener = listener;
    }

    static interface WebSocketOpenListener {
        public void onConnected();
    }

    private class AckHandler {
        String mRequestId;
        ResponseHandler mResponseHandler;
        Timer mTimer = new Timer();

        AckHandler(final String requestId, ResponseHandler responseHandler) {
            this.mRequestId = requestId;
            this.mResponseHandler = responseHandler;
            this.mTimer.schedule(new TimerTask(){

                @Override
                public void run() {
                    WebSocketClient.this.mAckMap.remove(AckHandler.this.mRequestId);
                    if (AckHandler.this.mResponseHandler != null) {
                        AckHandler.this.mResponseHandler.onResponse(null, SendBirdException.getSendBirdExceptionWithMessage(1800203, "Ack Timeout. requestId: " + requestId));
                    }
                }
            }, 30000L);
        }

        void cancelAckTimer() {
            this.mTimer.cancel();
        }
    }

    static enum ConnectionState {
        CLOSED,
        CLOSING,
        CONNECTING,
        CONNECTED;

    }
}

