/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.sendbird.call.ApiClient;
import com.sendbird.call.AuthenticateParams;
import com.sendbird.call.AuthenticateRequest;
import com.sendbird.call.AuthenticateResponse;
import com.sendbird.call.CallManager;
import com.sendbird.call.CallOptions;
import com.sendbird.call.Command;
import com.sendbird.call.CommandRouter;
import com.sendbird.call.CommandSender;
import com.sendbird.call.DirectCall;
import com.sendbird.call.DirectCallLogListQuery;
import com.sendbird.call.EventDispatcher;
import com.sendbird.call.EventReceiver;
import com.sendbird.call.Logger;
import com.sendbird.call.RegisterPushTokenRequest;
import com.sendbird.call.SendBirdCall;
import com.sendbird.call.SendBirdException;
import com.sendbird.call.UnregisterAllPushTokensRequest;
import com.sendbird.call.UnregisterPushTokenRequest;
import com.sendbird.call.User;
import com.sendbird.call.WebSocketClient;
import com.sendbird.call.handler.AuthenticateHandler;
import com.sendbird.call.handler.CompletionHandler;
import com.sendbird.call.handler.DialHandler;
import com.sendbird.call.handler.SendBirdCallListener;
import com.sendbird.call.shadow.com.google.gson.JsonObject;
import com.sendbird.call.shadow.com.google.gson.JsonParser;
import java.util.Map;
import java.util.UUID;

class SendBirdCallMain {
    @NonNull
    private CommandSender mCommandSender;
    @NonNull
    private EventReceiver mEventReceiver;
    @NonNull
    private CallManager mCallManager;
    private User mCurrentUser;
    private Context mContext;
    private String mAppId;
    private String mClientId;

    SendBirdCallMain(Context context, String appId) {
        this.init(context, appId);
    }

    SendBirdCallMain(Context context, String appId, String apiHost, String wsHost) {
        this.init(context, appId, apiHost, wsHost);
    }

    void init() {
        this.init(this.mContext, this.mAppId, this.getApiHost(this.mAppId), this.getWsHost(this.mAppId));
    }

    void init(Context context, String appId) {
        this.init(context, appId, this.getApiHost(appId), this.getWsHost(appId));
    }

    private void init(Context context, String appId, String apiHost, String wsHost) {
        this.mContext = context;
        this.mAppId = appId;
        this.mClientId = UUID.randomUUID().toString();
        EventDispatcher eventDispatcher = new EventDispatcher();
        this.mEventReceiver = new EventReceiver(context, eventDispatcher);
        this.mCommandSender = new CommandRouter(new ApiClient(apiHost, this.mClientId), new WebSocketClient(this.mEventReceiver, wsHost, this.mClientId));
        this.mCallManager = new CallManager(context, this.mCommandSender);
        eventDispatcher.listen(this.mCallManager);
    }

    User getCurrentUser() {
        return this.mCurrentUser;
    }

    DirectCall getCall(String callId) {
        Logger.d("[SendBirdCall] getCall(callId: " + callId + ")");
        return this.mCallManager.getCall(callId);
    }

    void authenticate(String appId, AuthenticateParams params, AuthenticateHandler handler) {
        if (TextUtils.isEmpty((CharSequence)appId) || params == null || params.mUserId == null) {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(null, SendBirdException.getSendBirdException(1800300)));
            }
            return;
        }
        if (this.getCurrentUser() != null && this.getCurrentUser().getUserId() != null && !TextUtils.equals((CharSequence)this.getCurrentUser().getUserId(), (CharSequence)params.mUserId)) {
            this.init();
        }
        AuthenticateRequest authenticateRequest = new AuthenticateRequest(appId, params.mUserId, params.mAccessToken, params.mPushToken, params.mIsUnique);
        this.mCommandSender.send((Command)authenticateRequest, (response, e) -> {
            if (e != null) {
                if (handler != null) {
                    SendBirdCall.runOnThreadOption(() -> handler.onResult(null, e));
                }
                return;
            }
            this.setSessionToken(((AuthenticateResponse)response).getSessionToken());
            this.setCurrentUser(((AuthenticateResponse)response).getCurrentUser());
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(this.mCurrentUser, null));
            }
        });
    }

    void deauthenticate(String pushToken, CompletionHandler handler) {
        if (this.getCurrentUser() == null) {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(SendBirdException.getSendBirdException(1800303)));
            }
            return;
        }
        if (!TextUtils.isEmpty((CharSequence)pushToken)) {
            this.unregisterPushToken(pushToken, e -> {
                this.deauthenticate();
                if (handler != null) {
                    SendBirdCall.runOnThreadOption(() -> handler.onResult(e));
                }
            });
        } else {
            this.deauthenticate();
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(null));
            }
        }
    }

    void deauthenticate() {
        this.mCallManager.endAllCalls();
        this.mCommandSender.destroy();
        this.setCurrentUser(null);
    }

    void registerPushToken(String pushToken, boolean unique, CompletionHandler handler) {
        if (pushToken == null) {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(SendBirdException.getSendBirdException(1800300)));
            }
            return;
        }
        if (this.getCurrentUser() == null) {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(SendBirdException.getSendBirdException(1800303)));
            }
            return;
        }
        RegisterPushTokenRequest registerPushTokenRequest = new RegisterPushTokenRequest(this.getCurrentUser().getUserId(), pushToken, unique);
        this.mCommandSender.send((Command)registerPushTokenRequest, (response, e) -> {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(e));
            }
        });
    }

    void unregisterPushToken(String pushToken, CompletionHandler handler) {
        if (pushToken == null && handler != null) {
            SendBirdCall.runOnThreadOption(() -> handler.onResult(SendBirdException.getSendBirdException(1800300)));
        }
        if (this.getCurrentUser() == null) {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(SendBirdException.getSendBirdException(1800303)));
            }
            return;
        }
        UnregisterPushTokenRequest unregisterPushTokenRequest = new UnregisterPushTokenRequest(this.getCurrentUser().getUserId(), pushToken);
        this.mCommandSender.send((Command)unregisterPushTokenRequest, (response, e) -> {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(e));
            }
        });
    }

    void unregisterAllPushTokens(CompletionHandler handler) {
        if (this.getCurrentUser() == null) {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(SendBirdException.getSendBirdException(1800303)));
            }
            return;
        }
        UnregisterAllPushTokensRequest unregisterAllPushTokensRequest = new UnregisterAllPushTokensRequest(this.getCurrentUser().getUserId());
        this.mCommandSender.send((Command)unregisterAllPushTokensRequest, (response, e) -> {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(e));
            }
        });
    }

    DirectCall dial(String calleeId, boolean isVideoCall, CallOptions callOptions, DialHandler handler) {
        if (calleeId == null) {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(null, SendBirdException.getSendBirdException(1800300)));
            }
            return null;
        }
        if (isVideoCall) {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(null, SendBirdException.getSendBirdExceptionWithMessage(1800300, "Video call is not supported.")));
            }
            return null;
        }
        if (this.getCurrentUser() == null) {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(null, SendBirdException.getSendBirdException(1800303)));
            }
            return null;
        }
        if (calleeId.equals(this.getCurrentUser().getUserId())) {
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(null, SendBirdException.getSendBirdExceptionWithMessage(1800300, "Tried to dial to current user.")));
            }
            return null;
        }
        if (callOptions == null) {
            callOptions = new CallOptions();
        }
        return this.mCallManager.dial(calleeId, isVideoCall, callOptions, handler);
    }

    void addListener(String identifier, SendBirdCallListener listener) {
        if (identifier == null || identifier.length() == 0 || listener == null) {
            return;
        }
        this.mCallManager.addSendBirdCallListener(identifier, listener);
    }

    SendBirdCallListener removeListener(String identifier) {
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        return this.mCallManager.removeSendBirdCallListener(identifier);
    }

    void removeAllListener() {
        this.mCallManager.removeAllSendBirdCallListeners();
    }

    boolean handleFirebaseMessageData(Map<String, String> data) {
        if (data.containsKey("sendbird_call")) {
            String payload = data.get("sendbird_call");
            try {
                boolean isMyCommand;
                JsonObject json = JsonParser.parseString((String)payload).getAsJsonObject();
                JsonObject command = json.has("command") ? json.get("command").getAsJsonObject() : null;
                String clientId = json.has("client_id") ? json.get("client_id").getAsString() : "";
                String receiverType = json.has("receiver_type") ? json.get("receiver_type").getAsString() : "";
                boolean bl = isMyCommand = receiverType.equals("user") || receiverType.equals("client") && this.mClientId.equals(clientId) || receiverType.equals("sibling") && !this.mClientId.equals(clientId);
                if (isMyCommand && command != null) {
                    this.mEventReceiver.onFcmPushMessageReceived(command);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        return false;
    }

    DirectCallLogListQuery createDirectCallLogListQuery(DirectCallLogListQuery.Params params) {
        if (params == null) {
            params = new DirectCallLogListQuery.Params();
        }
        return new DirectCallLogListQuery(this.mCommandSender, params, this.mCurrentUser.getUserId());
    }

    private void setSessionToken(String sessionToken) {
        this.mCommandSender.setSessionToken(sessionToken);
    }

    private void setCurrentUser(User user) {
        Logger.d("[SendBirdMain] setCurrentUser(" + (user != null ? user.getUserId() : "null") + ")");
        this.mCurrentUser = user;
    }

    private String getApiHost(String appId) {
        return "https://api-" + appId + ".v2oip.sendbird.com";
    }

    private String getWsHost(String appId) {
        return "wss://ws-" + appId + ".v2oip.sendbird.com";
    }

    void connectWebSocket(WebSocketClient.WebSocketOpenListener listener) {
        ((CommandRouter)this.mCommandSender).connectWebSocket(listener);
    }

    void disconnectWebSocket() {
        ((CommandRouter)this.mCommandSender).disconnectWebSocket();
    }

    void setApiOnlyMode(boolean enable) {
        ((CommandRouter)this.mCommandSender).setApiOnlyMode(enable);
    }

    void clearAllCalls() {
        this.mCallManager.clearAllCalls();
    }
}

