/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.sendbird.call.AuthenticateParams;
import com.sendbird.call.CallOptions;
import com.sendbird.call.DirectCall;
import com.sendbird.call.DirectCallLogListQuery;
import com.sendbird.call.Logger;
import com.sendbird.call.SendBirdCallMain;
import com.sendbird.call.SendBirdException;
import com.sendbird.call.User;
import com.sendbird.call.handler.AuthenticateHandler;
import com.sendbird.call.handler.CompletionHandler;
import com.sendbird.call.handler.DialHandler;
import com.sendbird.call.handler.SendBirdCallListener;
import java.util.Map;

public class SendBirdCall {
    private static final String VERSION = "0.6.0";
    public static final int LOGGER_NONE = 0;
    public static final int LOGGER_ERROR = 1;
    private static String sAppId = "";
    private static SendBirdCallMain sInstance;
    private static final Handler sUIThreadHandler;

    static void runOnThreadOption(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        switch (Options.mThreadOption) {
            case HANDLER: {
                if (Options.mHandlerForThreadOption == null) break;
                Options.mHandlerForThreadOption.post(runnable);
                break;
            }
            default: {
                SendBirdCall.runOnUIThread(runnable);
            }
        }
    }

    static void runOnUIThread(Runnable runnable) {
        sUIThreadHandler.post(runnable);
    }

    static synchronized SendBirdCallMain getInstance() {
        if (sInstance == null) {
            Logger.e("[SendBirdCall] SendBirdCall instance hasn't been initialized. Try init().");
            throw SendBirdException.getInitRuntimeException();
        }
        return sInstance;
    }

    public static String getSdkVersion() {
        return VERSION;
    }

    public static String getApplicationId() {
        return sAppId;
    }

    public static void setLoggerLevel(int level) {
        Logger.sLevel = level;
    }

    public static synchronized boolean init(Context context, String appId) {
        Logger.d("[SendBirdCall] init(appId: " + appId + ")");
        if (context == null || appId == null || appId.length() == 0) {
            Logger.e("[SendBirdCall] init() failed.");
            return false;
        }
        if (sInstance == null) {
            sAppId = appId;
            sInstance = new SendBirdCallMain(context, appId);
            return true;
        }
        if (!sAppId.equals(appId)) {
            sAppId = appId;
            sInstance.deauthenticate();
            sInstance.init(context, appId);
            return true;
        }
        return false;
    }

    private static synchronized void init() {
        Logger.d("[SendBirdCall] init()");
        if (sInstance != null) {
            sInstance.init();
        }
    }

    public static void authenticate(AuthenticateParams params, AuthenticateHandler handler) {
        Logger.d("[SendBirdCall] authenticate(userId: " + (params != null ? params.mUserId : "") + ")");
        SendBirdCall.getInstance().authenticate(sAppId, params, handler);
    }

    public static void deauthenticate(String pushToken, CompletionHandler handler) {
        Logger.d("[SendBirdCall] deauthenticate()");
        SendBirdCall.getInstance().deauthenticate(pushToken, handler);
    }

    public static User getCurrentUser() {
        return SendBirdCall.getInstance().getCurrentUser();
    }

    public static void registerPushToken(String pushToken, boolean unique, CompletionHandler handler) {
        Logger.d("[SendBirdCall] registerPushToken(pushToken: " + pushToken + ", unique: " + unique + ")");
        SendBirdCall.getInstance().registerPushToken(pushToken, unique, handler);
    }

    public static void unregisterPushToken(String pushToken, CompletionHandler handler) {
        Logger.d("[SendBirdCall] unregisterPushToken(pushToken: " + pushToken + ")");
        SendBirdCall.getInstance().unregisterPushToken(pushToken, handler);
    }

    public static void unregisterAllPushTokens(CompletionHandler handler) {
        Logger.d("[SendBirdCall] unregisterAllPushTokens()");
        SendBirdCall.getInstance().unregisterAllPushTokens(handler);
    }

    public static void addListener(String identifier, SendBirdCallListener listener) {
        Logger.d("[SendBirdCall] addListener(" + identifier + ")");
        SendBirdCall.getInstance().addListener(identifier, listener);
    }

    public static SendBirdCallListener removeListener(String identifier) {
        Logger.d("[SendBirdCall] removeListener(" + identifier + ")");
        if (identifier == null || identifier.length() == 0) {
            return null;
        }
        return SendBirdCall.getInstance().removeListener(identifier);
    }

    public static void removeAllListeners() {
        Logger.d("[SendBirdCall] removeAllListeners()");
        SendBirdCall.getInstance().removeAllListener();
    }

    public static DirectCall dial(String calleeId, boolean isVideoCall, CallOptions callOptions, DialHandler handler) {
        Logger.d("[SendBirdCall] dial()");
        return SendBirdCall.getInstance().dial(calleeId, isVideoCall, callOptions, handler);
    }

    public static boolean handleFirebaseMessageData(Map<String, String> data) {
        Logger.d("[SendBirdCall] handleFirebaseMessageData()");
        return SendBirdCall.getInstance().handleFirebaseMessageData(data);
    }

    public static DirectCall getCall(String callId) {
        Logger.d("[SendBirdCall] getCall(callId: " + callId + ")");
        return SendBirdCall.getInstance().getCall(callId);
    }

    public static DirectCallLogListQuery createDirectCallLogListQuery(DirectCallLogListQuery.Params params) {
        Logger.d("[SendBirdCall] createDirectCallLogListQuery()");
        return SendBirdCall.getInstance().createDirectCallLogListQuery(params);
    }

    static void setAppId(String appId) {
        sAppId = appId;
    }

    static {
        sUIThreadHandler = new Handler(Looper.getMainLooper());
    }

    public static class Options {
        static ThreadOption mThreadOption = ThreadOption.UI_THREAD;
        static Handler mHandlerForThreadOption;

        public static void setThreadOption(ThreadOption threadOption, Handler handler) {
            if (threadOption != null) {
                mThreadOption = threadOption;
                if (threadOption == ThreadOption.HANDLER) {
                    mHandlerForThreadOption = handler;
                }
            }
        }

        public static enum ThreadOption {
            UI_THREAD,
            HANDLER;

        }
    }

    static enum AudioDevice {
        SPEAKER_PHONE,
        WIRED_HEADSET,
        EARPIECE,
        BLUETOOTH,
        NONE;

    }
}

