/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import android.support.annotation.NonNull;
import com.sendbird.call.RtcInboundRtpStreamStat;
import com.sendbird.call.RtcOutboundRtpStreamStat;
import com.sendbird.call.RtcRemoteInboundRtpStreamStat;
import com.sendbird.call.RtcRtpStreamStat;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.webrtc.RTCStats;

class RtpPacketMonitor {
    private static final int PACKET_LOST_TIMEOUT_IN_SECOND = 60;
    private static final long ONE_SECOND_IN_MICRO_SECOND = 1000000L;
    private Map<Long, PacketReceivedInfo> mRtcRtpStreamStatsMap = new ConcurrentHashMap<Long, PacketReceivedInfo>();
    private PacketLossListener mListener;

    RtpPacketMonitor(@NonNull PacketLossListener listener) {
        this.mListener = listener;
    }

    void append(Map<String, RTCStats> rtcStatsMap) {
        List<RtcRtpStreamStat> rtcRtpStreamStats = this.parseStatsMap(rtcStatsMap);
        for (RtcRtpStreamStat rtcRtpStreamStat : rtcRtpStreamStats) {
            if (!(rtcRtpStreamStat instanceof RtcInboundRtpStreamStat)) continue;
            long ssrc = rtcRtpStreamStat.getSsrc();
            double lastPacketReceivedTimestamp = ((RtcInboundRtpStreamStat)rtcRtpStreamStat).getLastPacketReceivedTimestamp();
            PacketReceivedInfo packetReceivedInfo = new PacketReceivedInfo(rtcRtpStreamStat.getTimestamp(), lastPacketReceivedTimestamp);
            if (this.mRtcRtpStreamStatsMap.containsKey(ssrc)) {
                PacketReceivedInfo lastPacketReceivedInfo = this.mRtcRtpStreamStatsMap.get(ssrc);
                if (lastPacketReceivedInfo.getLastPacketReceivedTimestamp() == packetReceivedInfo.getLastPacketReceivedTimestamp()) {
                    if (packetReceivedInfo.getTimestamp() - lastPacketReceivedInfo.getTimestamp() <= 60000000L) continue;
                    this.mRtcRtpStreamStatsMap.remove(ssrc);
                    this.mListener.onPacketLost();
                    continue;
                }
                this.mRtcRtpStreamStatsMap.put(ssrc, packetReceivedInfo);
                continue;
            }
            this.mRtcRtpStreamStatsMap.put(ssrc, packetReceivedInfo);
        }
    }

    private List<RtcRtpStreamStat> parseStatsMap(Map<String, RTCStats> rtcStatsMap) {
        ArrayList<RtcRtpStreamStat> stats = new ArrayList<RtcRtpStreamStat>();
        if (rtcStatsMap == null) {
            return stats;
        }
        for (String key : rtcStatsMap.keySet()) {
            RTCStats rtcStats = rtcStatsMap.get(key);
            if (rtcStats == null) continue;
            long timestamp = Double.valueOf(rtcStats.getTimestampUs()).longValue();
            String type = rtcStats.getType();
            if (!type.equals("inbound-rtp") && !type.equals("outbound-rtp") && !type.equals("remote-inbound-rtp")) continue;
            try {
                Map members = rtcStats.getMembers();
                String kind = (String)members.get("kind");
                long ssrc = (Long)members.get("ssrc");
                boolean isAudio = kind.equals("audio");
                switch (type) {
                    case "inbound-rtp": {
                        if (!members.containsKey("lastPacketReceivedTimestamp")) break;
                        long packetsReceived = (Long)members.get("packetsReceived");
                        long bytesReceived = ((BigInteger)members.get("bytesReceived")).longValue();
                        int packetsLost = (Integer)members.get("packetsLost");
                        double lastPacketReceivedTimestamp = (Double)members.get("lastPacketReceivedTimestamp");
                        stats.add(new RtcInboundRtpStreamStat(timestamp, ssrc, isAudio, packetsReceived, bytesReceived, packetsLost, lastPacketReceivedTimestamp));
                        break;
                    }
                    case "outbound-rtp": {
                        long packetsSent = (Long)members.get("packetsSent");
                        long bytesSent = ((BigInteger)members.get("bytesSent")).longValue();
                        long retransmittedPacketsSent = ((BigInteger)members.get("retransmittedPacketsSent")).longValue();
                        long retransmittedBytesSent = ((BigInteger)members.get("retransmittedBytesSent")).longValue();
                        stats.add(new RtcOutboundRtpStreamStat(timestamp, ssrc, isAudio, packetsSent, bytesSent, retransmittedPacketsSent, retransmittedBytesSent));
                        break;
                    }
                    case "remote-inbound-rtp": {
                        int remoteInboundPacketsLost = (Integer)members.get("packetsLost");
                        double roundTripTime = (Double)members.get("roundTripTime");
                        stats.add(new RtcRemoteInboundRtpStreamStat(timestamp, ssrc, isAudio, remoteInboundPacketsLost, roundTripTime));
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return stats;
    }

    static interface PacketLossListener {
        public void onPacketLost();
    }

    private class PacketReceivedInfo {
        private long mTimestamp;
        private double mLastPacketReceivedTimestamp;

        private PacketReceivedInfo(long monitoredTimestamp, double lastPacketReceivedTimestamp) {
            this.mTimestamp = monitoredTimestamp;
            this.mLastPacketReceivedTimestamp = lastPacketReceivedTimestamp;
        }

        private long getTimestamp() {
            return this.mTimestamp;
        }

        private double getLastPacketReceivedTimestamp() {
            return this.mLastPacketReceivedTimestamp;
        }
    }
}

