/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.media.projection.MediaProjection;
import com.sendbird.call.CallOptions;
import com.sendbird.call.Logger;
import com.sendbird.call.SendBirdCall;
import com.sendbird.call.SendBirdVideoView;
import com.sendbird.call._AppRTCAudioManager;
import com.sendbird.call._PeerConnectionClient;
import com.sendbird.call.handler.CompletionHandler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.webrtc.Camera1Enumerator;
import org.webrtc.Camera2Enumerator;
import org.webrtc.CameraEnumerator;
import org.webrtc.CameraVideoCapturer;
import org.webrtc.EglBase;
import org.webrtc.FileVideoCapturer;
import org.webrtc.IceCandidate;
import org.webrtc.PeerConnection;
import org.webrtc.PeerConnectionFactory;
import org.webrtc.ScreenCapturerAndroid;
import org.webrtc.SessionDescription;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoFileRenderer;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;

class PeerConnectionClient {
    private static final int STAT_CALLBACK_PERIOD_MS = 1000;
    private ProxyVideoSink mRemoteProxyVideoSink = new ProxyVideoSink();
    private ProxyVideoSink mLocalProxyVideoSink = new ProxyVideoSink();
    private List<VideoSink> mRemoteSinks = new ArrayList<VideoSink>();
    private VideoFileRenderer mRemoteVideoFileRenderer;
    private _PeerConnectionClient mPeerConnectionClient;
    private _AppRTCAudioManager mAudioManager;
    private SendBirdVideoView mLocalVideoView;
    private SendBirdVideoView mRemoteVideoView;
    private boolean mIsSwappedFeeds;

    PeerConnectionClient(Context context, boolean isVideoCall, CallOptions callOptions, List<PeerConnection.IceServer> iceServers, _PeerConnectionClient.PeerConnectionEvents peerConnectionEvents) {
        this.mPeerConnectionClient = this.ready(context, isVideoCall, callOptions, iceServers, peerConnectionEvents);
    }

    private _PeerConnectionClient ready(Context context, boolean isVideoCall, CallOptions callOptions, List<PeerConnection.IceServer> iceServers, _PeerConnectionClient.PeerConnectionEvents peerConnectionEvents) {
        EglBase eglBase = EglBase.create();
        SendBirdCall.runOnUIThread(() -> this.initViewRenderers(callOptions, eglBase));
        _PeerConnectionClient peerConnectionClient = this.createPeerConnectionClient(context, isVideoCall, callOptions, eglBase, iceServers, peerConnectionEvents);
        this.setStartOptions(callOptions);
        SendBirdCall.runOnUIThread(() -> this.startAudioManager(context, isVideoCall));
        return peerConnectionClient;
    }

    private void initViewRenderers(CallOptions callOptions, EglBase eglBase) {
        Logger.d("[PeerConnectionClient] initViewRenderers()");
        this.mLocalVideoView = callOptions.mLocalVideoView;
        this.mRemoteVideoView = callOptions.mRemoteVideoView;
        if (this.mLocalVideoView != null) {
            this.mLocalVideoView.init(eglBase.getEglBaseContext(), null);
        }
        if (this.mRemoteVideoView != null) {
            this.mRemoteVideoView.init(eglBase.getEglBaseContext(), null);
        }
        this.mRemoteSinks.clear();
        this.mRemoteSinks.add(this.mRemoteProxyVideoSink);
        this.setSwappedFeeds(false);
    }

    private void setSwappedFeeds(boolean isSwappedFeeds) {
        this.mIsSwappedFeeds = isSwappedFeeds;
        this.mLocalProxyVideoSink.setTarget((VideoSink)(isSwappedFeeds ? this.mRemoteVideoView : this.mLocalVideoView));
        this.mRemoteProxyVideoSink.setTarget((VideoSink)(isSwappedFeeds ? this.mLocalVideoView : this.mRemoteVideoView));
        if (this.mLocalVideoView != null) {
            this.mLocalVideoView.setMirror(!isSwappedFeeds);
        }
        if (this.mRemoteVideoView != null) {
            this.mRemoteVideoView.setMirror(isSwappedFeeds);
        }
    }

    private _PeerConnectionClient createPeerConnectionClient(Context context, boolean isVideoCall, CallOptions options, EglBase eglBase, List<PeerConnection.IceServer> iceServers, _PeerConnectionClient.PeerConnectionEvents peerConnectionEvents) {
        Logger.d("[PeerConnectionClient] createPeerConnectionClient()");
        boolean videoCallEnabled = isVideoCall;
        int videoWidth = options.mVideoWidth;
        int videoHeight = options.mVideoHeight;
        int videoFps = options.mVideoFps;
        boolean videoMaxBitrate = false;
        String videoCodec = "VP8";
        boolean videoCodecHwAcceleration = true;
        boolean videoFlexFecEnabled = false;
        boolean audioStartBitrate = false;
        String audioCodec = "OPUS";
        boolean noAudioProcessing = false;
        boolean aecDump = false;
        boolean saveInputAudioToFile = false;
        boolean useOpenSLES = false;
        boolean disableBuiltInAEC = false;
        boolean disableBuiltInAGC = false;
        boolean disableBuiltInNS = false;
        boolean disableWebRtcAGCAndHPF = false;
        _PeerConnectionClient.DataChannelParameters dataChannelParameters = null;
        boolean loopback = false;
        boolean tracing = false;
        boolean enableRtcEventLog = false;
        _PeerConnectionClient.PeerConnectionParameters mPeerConnectionParameters = new _PeerConnectionClient.PeerConnectionParameters(videoCallEnabled, false, false, videoWidth, videoHeight, videoFps, 0, "VP8", true, false, 0, "OPUS", false, false, false, false, false, false, false, false, false, dataChannelParameters);
        this.mPeerConnectionClient = new _PeerConnectionClient(context, eglBase, mPeerConnectionParameters, peerConnectionEvents);
        VideoCapturer videoCapturer = null;
        videoCapturer = this.createVideoCapturer(context, options.mFrontCamera, null);
        this.mPeerConnectionClient.createPeerConnectionFactory(new PeerConnectionFactory.Options());
        this.mPeerConnectionClient.createPeerConnection((VideoSink)this.mLocalProxyVideoSink, this.mRemoteSinks, videoCapturer, iceServers);
        return this.mPeerConnectionClient;
    }

    @TargetApi(value=21)
    private VideoCapturer createScreenCapturer(Intent screenCaptureIntent) {
        return new ScreenCapturerAndroid(screenCaptureIntent, new MediaProjection.Callback(){

            public void onStop() {
                Logger.d("[PeerConnectionClient] User revoked permission to capture the screen.");
            }
        });
    }

    private VideoCapturer createVideoCapturer(Context context, boolean useFrontCamera, File videoFileAsCamera) {
        FileVideoCapturer videoCapturer;
        if (videoFileAsCamera != null) {
            try {
                videoCapturer = new FileVideoCapturer(videoFileAsCamera.getPath());
            }
            catch (IOException e) {
                return null;
            }
        } else {
            videoCapturer = Camera2Enumerator.isSupported((Context)context) ? this.createCameraCapturer((CameraEnumerator)new Camera2Enumerator(context), useFrontCamera) : this.createCameraCapturer((CameraEnumerator)new Camera1Enumerator(true), useFrontCamera);
        }
        return videoCapturer;
    }

    private VideoCapturer createCameraCapturer(CameraEnumerator enumerator, boolean useFrontCamera) {
        String[] deviceNames = enumerator.getDeviceNames();
        if (useFrontCamera) {
            CameraVideoCapturer videoCapturer;
            for (String deviceName : deviceNames) {
                if (!enumerator.isFrontFacing(deviceName) || (videoCapturer = enumerator.createCapturer(deviceName, null)) == null) continue;
                return videoCapturer;
            }
            for (String deviceName : deviceNames) {
                if (enumerator.isFrontFacing(deviceName) || (videoCapturer = enumerator.createCapturer(deviceName, null)) == null) continue;
                return videoCapturer;
            }
        } else {
            CameraVideoCapturer videoCapturer;
            for (String deviceName : deviceNames) {
                if (!enumerator.isBackFacing(deviceName) || (videoCapturer = enumerator.createCapturer(deviceName, null)) == null) continue;
                return videoCapturer;
            }
            for (String deviceName : deviceNames) {
                if (enumerator.isBackFacing(deviceName) || (videoCapturer = enumerator.createCapturer(deviceName, null)) == null) continue;
                return videoCapturer;
            }
        }
        return null;
    }

    private void setStartOptions(CallOptions callOptions) {
        this.setVideoEnabled(callOptions.mVideoEnabled);
        this.setAudioEnabled(callOptions.mAudioEnabled);
    }

    private void startAudioManager(Context context, boolean isVideoCall) {
        Logger.d("[PeerConnectionClient] startAudioManager()");
        this.mAudioManager = _AppRTCAudioManager.create(context);
        this.mAudioManager.start(new _AppRTCAudioManager.AudioManagerEvents(){

            @Override
            public void onAudioDeviceChanged(SendBirdCall.AudioDevice audioDevice, Set<SendBirdCall.AudioDevice> availableAudioDevices) {
            }
        });
        if (!isVideoCall) {
            this.mAudioManager.setDefaultAudioDevice(SendBirdCall.AudioDevice.EARPIECE);
        }
    }

    void enableStatsEvents() {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.enableStatsEvents(true, 1000);
        }
    }

    void createOffer() {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.createOffer();
        }
    }

    void createAnswer() {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.createAnswer();
        }
    }

    void setRemoteDescription(SessionDescription sessionDescription) {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.setRemoteDescription(sessionDescription);
        }
    }

    void addRemoteIceCandidate(IceCandidate iceCandidate) {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.addRemoteIceCandidate(iceCandidate);
        }
    }

    void removeRemoteIceCandidates(IceCandidate[] iceCandidates) {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.removeRemoteIceCandidates(iceCandidates);
        }
    }

    void setVideoEnabled(boolean isEnabled) {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.setVideoEnabled(isEnabled);
        }
    }

    void setAudioEnabled(boolean isEnabled) {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.setAudioEnabled(isEnabled);
        }
    }

    void switchCamera(CompletionHandler handler) {
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.switchCamera(e -> {
                if (handler != null) {
                    SendBirdCall.runOnThreadOption(() -> handler.onResult(e));
                }
            });
        }
    }

    void toggleSwappedFeeds() {
        this.setSwappedFeeds(!this.mIsSwappedFeeds);
    }

    void close() {
        this.mIsSwappedFeeds = false;
        if (this.mRemoteProxyVideoSink != null) {
            this.mRemoteProxyVideoSink.setTarget(null);
        }
        if (this.mLocalProxyVideoSink != null) {
            this.mLocalProxyVideoSink.setTarget(null);
        }
        if (this.mLocalVideoView != null) {
            this.mLocalVideoView.release();
            this.mLocalVideoView = null;
        }
        if (this.mRemoteVideoView != null) {
            this.mRemoteVideoView.release();
            this.mRemoteVideoView = null;
        }
        if (this.mRemoteVideoFileRenderer != null) {
            this.mRemoteVideoFileRenderer.release();
            this.mRemoteVideoFileRenderer = null;
        }
        if (this.mAudioManager != null) {
            SendBirdCall.runOnUIThread(() -> {
                this.mAudioManager.stop();
                this.mAudioManager = null;
            });
        }
        this.mPeerConnectionClient.close();
    }

    private static class ProxyVideoSink
    implements VideoSink {
        private VideoSink mTarget;

        private ProxyVideoSink() {
        }

        public synchronized void onFrame(VideoFrame frame) {
            if (this.mTarget == null) {
                return;
            }
            this.mTarget.onFrame(frame);
        }

        synchronized void setTarget(VideoSink target) {
            this.mTarget = target;
        }
    }
}

