/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import android.support.annotation.NonNull;
import com.sendbird.call.DirectCall;
import com.sendbird.call.DirectCallClosingState;
import com.sendbird.call.DirectCallConnectedState;
import com.sendbird.call.DirectCallState;
import com.sendbird.call.TimeoutRequest;
import org.webrtc.SessionDescription;

class DirectCallOfferingState
extends DirectCallState {
    private boolean mIsAnswerReceived = false;

    DirectCallOfferingState() {
    }

    @Override
    @NonNull
    String getStateName() {
        return DirectCallOfferingState.class.getSimpleName();
    }

    @Override
    void onCreate(DirectCall call) {
        call.startStateTimer(this.getTimerDelay());
        call.dispatchEvent(DirectCall.DirectCallEventType.ESTABLISHED);
        call.createOffer();
    }

    @Override
    void onDestroy(DirectCall call) {
        call.stopStateTimer();
    }

    @Override
    void onAnswerReceived(DirectCall call, String sdp) {
        super.onAnswerReceived(call, sdp);
        this.mIsAnswerReceived = true;
        call.updateStartTimestamp();
        call.setRemoteDescription(SessionDescription.Type.ANSWER, sdp);
    }

    @Override
    void onWebRtcConnected(DirectCall call) {
        super.onWebRtcConnected(call);
        call.changeState(new DirectCallConnectedState());
    }

    @Override
    void end(DirectCall call) {
        super.end(call);
        call.sendEndRequest();
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void unknownEnd(DirectCall call) {
        super.unknownEnd(call);
        call.sendUnknownEndRequest();
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void timeout(DirectCall call) {
        super.timeout(call);
        if (this.mIsAnswerReceived) {
            call.sendTimeoutRequest(TimeoutRequest.Reason.WEBRTC_NOT_CONNECTED);
        } else {
            call.sendTimeoutRequest(TimeoutRequest.Reason.ANSWER_NOT_RECEIVED);
        }
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onDeclineReceived(DirectCall call) {
        super.onDeclineReceived(call);
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onEndReceived(DirectCall call) {
        super.onEndReceived(call);
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onTimeoutReceived(DirectCall call) {
        super.onTimeoutReceived(call);
        call.changeState(new DirectCallClosingState());
    }
}

