/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import android.support.annotation.NonNull;
import com.sendbird.call.ConnectionLostRequest;
import com.sendbird.call.DirectCall;
import com.sendbird.call.DirectCallClosingState;
import com.sendbird.call.DirectCallState;

class DirectCallConnectedState
extends DirectCallState {
    DirectCallConnectedState() {
    }

    @Override
    @NonNull
    String getStateName() {
        return DirectCallConnectedState.class.getSimpleName();
    }

    @Override
    void onCreate(DirectCall call) {
        call.dispatchEvent(DirectCall.DirectCallEventType.CONNECTED);
    }

    @Override
    void onDestroy(DirectCall call) {
    }

    @Override
    void end(DirectCall call) {
        super.end(call);
        call.sendEndRequest();
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void unknownEnd(DirectCall call) {
        super.unknownEnd(call);
        call.sendUnknownEndRequest();
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onEndReceived(DirectCall call) {
        super.onEndReceived(call);
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onPacketLost(DirectCall call) {
        super.onPacketLost(call);
        call.sendConnectionLostRequest(ConnectionLostRequest.Reason.PEER_STREAM_LOST);
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onConnectionLostReceived(DirectCall call) {
        super.onConnectionLostReceived(call);
        call.changeState(new DirectCallClosingState());
    }
}

