/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import android.support.annotation.NonNull;
import com.sendbird.call.DirectCall;
import com.sendbird.call.DirectCallClosingState;
import com.sendbird.call.DirectCallConnectedState;
import com.sendbird.call.DirectCallState;
import com.sendbird.call.TimeoutRequest;
import org.webrtc.SessionDescription;

class DirectCallAnsweringState
extends DirectCallState {
    private String mSdp;
    private boolean mIsOfferReceived;

    DirectCallAnsweringState(String sdp) {
        this.mSdp = sdp;
        this.mIsOfferReceived = sdp != null;
    }

    @Override
    @NonNull
    String getStateName() {
        return DirectCallAnsweringState.class.getSimpleName();
    }

    @Override
    void onCreate(DirectCall call) {
        call.startStateTimer(this.getTimerDelay());
        call.updateStartTimestamp();
        call.dispatchEvent(DirectCall.DirectCallEventType.ESTABLISHED);
        if (this.mSdp != null) {
            call.setRemoteDescription(SessionDescription.Type.OFFER, this.mSdp);
            call.createAnswer();
        }
    }

    @Override
    void onDestroy(DirectCall call) {
        call.stopStateTimer();
    }

    @Override
    void onOfferReceived(DirectCall call, String sdp) {
        super.onOfferReceived(call, sdp);
        this.mIsOfferReceived = true;
        call.setRemoteDescription(SessionDescription.Type.OFFER, sdp);
        call.createAnswer();
    }

    @Override
    void onWebRtcConnected(DirectCall call) {
        super.onWebRtcConnected(call);
        call.changeState(new DirectCallConnectedState());
    }

    @Override
    void end(DirectCall call) {
        super.end(call);
        call.sendEndRequest();
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void unknownEnd(DirectCall call) {
        super.unknownEnd(call);
        call.sendUnknownEndRequest();
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void timeout(DirectCall call) {
        super.timeout(call);
        if (this.mIsOfferReceived) {
            call.sendTimeoutRequest(TimeoutRequest.Reason.WEBRTC_NOT_CONNECTED);
        } else {
            call.sendTimeoutRequest(TimeoutRequest.Reason.OFFER_NOT_RECEIVED);
        }
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onEndReceived(DirectCall call) {
        super.onEndReceived(call);
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onCancelReceived(DirectCall call) {
        super.onCancelReceived(call);
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onDeclineReceived(DirectCall call) {
        super.onDeclineReceived(call);
        call.changeState(new DirectCallClosingState());
    }

    @Override
    void onTimeoutReceived(DirectCall call) {
        super.onTimeoutReceived(call);
        call.changeState(new DirectCallClosingState());
    }
}

