/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import android.content.Context;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.sendbird.call.AcceptPushCommand;
import com.sendbird.call.AcceptRequest;
import com.sendbird.call.AliveRequest;
import com.sendbird.call.AnswerPushCommand;
import com.sendbird.call.AnswerRequest;
import com.sendbird.call.AudioStatusPushCommand;
import com.sendbird.call.AudioStatusRequest;
import com.sendbird.call.BaseCall;
import com.sendbird.call.CallOptions;
import com.sendbird.call.CancelPushCommand;
import com.sendbird.call.CancelRequest;
import com.sendbird.call.CancelResponse;
import com.sendbird.call.Candidate;
import com.sendbird.call.CandidatePushCommand;
import com.sendbird.call.CandidateRequest;
import com.sendbird.call.Command;
import com.sendbird.call.CommandSender;
import com.sendbird.call.ConnectionLostPushCommand;
import com.sendbird.call.ConnectionLostRequest;
import com.sendbird.call.ConnectionLostResponse;
import com.sendbird.call.Constraints;
import com.sendbird.call.DeclinePushCommand;
import com.sendbird.call.DeclineRequest;
import com.sendbird.call.DeclineResponse;
import com.sendbird.call.DialPushCommand;
import com.sendbird.call.DialRequest;
import com.sendbird.call.DialResponse;
import com.sendbird.call.DirectCallCanceledState;
import com.sendbird.call.DirectCallConnectedState;
import com.sendbird.call.DirectCallEndResult;
import com.sendbird.call.DirectCallEndedState;
import com.sendbird.call.DirectCallEndingState;
import com.sendbird.call.DirectCallIdleState;
import com.sendbird.call.DirectCallLog;
import com.sendbird.call.DirectCallRingingState;
import com.sendbird.call.DirectCallState;
import com.sendbird.call.DirectCallUser;
import com.sendbird.call.DirectCallUserRole;
import com.sendbird.call.EndPushCommand;
import com.sendbird.call.EndRequest;
import com.sendbird.call.EndResponse;
import com.sendbird.call.Logger;
import com.sendbird.call.NoAnswerPushCommand;
import com.sendbird.call.NoAnswerRequest;
import com.sendbird.call.NoAnswerResponse;
import com.sendbird.call.OfferPushCommand;
import com.sendbird.call.OfferRequest;
import com.sendbird.call.OtherDeviceAcceptedPushCommand;
import com.sendbird.call.PeerConnectionClient;
import com.sendbird.call.PeerConnectionClientFactory;
import com.sendbird.call.RemoveCandidatesPushCommand;
import com.sendbird.call.RemoveCandidatesRequest;
import com.sendbird.call.RingingListener;
import com.sendbird.call.SendBirdCall;
import com.sendbird.call.StringUtils;
import com.sendbird.call.TimeoutPushCommand;
import com.sendbird.call.TimeoutRequest;
import com.sendbird.call.TimeoutResponse;
import com.sendbird.call.TurnCredential;
import com.sendbird.call.UnknownEndPushCommand;
import com.sendbird.call.UnknownEndRequest;
import com.sendbird.call.UnknownEndResponse;
import com.sendbird.call.VideoStatusPushCommand;
import com.sendbird.call._PeerConnectionClient;
import com.sendbird.call.handler.DialHandler;
import com.sendbird.call.handler.DirectCallListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.webrtc.IceCandidate;
import org.webrtc.PeerConnection;
import org.webrtc.SessionDescription;
import org.webrtc.StatsReport;

public class DirectCall
extends BaseCall {
    private static final boolean ENABLE_STATS_EVENTS = true;
    private static final long ALIVE_INTERVAL = 10000L;
    private Context mContext;
    private CommandSender mCommandSender;
    private RingingListener mRingingListener;
    private CallOptions mCallOptions;
    private boolean mIsVideoCall;
    private boolean mAmICallee;
    private DirectCallUserRole mMyRole;
    private String mCallId;
    private DirectCallUser mCaller;
    private DirectCallUser mCallee;
    private TurnCredential mTurnCredential;
    private PeerConnectionClient mPeerConnectionClient;
    private long mStartTimestamp = 0L;
    private long mEndTimestamp = 0L;
    private DirectCallEndResult mEndResult = DirectCallEndResult.NONE;
    private DirectCallUser mEndedBy;
    private long mDuration;
    private DirectCallState mCurrentState;
    private Timer mStateTimer = new Timer();
    private Timer mAliveTimer = new Timer();
    private DirectCallListener mListener;
    private boolean mIsLocalVideoEnabled = true;
    private boolean mIsRemoteVideoEnabled = true;
    private boolean mIsLocalAudioEnabled = true;
    private boolean mIsRemoteAudioEnabled = true;
    private _PeerConnectionClient.PeerConnectionEvents mPeerConnectionEvents = new _PeerConnectionClient.PeerConnectionEvents(){
        private boolean mIceConnected;
        private boolean mConnected;
        private boolean mDisconnected;

        private void connected() {
            if (this.mDisconnected) {
                this.mDisconnected = false;
                Logger.d(DirectCall.this.tag() + "reconnected(callId: " + DirectCall.this.mCallId + ")");
                DirectCall.this.dispatchEvent(DirectCallEventType.RECONNECTED);
            } else {
                Logger.d(DirectCall.this.tag() + "connected(callId: " + DirectCall.this.mCallId + ")");
                DirectCall.this.mCurrentState.onWebRtcConnected(DirectCall.this);
            }
            if (DirectCall.this.mPeerConnectionClient != null) {
                DirectCall.this.mPeerConnectionClient.enableStatsEvents();
            }
        }

        private void disconnected() {
            Logger.d(DirectCall.this.tag() + "disconnected(callId: " + DirectCall.this.mCallId + ")");
            this.mDisconnected = true;
            DirectCall.this.dispatchEvent(DirectCallEventType.DISCONNECTED);
        }

        @Override
        public void onLocalDescription(boolean isInitiator, SessionDescription sdp) {
            Logger.d(DirectCall.this.tag() + "[PCE] onLocalDescription()");
            if (sdp != null && sdp.description != null) {
                StringUtils.compress(sdp.description, result -> {
                    if (result != null && result.length() > 0) {
                        if (isInitiator) {
                            DirectCall.this.sendOfferRequest(result);
                        } else {
                            DirectCall.this.sendAnswerRequest(result);
                        }
                    }
                });
            }
        }

        @Override
        public void onIceCandidate(IceCandidate candidate) {
            Logger.d(DirectCall.this.tag() + "[PCE] onIceCandidate(" + (candidate != null ? candidate.toString() : null) + ")");
            if (candidate != null && candidate.sdp != null && candidate.sdp.contains("typ relay")) {
                DirectCall.this.sendCandidateRequest(candidate);
            }
        }

        @Override
        public void onIceCandidatesRemoved(IceCandidate[] candidates) {
            Logger.d(DirectCall.this.tag() + "[PCE] onIceCandidatesRemoved(" + (candidates != null ? candidates.length : 0) + ")");
            if (candidates != null) {
                DirectCall.this.sendRemoveCandidatesRequest(candidates);
            }
        }

        @Override
        public void onIceConnected() {
            Logger.d(DirectCall.this.tag() + "[PCE] onIceConnected()");
            this.mIceConnected = true;
            if (this.mConnected) {
                this.connected();
            }
        }

        @Override
        public void onConnected() {
            Logger.d(DirectCall.this.tag() + "[PCE] onConnected()");
            this.mConnected = true;
            if (this.mIceConnected) {
                this.connected();
            }
        }

        @Override
        public void onIceDisconnected() {
            Logger.d(DirectCall.this.tag() + "[PCE] onIceDisconnected()");
            this.mIceConnected = false;
            this.disconnected();
        }

        @Override
        public void onIceFailed() {
            Logger.d(DirectCall.this.tag() + "[PCE] onIceFailed()");
        }

        @Override
        public void onDisconnected() {
            Logger.d(DirectCall.this.tag() + "[PCE] onDisconnected()");
            this.mConnected = false;
        }

        @Override
        public void onFailed() {
            Logger.d(DirectCall.this.tag() + "[PCE] onFailed()");
        }

        @Override
        public void onPeerConnectionClosed() {
            Logger.d(DirectCall.this.tag() + "[PCE] onPeerConnectionClosed()");
            this.mIceConnected = false;
            this.mConnected = false;
            this.mDisconnected = false;
            DirectCall.this.onClosed();
        }

        @Override
        public void onPeerConnectionStatsReady(StatsReport[] reports) {
        }

        @Override
        public void onPeerConnectionError(String description) {
            Logger.e(DirectCall.this.tag() + "[PCE] onPeerConnectionError() => " + description);
            DirectCall.this.mCurrentState.unknownEnd(DirectCall.this);
        }

        @Override
        public void onPeerConnectionAudioError(String description) {
            Logger.e(DirectCall.this.tag() + "[PCE] onPeerConnectionAudioError() => " + description);
        }

        @Override
        public void onPacketLost() {
            Logger.d(DirectCall.this.tag() + "[PCE] onPacketLost()");
            DirectCall.this.mCurrentState.onPacketLost(DirectCall.this);
        }
    };

    DirectCall(Context context, CommandSender sender, String calleeId, boolean isVideoCall, @NonNull CallOptions callOptions, DialHandler dialHandler, RingingListener ringingListener) {
        Logger.d("[DirectCall] DirectCall() as caller");
        this.mContext = context;
        this.mCommandSender = sender;
        this.mRingingListener = ringingListener;
        this.mIsVideoCall = isVideoCall;
        this.mAmICallee = false;
        this.mMyRole = DirectCallUserRole.CALLER;
        this.mCallOptions = callOptions;
        this.mCurrentState = new DirectCallIdleState(calleeId, dialHandler);
        this.mCurrentState.onCreate(this);
    }

    DirectCall(Context context, CommandSender sender, DialPushCommand command, RingingListener ringingListener) {
        Logger.d("[DirectCall] DirectCall(command: DialPushCommand) as callee");
        this.mContext = context;
        this.mCommandSender = sender;
        this.mRingingListener = ringingListener;
        this.mIsVideoCall = command.isVideoCall();
        this.mAmICallee = true;
        this.mMyRole = DirectCallUserRole.CALLEE;
        this.mCallId = command.getCallId();
        this.mCaller = command.getCaller();
        this.mCallee = command.getCallee();
        this.setRemoteConstraints(command.getConstraints());
        this.mTurnCredential = command.getTurnCredential();
        this.mCurrentState = new DirectCallRingingState();
        this.mCurrentState.onCreate(this);
    }

    DirectCall(Context context, CommandSender sender, CancelPushCommand command, RingingListener ringingListener) {
        Logger.d("[DirectCall] DirectCall(command: CancelPushCommand) as callee");
        this.mContext = context;
        this.mCommandSender = sender;
        this.mRingingListener = ringingListener;
        this.mIsVideoCall = command.getEndedCallLog().isVideoCall();
        this.mAmICallee = true;
        this.mMyRole = DirectCallUserRole.CALLEE;
        this.mCallId = command.getCallId();
        this.mCaller = command.getEndedCallLog().getCaller();
        this.mCallee = command.getEndedCallLog().getCallee();
        this.setEndedCall(DirectCallEndResult.CANCELED, command.getEndedCallLog());
        this.mCurrentState = new DirectCallCanceledState();
        this.mCurrentState.onCreate(this);
    }

    public String getCallId() {
        return this.mCallId;
    }

    public boolean isVideoCall() {
        return this.mIsVideoCall;
    }

    public DirectCallUser getCaller() {
        return this.mCaller;
    }

    public DirectCallUser getCallee() {
        return this.mCallee;
    }

    public DirectCallUser getLocalUser() {
        if (this.mAmICallee) {
            return this.mCallee;
        }
        return this.mCaller;
    }

    public DirectCallUser getRemoteUser() {
        if (this.mAmICallee) {
            return this.mCaller;
        }
        return this.mCallee;
    }

    public DirectCallUserRole getMyRole() {
        return this.mMyRole;
    }

    public DirectCallUser getEndedBy() {
        return this.mEndedBy;
    }

    public DirectCallEndResult getEndResult() {
        return this.mEndResult;
    }

    public long getDuration() {
        long duration = this.mDuration;
        if (duration == 0L && this.mStartTimestamp > 0L) {
            duration = Math.max(System.currentTimeMillis() - this.mStartTimestamp, 0L);
        }
        Logger.d(this.tag() + "getDuration() => " + duration);
        return duration;
    }

    public void setListener(DirectCallListener listener) {
        Logger.d(this.tag() + "setListener()");
        this.mListener = listener;
    }

    public void accept(CallOptions callOptions) {
        Logger.d(this.tag() + "accept()");
        if (callOptions == null) {
            callOptions = new CallOptions();
        }
        this.mCurrentState.accept(this, callOptions);
        this.mCallOptions = callOptions;
        this.setLocalVideoEnabled(callOptions.mVideoEnabled);
        this.setLocalAudioEnabled(callOptions.mAudioEnabled);
        this.createPeerConnection(this.mTurnCredential);
    }

    public void end() {
        Logger.d(this.tag() + "end()");
        this.mCurrentState.end(this);
    }

    public boolean isEnded() {
        boolean isEnded = false;
        if (this.mCurrentState instanceof DirectCallEndingState || this.mCurrentState instanceof DirectCallEndedState) {
            isEnded = true;
        }
        Logger.d(this.tag() + "isEnded() => " + isEnded);
        return isEnded;
    }

    public boolean isLocalAudioEnabled() {
        return this.mIsLocalAudioEnabled;
    }

    public boolean isRemoteAudioEnabled() {
        return this.mIsRemoteAudioEnabled;
    }

    public void muteMicrophone() {
        Logger.d(this.tag() + "muteMicrophone()");
        if (this.mPeerConnectionClient != null && this.isWebRtcConnected()) {
            this.mPeerConnectionClient.setAudioEnabled(false);
            this.setLocalAudioEnabled(false);
            AudioStatusRequest request = new AudioStatusRequest(this.mCallId, false);
            this.mCommandSender.send((Command)request, null);
        }
    }

    public void unmuteMicrophone() {
        Logger.d(this.tag() + "unmuteMicrophone()");
        if (this.mPeerConnectionClient != null && this.isWebRtcConnected()) {
            this.mPeerConnectionClient.setAudioEnabled(true);
            this.setLocalAudioEnabled(true);
            AudioStatusRequest request = new AudioStatusRequest(this.mCallId, true);
            this.mCommandSender.send((Command)request, null);
        }
    }

    void changeState(@NonNull DirectCallState nextState) {
        Logger.d(this.tag() + "changeState(). " + this.mCurrentState.getStateName() + " => " + nextState.getStateName());
        if (this.mCurrentState.getStateName().equals(nextState.getStateName())) {
            return;
        }
        this.mCurrentState.onDestroy(this);
        this.mCurrentState = nextState;
        this.mCurrentState.onCreate(this);
    }

    void updateStartTimestamp() {
        Logger.d(this.tag() + "updateStartTimestamp()");
        this.mStartTimestamp = System.currentTimeMillis();
    }

    void updateEndTimestamp() {
        this.mEndTimestamp = System.currentTimeMillis();
        if (this.mStartTimestamp > 0L) {
            this.mDuration = Math.max(this.mEndTimestamp - this.mStartTimestamp, 0L);
        }
        Logger.d(this.tag() + "updateEndTimestamp() => mDuration: " + this.mDuration);
    }

    void startStateTimer(long delayMillis) {
        Logger.d(this.tag() + "[" + this.mCurrentState.getStateName() + "] => startStateTimer(" + delayMillis + ")");
        this.mStateTimer = new Timer();
        this.mStateTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                DirectCall.this.mCurrentState.timeout(DirectCall.this);
            }
        }, delayMillis);
    }

    void stopStateTimer() {
        Logger.d(this.tag() + "[" + this.mCurrentState.getStateName() + "] => stopStateTimer()");
        this.mStateTimer.cancel();
    }

    void startAliveTimer() {
        Logger.d(this.tag() + "[" + this.mCurrentState.getStateName() + "] => startAliveTimer(" + 10000L + ")");
        this.mAliveTimer = new Timer();
        this.mAliveTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!TextUtils.isEmpty((CharSequence)DirectCall.this.mCallId)) {
                    AliveRequest aliveRequest = new AliveRequest(DirectCall.this.mCallId);
                    DirectCall.this.mCommandSender.send((Command)aliveRequest, null);
                }
            }
        }, 0L, 10000L);
    }

    void stopAliveTimer() {
        Logger.d(this.tag() + "[" + this.mCurrentState.getStateName() + "] => stopAliveTimer()");
        this.mAliveTimer.cancel();
    }

    void sendDialRequest(String calleeId) {
        Logger.d(this.tag() + "sendDialRequest(calleeId: " + calleeId + ")");
        DialRequest request = new DialRequest(calleeId, this.mIsVideoCall, this.mCallOptions.mVideoEnabled, this.mCallOptions.mAudioEnabled);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (e == null && response instanceof DialResponse) {
                this.mIsVideoCall = ((DialResponse)response).isVideoCall();
                this.mCallId = ((DialResponse)response).getCallId();
                this.mCaller = ((DialResponse)response).getCaller();
                this.mCallee = ((DialResponse)response).getCallee();
                this.setLocalVideoEnabled(this.mCallOptions.mVideoEnabled);
                this.setLocalAudioEnabled(this.mCallOptions.mAudioEnabled);
            } else {
                this.setLocalEndedCall(DirectCallEndResult.DIAL_FAILED);
            }
            this.mCurrentState.onDialAckReceived(this, e);
        });
    }

    void sendAcceptRequest(CallOptions callOptions) {
        Logger.d(this.tag() + "sendAcceptRequest()");
        AcceptRequest request = new AcceptRequest(this.mCallId, callOptions.mVideoEnabled, callOptions.mAudioEnabled);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (e != null) {
                this.setLocalEndedCall(DirectCallEndResult.ACCEPT_FAILED);
            }
            this.mCurrentState.onAcceptAckReceived(this, e);
        });
    }

    void createOffer() {
        Logger.d(this.tag() + "createOffer()");
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.createOffer();
        }
    }

    void createAnswer() {
        Logger.d(this.tag() + "createAnswer()");
        if (this.mPeerConnectionClient != null) {
            this.mPeerConnectionClient.createAnswer();
        }
    }

    void setRemoteDescription(SessionDescription.Type type, String sdp) {
        Logger.d(this.tag() + "setRemoteDescription(type: " + type.canonicalForm() + ")");
        if (sdp != null && sdp.length() > 0 && this.mPeerConnectionClient != null) {
            SessionDescription sessionDescription = new SessionDescription(type, sdp);
            this.mPeerConnectionClient.setRemoteDescription(sessionDescription);
        }
    }

    void sendCancelRequest() {
        Logger.d(this.tag() + "sendCancelRequest()");
        this.setLocalEndedCall(DirectCallEndResult.CANCELED);
        CancelRequest request = new CancelRequest(this.mCallId);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (response instanceof CancelResponse) {
                this.setEndedCall(DirectCallEndResult.CANCELED, ((CancelResponse)response).getEndedCallLog());
            }
            this.mCurrentState.onCancelAckReceived(this, e);
        });
    }

    void sendDeclineRequest() {
        Logger.d(this.tag() + "sendDeclineRequest()");
        this.setLocalEndedCall(DirectCallEndResult.DECLINED);
        DeclineRequest request = new DeclineRequest(this.mCallId);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (response instanceof DeclineResponse) {
                this.setEndedCall(DirectCallEndResult.DECLINED, ((DeclineResponse)response).getEndedCallLog());
            }
            this.mCurrentState.onDeclineAckReceived(this, e);
        });
    }

    void sendNoAnswerRequest() {
        Logger.d(this.tag() + "sendNoAnswerRequest()");
        this.setLocalEndedCall(DirectCallEndResult.NO_ANSWER);
        NoAnswerRequest request = new NoAnswerRequest(this.mCallId);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (response instanceof NoAnswerResponse) {
                this.setEndedCall(DirectCallEndResult.NO_ANSWER, ((NoAnswerResponse)response).getEndedCallLog());
            }
            this.mCurrentState.onNoAnswerAckReceived(this, e);
        });
    }

    void sendEndRequest() {
        Logger.d(this.tag() + "sendEndRequest()");
        this.setLocalEndedCall(DirectCallEndResult.COMPLETED);
        EndRequest request = new EndRequest(this.mCallId);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (response instanceof EndResponse) {
                this.setEndedCall(DirectCallEndResult.COMPLETED, ((EndResponse)response).getEndedCallLog());
            }
            this.mCurrentState.onEndAckReceived(this, e);
        });
    }

    void sendUnknownEndRequest() {
        Logger.d(this.tag() + "sendUnknownEndRequest()");
        this.setLocalEndedCall(DirectCallEndResult.UNKNOWN);
        UnknownEndRequest request = new UnknownEndRequest(this.mCallId);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (response instanceof UnknownEndResponse) {
                this.setEndedCall(DirectCallEndResult.UNKNOWN, ((UnknownEndResponse)response).getEndedCallLog());
            }
            this.mCurrentState.onUnknownEndAckReceived(this, e);
        });
    }

    void sendTimeoutRequest(@NonNull TimeoutRequest.Reason reason) {
        Logger.d(this.tag() + "sendTimeoutRequest()");
        this.setLocalEndedCall(DirectCallEndResult.TIMED_OUT);
        TimeoutRequest request = new TimeoutRequest(this.mCallId, reason);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (response instanceof TimeoutResponse) {
                this.setEndedCall(DirectCallEndResult.TIMED_OUT, ((TimeoutResponse)response).getEndedCallLog());
            }
            this.mCurrentState.onTimeoutAckReceived(this, e);
        });
    }

    void sendConnectionLostRequest(ConnectionLostRequest.Reason reason) {
        Logger.d(this.tag() + "sendConnectionLostRequest()");
        this.setLocalEndedCall(DirectCallEndResult.CONNECTION_LOST);
        ConnectionLostRequest request = new ConnectionLostRequest(this.mCallId, reason);
        this.mCommandSender.send((Command)request, (response, e) -> {
            if (response instanceof ConnectionLostResponse) {
                this.setEndedCall(DirectCallEndResult.CONNECTION_LOST, ((ConnectionLostResponse)response).getEndedCallLog());
            }
        });
    }

    void abort() {
        Logger.d(this.tag() + "abort()");
        this.setLocalEndedCall(DirectCallEndResult.CANCELED);
        this.close();
    }

    void close() {
        Logger.d(this.tag() + "close()");
        this.closePeerConnectionClient();
    }

    void dispatchEvent(DirectCallEventType type) {
        Logger.d(this.tag() + "dispatchEvent(type: " + (Object)((Object)type) + "), mListener = " + this.mListener);
        if (type == DirectCallEventType.RINGING && this.mRingingListener != null) {
            this.mRingingListener.onRinging(this);
            return;
        }
        if (this.mListener == null) {
            return;
        }
        switch (type) {
            case ESTABLISHED: {
                SendBirdCall.runOnThreadOption(() -> {
                    if (this.mListener != null) {
                        this.mListener.onEstablished(this);
                    }
                });
                return;
            }
            case CONNECTED: {
                SendBirdCall.runOnThreadOption(() -> {
                    if (this.mListener != null) {
                        this.mListener.onConnected(this);
                    }
                });
                return;
            }
            case ENDED: {
                SendBirdCall.runOnThreadOption(() -> {
                    if (this.mListener != null) {
                        this.mListener.onEnded(this);
                    }
                });
                return;
            }
            case RECONNECTED: {
                return;
            }
            case DISCONNECTED: {
                return;
            }
        }
    }

    private void sendOfferRequest(@NonNull String sdp) {
        Logger.d(this.tag() + "sendOfferRequest()");
        OfferRequest request = new OfferRequest(this.mCallId, sdp);
        this.mCommandSender.send((Command)request, null);
    }

    private void sendAnswerRequest(@NonNull String sdp) {
        Logger.d(this.tag() + "sendAnswerRequest()");
        AnswerRequest request = new AnswerRequest(this.mCallId, sdp);
        this.mCommandSender.send((Command)request, null);
    }

    private void sendCandidateRequest(@NonNull IceCandidate candidate) {
        Logger.d(this.tag() + "sendCandidateRequest()");
        CandidateRequest request = new CandidateRequest(this.mCallId, new Candidate(candidate.sdp, candidate.sdpMLineIndex, candidate.sdpMid));
        this.mCommandSender.send((Command)request, null);
    }

    private void sendRemoveCandidatesRequest(@NonNull IceCandidate[] removeCandidates) {
        Logger.d(this.tag() + "sendRemoveCandidatesRequest()");
        ArrayList<Candidate> candidates = new ArrayList<Candidate>();
        for (IceCandidate candidate : removeCandidates) {
            candidates.add(new Candidate(candidate.sdp, candidate.sdpMLineIndex, candidate.sdpMid));
        }
        RemoveCandidatesRequest request = new RemoveCandidatesRequest(this.mCallId, candidates);
        this.mCommandSender.send((Command)request, null);
    }

    private boolean isWebRtcConnected() {
        return this.mCurrentState instanceof DirectCallConnectedState;
    }

    private void setRemoteConstraints(Constraints constraints) {
        this.setRemoteAudioEnabled(constraints.getAudioConstraints());
        this.setRemoteVideoEnabled(constraints.getVideoConstraints());
    }

    private void createPeerConnection(TurnCredential turnCredential) {
        String userName = turnCredential.getUserName();
        String password = turnCredential.getPassword();
        List turnUrls = turnCredential.getTurnUrls();
        ArrayList<PeerConnection.IceServer> iceServers = new ArrayList<PeerConnection.IceServer>();
        if (userName != null && password != null && turnUrls != null && turnUrls.size() > 0) {
            for (String turnUrl : turnUrls) {
                PeerConnection.IceServer turnServer = PeerConnection.IceServer.builder((String)turnUrl).setUsername(userName).setPassword(password).createIceServer();
                iceServers.add(turnServer);
            }
        }
        this.mPeerConnectionClient = PeerConnectionClientFactory.create(this.mContext, this.mIsVideoCall, this.mCallOptions, iceServers, this.mPeerConnectionEvents);
    }

    private void setLocalEndedCall(@NonNull DirectCallEndResult endResult) {
        Logger.d(this.tag() + "setLocalEndedCall(endResult: " + endResult + ")");
        this.mEndResult = endResult;
        this.mEndedBy = this.getLocalUser();
    }

    private void setEndedCall(@NonNull DirectCallEndResult endResult, @NonNull DirectCallLog endedCallLog) {
        Logger.d(this.tag() + "setEndedCall(endResult: " + endResult + ", duration: " + endedCallLog.getDuration() + ")");
        this.mEndResult = endResult;
        this.mEndedBy = endedCallLog.getEndedBy();
        this.mDuration = endedCallLog.getDuration();
        this.mCaller = endedCallLog.getCaller();
        this.mCallee = endedCallLog.getCallee();
    }

    private void closePeerConnectionClient() {
        if (this.mPeerConnectionClient != null) {
            Logger.d(this.tag() + "closePeerConnectionClient()");
            this.mPeerConnectionClient.close();
        } else {
            this.onClosed();
        }
    }

    private void onClosed() {
        Logger.d(this.tag() + "onClosed()");
        this.mCurrentState.onClosed(this);
    }

    private void setLocalVideoEnabled(boolean isEnabled) {
        Logger.d(this.tag() + "setLocalVideoEnabled(isEnabled: " + isEnabled + ")");
        this.mIsLocalVideoEnabled = this.mIsVideoCall ? isEnabled : false;
    }

    private void setLocalAudioEnabled(boolean isEnabled) {
        Logger.d(this.tag() + "setLocalAudioEnabled(isEnabled: " + isEnabled + ")");
        this.mIsLocalAudioEnabled = isEnabled;
    }

    private void setRemoteVideoEnabled(boolean isEnabled) {
    }

    private void setRemoteAudioEnabled(boolean isEnabled) {
        Logger.d(this.tag() + "setRemoteAudioEnabled(isEnabled: " + isEnabled + ")");
        boolean isToggled = this.mIsRemoteAudioEnabled != isEnabled;
        this.mIsRemoteAudioEnabled = isEnabled;
        if (isToggled && this.mListener != null) {
            SendBirdCall.runOnThreadOption(() -> {
                if (this.mListener != null) {
                    this.mListener.onRemoteAudioSettingsChanged(this);
                }
            });
        }
    }

    private String tag() {
        return this.mAmICallee ? "[DirectCall][Callee] " : "[DirectCall][Caller] ";
    }

    void onDialReceived() {
        Logger.d(this.tag() + "onDialReceived()");
        this.mCurrentState.onDialReceived(this);
    }

    void onEvent(Command command) {
        Logger.d(this.tag() + "onEvent(command: " + command.getClass().getSimpleName() + ")");
        if (command instanceof AcceptPushCommand) {
            this.setRemoteConstraints(((AcceptPushCommand)command).getConstraints());
            this.createPeerConnection(((AcceptPushCommand)command).getTurnCredential());
            this.mCurrentState.onAcceptReceived(this);
        } else if (command instanceof OtherDeviceAcceptedPushCommand) {
            this.setLocalEndedCall(DirectCallEndResult.OTHER_DEVICE_ACCEPTED);
            this.mCurrentState.onOtherDeviceAccepted(this);
        } else if (command instanceof OfferPushCommand) {
            String sdp = ((OfferPushCommand)command).getSdp();
            StringUtils.uncompress(sdp, result -> this.mCurrentState.onOfferReceived(this, result));
        } else if (command instanceof AnswerPushCommand) {
            String sdp = ((AnswerPushCommand)command).getSdp();
            StringUtils.uncompress(sdp, result -> this.mCurrentState.onAnswerReceived(this, result));
        } else if (command instanceof CandidatePushCommand) {
            Candidate candidate = ((CandidatePushCommand)command).getCandidate();
            if (candidate != null) {
                IceCandidate iceCandidate = new IceCandidate(candidate.getSdpMid(), candidate.getSdpMlineIndex(), candidate.getSdp());
                if (this.mPeerConnectionClient != null) {
                    this.mPeerConnectionClient.addRemoteIceCandidate(iceCandidate);
                }
            }
        } else if (command instanceof RemoveCandidatesPushCommand) {
            List candidateList = ((RemoveCandidatesPushCommand)command).getCandidates();
            if (candidateList != null && candidateList.size() > 0) {
                IceCandidate[] iceCandidates = new IceCandidate[candidateList.size()];
                for (int i = 0; i < candidateList.size(); ++i) {
                    Candidate candidate = (Candidate)candidateList.get(i);
                    if (candidate == null) continue;
                    iceCandidates[i] = new IceCandidate(candidate.getSdpMid(), candidate.getSdpMlineIndex(), candidate.getSdp());
                }
                if (this.mPeerConnectionClient != null) {
                    this.mPeerConnectionClient.removeRemoteIceCandidates(iceCandidates);
                }
            }
        } else if (command instanceof VideoStatusPushCommand) {
            boolean isEnabled = ((VideoStatusPushCommand)command).isEnabled();
            this.setRemoteVideoEnabled(isEnabled);
        } else if (command instanceof AudioStatusPushCommand) {
            boolean isEnabled = ((AudioStatusPushCommand)command).isEnabled();
            this.setRemoteAudioEnabled(isEnabled);
        } else if (command instanceof CancelPushCommand) {
            this.setEndedCall(DirectCallEndResult.CANCELED, ((CancelPushCommand)command).getEndedCallLog());
            this.mCurrentState.onCancelReceived(this);
        } else if (command instanceof DeclinePushCommand) {
            this.setEndedCall(DirectCallEndResult.DECLINED, ((DeclinePushCommand)command).getEndedCallLog());
            this.mCurrentState.onDeclineReceived(this);
        } else if (command instanceof NoAnswerPushCommand) {
            this.setEndedCall(DirectCallEndResult.NO_ANSWER, ((NoAnswerPushCommand)command).getEndedCallLog());
            this.mCurrentState.onNoAnswerReceived(this);
        } else if (command instanceof EndPushCommand) {
            this.setEndedCall(DirectCallEndResult.COMPLETED, ((EndPushCommand)command).getEndedCallLog());
            this.mCurrentState.onEndReceived(this);
        } else if (command instanceof UnknownEndPushCommand) {
            this.setEndedCall(DirectCallEndResult.UNKNOWN, ((UnknownEndPushCommand)command).getEndedCallLog());
            this.mCurrentState.onUnknownEndReceived(this);
        } else if (command instanceof TimeoutPushCommand) {
            this.setEndedCall(DirectCallEndResult.TIMED_OUT, ((TimeoutPushCommand)command).getEndedCallLog());
            this.mCurrentState.onTimeoutReceived(this);
        } else if (command instanceof ConnectionLostPushCommand) {
            this.setEndedCall(DirectCallEndResult.CONNECTION_LOST, ((ConnectionLostPushCommand)command).getEndedCallLog());
            this.mCurrentState.onConnectionLostReceived(this);
        }
    }

    void setStateTimerDelay(long delayMillis) {
        this.stopStateTimer();
        this.startStateTimer(delayMillis);
    }

    static enum DirectCallEventType {
        ESTABLISHED,
        CONNECTED,
        DISCONNECTED,
        RECONNECTED,
        ENDED,
        RINGING;

    }
}

