/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import android.content.Context;
import android.support.annotation.NonNull;
import com.sendbird.call.CallOptions;
import com.sendbird.call.CallPushCommand;
import com.sendbird.call.CancelPushCommand;
import com.sendbird.call.Command;
import com.sendbird.call.CommandSender;
import com.sendbird.call.DialPushCommand;
import com.sendbird.call.DirectCall;
import com.sendbird.call.EventListener;
import com.sendbird.call.Logger;
import com.sendbird.call.RingingListener;
import com.sendbird.call.SendBirdCall;
import com.sendbird.call.handler.DialHandler;
import com.sendbird.call.handler.SendBirdCallListener;
import java.util.concurrent.ConcurrentHashMap;

class CallManager
implements EventListener,
RingingListener {
    @NonNull
    private Context mContext;
    @NonNull
    private ConcurrentHashMap<String, DirectCall> mCallMap;
    @NonNull
    private CommandSender mCommandSender;
    @NonNull
    private ConcurrentHashMap<String, SendBirdCallListener> mSendBirdCallListeners;

    CallManager(@NonNull Context context, @NonNull CommandSender commandSender) {
        this.mContext = context;
        this.mCallMap = new ConcurrentHashMap();
        this.mCommandSender = commandSender;
        this.mSendBirdCallListeners = new ConcurrentHashMap();
    }

    DirectCall getCall(String callId) {
        DirectCall call = null;
        if (callId != null) {
            call = this.mCallMap.get(callId);
            Logger.d("[CallManager] getCall(callId: " + callId + ") => " + (call != null));
        }
        return call;
    }

    void addSendBirdCallListener(String identifier, SendBirdCallListener listener) {
        Logger.d("[CallManager] addListener(identifier: " + identifier + ")");
        this.mSendBirdCallListeners.put(identifier, listener);
    }

    SendBirdCallListener removeSendBirdCallListener(String identifier) {
        Logger.d("[CallManager] removeListener(identifier: " + identifier + ")");
        return this.mSendBirdCallListeners.remove(identifier);
    }

    void removeAllSendBirdCallListeners() {
        Logger.d("[CallManager] removeAllListeners()");
        for (String identifier : this.mSendBirdCallListeners.keySet()) {
            this.removeSendBirdCallListener(identifier);
        }
    }

    DirectCall dial(String calleeId, boolean isVideoCall, CallOptions callOptions, DialHandler handler) {
        Logger.d("[CallManager] dial(calleeId: " + calleeId + ")");
        DirectCall directCall = new DirectCall(this.mContext, this.mCommandSender, calleeId, isVideoCall, callOptions, (call, e) -> {
            if (e != null) {
                if (handler != null) {
                    SendBirdCall.runOnThreadOption(() -> handler.onResult(null, e));
                }
                return;
            }
            this.putCall(call);
            if (handler != null) {
                SendBirdCall.runOnThreadOption(() -> handler.onResult(call, null));
            }
        }, this);
        return directCall;
    }

    private void putCall(@NonNull DirectCall call) {
        Logger.d("[CallManager] putCall(callId: " + call.getCallId() + ")");
        if (call.getCallId() != null) {
            this.mCallMap.put(call.getCallId(), call);
        }
    }

    private void removeCall(@NonNull DirectCall call) {
        Logger.d("[CallManager] removeCall(callId: " + call.getCallId() + ")");
        if (call.getCallId() != null) {
            this.mCallMap.remove(call.getCallId());
        }
    }

    private void onDialReceived(@NonNull DialPushCommand command) {
        DirectCall call = this.getCall(command.getCallId());
        if (call == null) {
            call = new DirectCall(this.mContext, this.mCommandSender, command, (RingingListener)this);
            this.putCall(call);
        } else {
            call.onDialReceived();
        }
    }

    private void onCancelReceivedWithoutCall(@NonNull CancelPushCommand command) {
        DirectCall call = new DirectCall(this.mContext, this.mCommandSender, command, (RingingListener)this);
        this.putCall(call);
    }

    @Override
    public void onEvent(@NonNull Command command) {
        if (command instanceof DialPushCommand) {
            Logger.d("[CallManager] onEvent(command: DialPushCommand)");
            this.onDialReceived((DialPushCommand)command);
        } else if (command instanceof CallPushCommand) {
            String callId = ((CallPushCommand)command).getCallId();
            DirectCall call = this.getCall(callId);
            if (call == null && command instanceof CancelPushCommand) {
                Logger.d("[CallManager] onEvent(command: CancelPushCommand, callId: " + callId + ")");
                this.onCancelReceivedWithoutCall((CancelPushCommand)command);
                return;
            }
            Logger.d("[CallManager] onEvent(command: CallPushCommand, callId: " + callId + ")");
            if (call != null) {
                call.onEvent(command);
            }
        }
    }

    @Override
    public void onRinging(DirectCall call) {
        for (String identifier : this.mSendBirdCallListeners.keySet()) {
            SendBirdCallListener handler = this.mSendBirdCallListeners.get(identifier);
            if (handler == null) continue;
            Logger.d("[CallManager] onRinging(callId: " + call.getCallId() + ")");
            SendBirdCall.runOnThreadOption(() -> handler.onRinging(call));
        }
    }

    void endAllCalls() {
        Logger.d("[CallManager] endAllCalls() calls = " + this.mCallMap.size());
        for (String key : this.mCallMap.keySet()) {
            DirectCall call = this.mCallMap.get(key);
            if (call == null || call.isEnded()) continue;
            call.end();
        }
        this.mCallMap.clear();
    }

    void clearAllCalls() {
        for (String key : this.mCallMap.keySet()) {
            this.mCallMap.get(key).setListener(null);
        }
        this.mCallMap.clear();
    }
}

