/*
 * Decompiled with CFR 0.152.
 */
package com.sendbird.call;

import com.sendbird.call.DirectCallEndResult;
import com.sendbird.call.DirectCallUser;
import com.sendbird.call.DirectCallUserRole;
import com.sendbird.call.shadow.com.google.gson.annotations.SerializedName;
import java.util.List;

public class DirectCallLog {
    @SerializedName(value="call_id")
    private String mCallId;
    @SerializedName(value="started_at")
    private long mStartedAt = 0L;
    @SerializedName(value="ended_at")
    private long mEndedAt = 0L;
    @SerializedName(value="duration")
    private long mDuration = 0L;
    @SerializedName(value="user_role")
    private DirectCallUserRole mMyRole;
    @SerializedName(value="ended_by")
    private String mEndedBy;
    @SerializedName(value="participants")
    private List<DirectCallUser> mUsers;
    @SerializedName(value="end_result")
    private DirectCallEndResult mEndResult;
    @SerializedName(value="is_video_call")
    private boolean mIsVideoCall;

    public String getCallId() {
        return this.mCallId;
    }

    public long getStartedAt() {
        return this.mStartedAt;
    }

    public long getEndedAt() {
        return this.mEndedAt;
    }

    public long getDuration() {
        return this.mDuration;
    }

    public DirectCallUserRole getMyRole() {
        return this.mMyRole;
    }

    public DirectCallUser getEndedBy() {
        if (this.mEndedBy == null) {
            return null;
        }
        for (DirectCallUser user : this.mUsers) {
            if (!user.getUserId().equals(this.mEndedBy)) continue;
            return user;
        }
        return null;
    }

    public DirectCallUser getCaller() {
        for (DirectCallUser user : this.mUsers) {
            if (user.getRole() != DirectCallUserRole.CALLER) continue;
            return user;
        }
        return null;
    }

    public DirectCallUser getCallee() {
        for (DirectCallUser user : this.mUsers) {
            if (user.getRole() != DirectCallUserRole.CALLEE) continue;
            return user;
        }
        return null;
    }

    public DirectCallEndResult getEndResult() {
        return this.mEndResult;
    }

    public boolean isVideoCall() {
        return this.mIsVideoCall;
    }
}

